/*
 * SCI_Code_V3.c
 *
 *  Created on: 27 Sep 2018
 *      Author: Ed
 *
 *      Serial Terminal Interface
 *
 */



// Based on F2837xD_sci_io.c

//
// Included Files
//
#include <stdio.h>
#include <file.h>
#include "F28x_Project.h"
#include "SCIB_Code_V3.h"
#include "SCIC_Code_V1.h"
#include "Host_Comm_v2.h"

//
// Globals
//


uint16_t deviceOpen = 0;
extern Uint16 Syncd; //Global SCIB syncd state

extern Uint16 COM_B_CMD;
extern char COM_B_DATA[20];
//
// SCI_open - Initialize and setup SCI
//
int SCIB_open()
{
    if(deviceOpen)
    {
        return (-1);
    }
    else
    {

 //       SciaRegs.SCIHBAUD.all = 0x0000;
 //       SciaRegs.SCILBAUD.all = 0x000F;
 //       SciaRegs.SCICCR.bit.LOOPBKENA = 1; // Enable loop back

        EALLOW;
        CpuSysRegs.PCLKCR7.bit.SCI_B = 1;
  //      ScibRegs.SCIFFTX.all=0x0000;
  //      ScibRegs.SCIFFRX.all=0x0000;
   //     ScibRegs.SCIFFCT.all=0x0;
   //     ScibRegs.SCIFFTX.all=0xE040;
   //     ScibRegs.SCIFFRX.all=0x2044;
        ScibRegs.SCIFFTX.all=0xE001;
        ScibRegs.SCIFFRX.all=0x2003;
        ScibRegs.SCIFFCT.all=0x0;
        ScibRegs.SCICCR.all =0x0007;   // 1 stop bit,  No loopback
                                       // No parity,8 char bits,
                                       // async mode, idle-line protocol
        ScibRegs.SCICTL1.all =0x0003;  // enable TX, RX, internal SCICLK,
                                       // Disable RX ERR, SLEEP, TXWAKE
        ScibRegs.SCIHBAUD.bit.BAUD =0x0002;  // 9600 baud//(200 MHz SYSCLK/4).
        ScibRegs.SCILBAUD.bit.BAUD =0x008a;

  //      ScibRegs.SCIHBAUD.bit.BAUD =0x0000;  // 115200 baud//(200 MHz SYSCLK/4).
  //      ScibRegs.SCILBAUD.bit.BAUD =0x0035;

        ScibRegs.SCICTL2.all = 0x0000;
        ScibRegs.SCICTL2.bit.TXINTENA = 0;
    //    ScibRegs.SCICTL2.bit.RXBKINTENA = 0;
        ScibRegs.SCIFFRX.bit.RXFFIENA = 1;

        ScibRegs.SCICTL1.all |= 0x0020;  // Relinquish SCI from Reset
        ScibRegs.SCIFFTX.bit.TXFIFORESET = 1;
        ScibRegs.SCIFFRX.bit.RXFIFORESET = 1;


       // ScibRegs.SCICCR.bit.LOOPBKENA = 1; // Enable loop back
        EDIS;

        deviceOpen = 1;
        return (1);
    }
}

//
// SCIB_close - Set SCI to closed
//
int SCIB_close(int dev_fd)
{
    if((dev_fd != 1) || (!deviceOpen))
    {
        return (-1);
    }
    else
    {
        deviceOpen = 0;
        return (0);
    }
}

int SCIB_read_LF(Uint16 *CMD, char *DATA, Uint32 timeout)
{
    char tmp[20];
    char curr=0, pre_curr=0;
    int end = 0, i=0, num=0;
    Uint32 t_out_c = 0;

  //  uint16_t * CMDPtr = (uint16_t *)CMD;
    uint16_t * DATAPtr = (uint16_t *)DATA;
    uint16_t * tmpPtr = (uint16_t *)tmp;
    uint16_t readCount = 0;

    while(!end)
    {
   //     if(Cap_Done_Mess)
 //       {
   //         SCIB_write(0,"Cap_Done \n\r");
    //        Cap_Done_Mess = 0;
    //    }

        t_out_c++;
        if(t_out_c>timeout)
            {
                end=1;
                GpioDataRegs.GPCCLEAR.bit.GPIO84 = 1;
                return(0);
            }

        if(ScibRegs.SCIFFRX.bit.RXFFST)
        {
            pre_curr = curr;
            curr = 0;
            curr = ScibRegs.SCIRXBUF.bit.SAR;
            *tmpPtr = curr;
            if(*tmpPtr == COMMS_RESET)
            {
                ScibRegs.SCIFFRX.bit.RXFIFORESET=0;
                readCount=0;
                tmpPtr=0;
                ScibRegs.SCIFFRX.bit.RXFIFORESET=1;
                Syncd = 0;
                return(3);
            }
            if((curr==0x0A)&&(pre_curr==0x0D))
            {
                end=1;
                tmpPtr++;
                readCount++;
            }
            else
            {
                tmpPtr++;
                readCount++;
                end=0;
            }

            if(readCount==20)
            {
                tmpPtr = (uint16_t *)tmp;
                readCount=0;
            }

         }
    }

    tmpPtr -= readCount;

    *CMD = (0xff00&*tmpPtr++<<8)|(0x00ff&*tmpPtr++);

  //  *CMDPtr++ = *tmpPtr++;
   // *CMDPtr++ = *tmpPtr++;

   //COM_B_CMD = (((*tmpPtr<<8)&0xFF00)|*(++bufPtr));

    num = readCount-4;

 //   bufPtr2 += (num-1);

    for(i=0;i<num;i++)
    {
        *DATAPtr++ = *tmpPtr++;
    }



  //  ScibRegs.SCIFFRX.bit.RXFFINTCLR = 1;
    return (readCount);
}
//
// SCIB_read - Read from the SCI RX buffer
//
int SCIB_read(int dev_fd, char * buf, unsigned count)
{
    uint16_t readCount = 0;
    uint16_t * bufPtr = (uint16_t *) buf;

    if(count == 0)
    {
        return (0);
    }

    while(readCount < count)
    {
        if(ScibRegs.SCIFFRX.bit.RXFFST)
        {
            *bufPtr = ScibRegs.SCIRXBUF.bit.SAR;
            if(*bufPtr == COMMS_RESET)
            {
                ScibRegs.SCIFFRX.bit.RXFIFORESET=0;
                readCount=0;
                bufPtr=0;
                ScibRegs.SCIFFRX.bit.RXFIFORESET=1;
                Syncd = 0;
                return(3);
            }
            readCount++;
            bufPtr++;
         }
    }

  //  ScibRegs.SCIFFRX.bit.RXFFINTCLR = 1;
    return (readCount);
}
/*
int SCIB_read(int dev_fd, char * buf, unsigned count)
{
    uint16_t readCount = 0;
    uint16_t * bufPtr = (uint16_t *) buf;

    if(count == 0)
    {
        return (0);
    }

    while((readCount < count) && ScibRegs.SCIRXST.bit.RXRDY)
    {
        *bufPtr = ScibRegs.SCIRXBUF.bit.SAR;
        readCount++;
        bufPtr++;
    }

    return (readCount);
}*/

//
// SCI_write - Write to the SCI TX buffer
//
//int SCIB_write(int dev_fd, char * buf, unsigned count)
void SCIB_write(int dev_fd, char * buf)
{
  //  uint16_t writeCount = 0;
    uint16_t * bufPtr = (uint16_t *) buf;
  //  int c=0;

  //  if(count == 0)
  //      return (0);

  //  while (p[c] != '\0') {
  //         count++;
  //      }
    while(*bufPtr!='\0')
   // while(writeCount < count)
    {
        if(ScibRegs.SCIFFTX.bit.TXFFST<12)
        {
            ScibRegs.SCITXBUF.all = *bufPtr;
          //  writeCount++;
            bufPtr++;
        }
    }

    while(ScibRegs.SCIFFTX.bit.TXFFST);

   // return (writeCount);
}

//
// error - Function to count errors
//
void error()
{
   // ErrorCount++;
//   asm("     ESTOP0");  // Uncomment to stop the test here
//   for (;;);
}

//
// scia_xmit - Transmit a character from the SCI
//
void scib_xmit(Uint16 a)
{
    while (ScibRegs.SCIFFTX.bit.TXFFST != 0) {}
    ScibRegs.SCITXBUF.all=a;
}


//
// scia_receive - Transmit a character from the SCI
//
// Test to see if a key has been pressed on the Terminal
// retval 1: Correct
//        0: Error

Uint32 scib_receive_key(Uint16 *key)
{
    if(ScibRegs.SCIFFRX.bit.RXFFST)
    {
       *key = (Uint16)ScibRegs.SCIRXBUF.bit.SAR;
       return 1;
    }
    else
    {
      return 0;
    }
}


/**
  * @brief  Get a key from the Terminal
  * @param  None
  * @retval The Key Pressed
  */
Uint16 GetKey(void)
{
  Uint16 key = 0;

  /* Waiting for user input */
  while (1)
  {
    if (scib_receive_key((Uint16*)&key)) break;
  }
  return key;

}



//
// SCI_write - Write to the SCI TX buffer
//
int SCIB_write_char(char buf)
{
    uint16_t writeCount = 0;
    uint16_t count = 1;

    while(writeCount < count)
    {
        if(ScibRegs.SCIFFTX.bit.TXFFST<12)
        {
           ScibRegs.SCITXBUF.all = buf;
           writeCount++;
        }
    }

   // while(ScibRegs.SCIFFTX.bit.TXFFST);

    return (writeCount);
}

void SCIB_write_int16(Uint16 buf)
{
  Uint16 writeCount = 0;
  //  uint16_t * bufPtr = (uint16_t *) buf;
  Uint16 count = 2;
  Uint16 tmp = buf>>8;

  tmp = tmp | ((buf<<8)&0xff00);


  //  if(count == 0)
  //      return (0);

  //  while (p[c] != '\0') {
  //         count++;
  //      }
  //  while(*bufPtr!='\0')
   while(writeCount < count)
    {
        if(ScibRegs.SCIFFTX.bit.TXFFST<12)
        {
            ScibRegs.SCITXBUF.all = tmp & 0x00ff;
            writeCount++;
            tmp>>=8;
        }
    }
  //  while(ScibRegs.SCIFFTX.bit.TXFFST);

   // return (writeCount);
}

//
// scia_fifo_init - Initialize the SCI FIFO
//
void scib_fifo_init()
{
    ScibRegs.SCIFFTX.all = 0xE040;
    ScibRegs.SCIFFRX.all = 0x2044;
    ScibRegs.SCIFFCT.all = 0x0;
}

//
// End of file
//

/*
 *      EALLOW;
        CpuSysRegs.PCLKCR7.bit.SCI_B = 1;
        ScibRegs.SCIFFTX.all=0xE040;
        ScibRegs.SCIFFRX.all=0x2044;
        ScibRegs.SCIFFCT.all=0x0;
      //  ScibRegs.SCIFFTX.all=0xE040;
     //   ScibRegs.SCIFFRX.all=0x2044;
      //  ScibRegs.SCIFFCT.all=0x0;
        ScibRegs.SCICCR.all =0x0007;   // 1 stop bit,  No loopback
                                       // No parity,8 char bits,
                                       // async mode, idle-line protocol
        ScibRegs.SCICTL1.all =0x0003;  // enable TX, RX, internal SCICLK,
                                       // Disable RX ERR, SLEEP, TXWAKE
        ScibRegs.SCICTL2.all =0x0003;
        ScibRegs.SCICTL2.bit.TXINTENA =1;
        ScibRegs.SCICTL2.bit.RXBKINTENA =1;


        ScibRegs.SCIHBAUD.bit.BAUD =0x0002;  // 9600 baud//(200 MHz SYSCLK/4).
        ScibRegs.SCILBAUD.bit.BAUD =0x008a;

  //      ScibRegs.SCIHBAUD.bit.BAUD =0x0000;  // 115200 baud//(200 MHz SYSCLK/4).
  //      ScibRegs.SCILBAUD.bit.BAUD =0x0035;

        ScibRegs.SCICTL1.all =0x0023;  // Relinquish SCI from Reset
       // ScibRegs.SCICCR.bit.LOOPBKENA = 1; // Enable loop back
        EDIS;
 */

void concatenate_string(char *original, char *add)
{
   while(*original)
      original++;

   while(*add)
   {
      *original = *add;
      add++;
      original++;
   }
   *original = '\0';
}


void concatenate(char p[], char q[])
{
   int c, d;

   c = 0;

 //  if(p[0]!='\0')
 //  {
       while (p[c] != '\0') {
          c++;
       }
  // }

   d = 0;

   while (q[d] != '\0') {
      p[c] = q[d];
      d++;
      c++;
   }

   p[c] = '\0';
}









