/*
 * SCI_Code_V1.h
 *
 *  Created on: 27 Sep 2018
 *      Author: Ed
 */

#ifndef SCIB_CODE_V1_H_
#define SCIB_CODE_V1_H_

#ifdef __cplusplus
extern "C" {
#endif

//
// Function Prototypes
//
int SCIB_open();
int SCIB_close(int dev_fd);
int SCIB_read(int dev_fd, char * buf, unsigned count);
int SCIB_read_LF(Uint16 *CMD, char *DATA, Uint32 timeout);
//int SCIB_write(int dev_fd, char * buf, unsigned count);

int read_data_i(char *cmd);


void SCIB_write(int dev_fd, char * buf);
int SCIB_write_char(char buf);
void concatenate_string(char *original, char *add);
void concatenate(char p[], char q[]);
void SCIB_write_int16(Uint16 buf);

//void scib_xmit(int a);
void scib_xmit(Uint16 a);
void error();
void scib_fifo_init(void);

Uint32 scib_receive_key(Uint16 *key);
Uint16 GetKey(void);


#ifdef __cplusplus
}
#endif /* extern "C" */

//***** Data Capture variables

extern Uint16 Sampling_On;
extern Uint16 DataCapComplete;
extern Uint16 cap_samp;
extern Uint16 Cap_Done_Mess;

extern float *pData;
extern float *Cap_Vars[32];

extern Uint16 Curr_Samp_Inst;
extern Uint16 NoSpINT;
extern Uint16 Tot_No_Of_INTS;

extern float* Var_List_Loc[32];

#endif

//
// End of file
//

