/*
 * SCI_Code_V1.c
 *
 *  Created on: 27 Sep 2018
 *      Author: Ed
 */

// Based on F2837xD_sci_io.c

//
// Included Files
//
#include <stdio.h>
#include <file.h>
#include "F28x_Project.h"


#pragma CODE_SECTION(SCIC_open, ".TI.ramfunc");
#pragma CODE_SECTION(SCIC_read_LF, ".TI.ramfunc");
#pragma CODE_SECTION(SCIC_write_char, ".TI.ramfunc");
#pragma CODE_SECTION(SCIC_write_int16_LCD, ".TI.ramfunc");

//
// Globals
//
uint16_t deviceOpen_C = 0;

//
// SCI_open - Initialize and setup SCI
//
int SCIC_open()
{
    if(deviceOpen_C)
    {
        return (-1);
    }
    else
    {

        EALLOW;
        CpuSysRegs.PCLKCR7.bit.SCI_C = 1;
        ScicRegs.SCIFFTX.all=0xE001;
        ScicRegs.SCIFFRX.all=0x2003;
        ScicRegs.SCIFFCT.all=0x0;
        ScicRegs.SCICCR.all =0x0007;   // 1 stop bit,  No loopback
                                       // No parity,8 char bits,
                                       // async mode, idle-line protocol
        ScicRegs.SCICTL1.all =0x0003;  // enable TX, RX, internal SCICLK,
                                       // Disable RX ERR, SLEEP, TXWAKE
        ScicRegs.SCICTL2.all =0x0003;

        //ScicRegs.SCIHBAUD.bit.BAUD =0x0002;  // 9600 baud//(200 MHz SYSCLK/4).
        //ScicRegs.SCILBAUD.bit.BAUD =0x008a;

        ScicRegs.SCIHBAUD.bit.BAUD =0x0000;  // 115200 baud//(200 MHz SYSCLK/4).
        ScicRegs.SCILBAUD.bit.BAUD =0x0035;  // 53 (in hexadecimal)


        //ScicRegs.SCIHBAUD.bit.BAUD = 0x0000;  // 4800 baud//(200 MHz SYSCLK/4). Set SCIHBAUD to 0
        //ScicRegs.SCILBAUD.bit.BAUD = 0x0515;  // Set SCILBAUD to 1301 (in hexadecimal)

        //ScicRegs.SCIHBAUD.bit.BAUD = 0x0000;  // 600 baud// Set SCIHBAUD to 0
        //ScicRegs.SCILBAUD.bit.BAUD = 0x28C0;  // Set SCILBAUD to 10416 (in hexadecimal)


        ScicRegs.SCICTL2.all = 0x0000;

        ScicRegs.SCICTL2.bit.TXINTENA = 0;
    //    ScicRegs.SCICTL2.bit.RXBKINTENA = 0;
        ScicRegs.SCIFFRX.bit.RXFFIENA = 1;

        ScicRegs.SCICTL1.all |= 0x0020;  // Relinquish SCI from Reset
        ScicRegs.SCIFFTX.bit.TXFIFORESET = 1;
        ScicRegs.SCIFFRX.bit.RXFIFORESET = 1;

        // ScicRegs.SCICCR.bit.LOOPBKENA = 1; // Enable loop back
        EDIS;

        deviceOpen_C = 1;
        return (1);
    }
}



int SCIC_read_LF(Uint16 *CMD, char *DATA, Uint32 timeout)
{
    char tmp[20];
    char curr=0, pre_curr=0;
    int end = 0, i=0, num=0;
    Uint32 t_out_c = 0;

  //  uint16_t * CMDPtr = (uint16_t *)CMD;
    uint16_t * DATAPtr = (uint16_t *)DATA;
    uint16_t * tmpPtr = (uint16_t *)tmp;
    uint16_t readCount = 0;

    while(!end)
    {

        //Start time out function


        t_out_c++;
        if(t_out_c>timeout)
            {
                end=1;
                GpioDataRegs.GPCCLEAR.bit.GPIO84 = 1;
                return(0);
            }

        if(ScicRegs.SCIFFRX.bit.RXFFST)
        {
            pre_curr = curr;
            curr = 0;
            curr = ScicRegs.SCIRXBUF.bit.SAR;
            *tmpPtr = curr;
     /*       if(*tmpPtr == COMMS_RESET)
            {
                ScicRegs.SCIFFRX.bit.RXFIFORESET=0;
                readCount=0;
                tmpPtr=0;
                ScicRegs.SCIFFRX.bit.RXFIFORESET=1;
                Syncd = 0;
                return(3);
            }*/
            if((curr==0x0A)&&(pre_curr==0x0D))
            {
                end=1;
                tmpPtr++;
                readCount++;
            }
            else
            {
                tmpPtr++;
                readCount++;
                end=0;
            }

            if(readCount==20)
            {
                tmpPtr = (uint16_t *)tmp;
                readCount=0;
            }

         }
    }

    tmpPtr -= readCount;

    *CMD = (0xff00&*tmpPtr++<<8)|(0x00ff&*tmpPtr++);

  //  *CMDPtr++ = *tmpPtr++;
   // *CMDPtr++ = *tmpPtr++;

   //COM_B_CMD = (((*tmpPtr<<8)&0xFF00)|*(++bufPtr));

    num = readCount-4;

 //   bufPtr2 += (num-1);

    for(i=0;i<num;i++)
    {
        *DATAPtr++ = *tmpPtr++;
    }



  //  ScibRegs.SCIFFRX.bit.RXFFINTCLR = 1;
    return (readCount);
}

//
// SCI_write - Write to the SCI TX buffer
//
int SCIC_write_char(char buf)
{
    uint16_t writeCount = 0;
    uint16_t count = 1;

    while(writeCount < count)
    {
        if(ScicRegs.SCIFFTX.bit.TXFFST<12)
        {
           ScicRegs.SCITXBUF.all = buf;
           writeCount++;
        }
    }

   // while(ScibRegs.SCIFFTX.bit.TXFFST);

    return (writeCount);
}

void SCIC_write_int16_LCD(char cmd, Uint16 *buf, Uint16 conv, Uint16 num)
{
  Uint16 int_writeCount = 0;
  //Uint16 writeCount = 0;
  Uint16 count = num+2;
  char i=0;
  Uint16 *buf_ptr = (Uint16 *)buf;
  Uint16 tmp[10];

  tmp[0] = cmd;

  for(i=0;i<(num*2);)
  {
      tmp[i+1] = *buf_ptr>>8;
      tmp[i+2] = *buf_ptr&0x00FF;
      *buf_ptr++;
      i+=2;
  }

   while(int_writeCount < count)
   {
        if(ScicRegs.SCIFFTX.bit.TXFFST<12)
        {
            ScicRegs.SCITXBUF.all = tmp[int_writeCount];
            int_writeCount++;
        }
    }
}

