/*
 * mpc_pll.c
 *
 *  Created on: 8 Apr 2024
 *      Author: ezyen
 */
#include "mpc_pll.h"
#include "utils.h"
#include <math.h>
#include <DCLF32.h> // Digital Control Lib
#include "CPU1_Base.h"



/* Initialise variables for PLL controller*/

float Valfa_pll = 0.0f;         //defines pll transformations
float Vbeta_pll = 0.0f;
float Vd_pll = 0.0f;
float Vq_pll = 0.0f;
float Vd = 0.0f;
float Vq = 0.0f;
float Vq_min = FLT_MAX;
float Vd_max = -FLT_MAX;
float theta_iteration[9] = {0.0f};
int m = 0;


const float THETA_STEPS[] = {
    90.0 * PI / 180,
    45.0 * PI / 180,
    22.5 * PI / 180,
    11.25 * PI / 180,
    5.625 * PI / 180,
    2.8125 * PI / 180,
    1.40625 * PI / 180,
    0.703125 * PI / 180,
    0.3515625 * PI / 180
};


float findMaxTheta(float Valfa_pll, float Vbeta_pll, int iteration) {
    float Vd_max = -FLT_MAX, theta_max;
    int m;
    for (m = 0; m < 8; m++) {
        float theta_SA = theta_iteration[iteration - 1] - THETA_STEPS[iteration - 1] + m * THETA_STEPS[iteration];
        float Vd = Valfa_pll * cos(theta_SA) + Vbeta_pll * sin(theta_SA);
        if (Vd >= Vd_max) {
            Vd_max = Vd;
            theta_max = theta_SA;
        }
    }
    return theta_max;
}

float findMinTheta(float Valfa_pll, float Vbeta_pll, int iteration) {
    float Vq_min = FLT_MAX, theta_min;
    int m;
    for (m = 0; m < 8; m++) {
        float theta_SA = theta_iteration[iteration - 1] - THETA_STEPS[iteration - 1] + m * THETA_STEPS[iteration];
        float Vq = Vbeta_pll * cos(theta_SA) - Valfa_pll * sin(theta_SA);
        if (fabs(Vq) <= Vq_min) {
            Vq_min = fabs(Vq);
            theta_min = theta_SA;
        }
    }
    return theta_min;
}
