/*
 * mpc_pll.h
 *
 *  Created on: 8 Apr 2024
 *      Author: ezyen
 */

#ifndef MPC_PLL_H_
#define MPC_PLL_H_

#include "CPU1_Base.h"
#include "utils.h"

/* Define constants */
#define Valfa_scale (2/(3*sqrt(3))) // Scaling factor for alpha component
#define Vbeta_scale (sqrt1on3)       // Scaling factor for beta component
#define PI 3.14159265358979323846    // Value of Pi

/* Function declarations */
float findMaxTheta(float Valfa_pll, float Vbeta_pll, int iteration); // Function to find maximum theta
float findMinTheta(float Valfa_pll, float Vbeta_pll, int iteration); // Function to find minimum theta

/* Variable declarations */
extern float Valfa_pll;         // Alpha component of transformed voltage
extern float Vbeta_pll;         // Beta component of transformed voltage
extern float Vd_pll;            // D-component of transformed voltage
extern float Vq_pll;            // Q-component of transformed voltage
extern float Vd;                // Maximum D-component
extern float Vq;                // Minimum Q-component
extern float Vq_min;            // Minimum value of Q-component
extern float Vd_max;            // Maximum value of D-component
extern float theta_iteration[9];// Array to store iteration-specific theta values
extern int m;                   // Loop counter

#endif /* MPC_PLL_H_ */
