/*
 * utils.c
 *
 *  Created on: 18 Sep 2019
 *      Author: Davide
 */
#include "utils.h"
#include <math.h>
#include <DCLF32.h> // Digital Control Lib


//PARK TRANSFORM FUNCTIONS

void dq0(float A, float B, float C, float*d, float *q, float *z, float sinTheta, float cosTheta)
{
    float alpha,beta;

    alpha=(A*2-B-C)/3;
    beta=(B-C)*sqrt1on3;
    *z=(A+B+C)/3;

    *d = cosTheta*alpha + sinTheta*beta;    //Park
    *q =-sinTheta*alpha + cosTheta*beta;
}

void INVdq0(float d, float q, float z, float *A, float *B, float *C, float sinTheta, float cosTheta)
{
    float alpha,beta;

    alpha = cosTheta*d - sinTheta*q;
    beta  = sinTheta*d + cosTheta*q;

    *A = z + alpha;
    *B = z - alpha*0.5;
    *C = *B - beta*sqrt3on4;
    *B += beta*sqrt3on4;

}


DCL_PI PI_PLL={ 0.1f, 0.01f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };


//float PLL_kp=0, PLL_ki=0;
float Wn=2*piFloat*50;
float wErr=0;

void PLL(float Vq, float dt, float*sinTheta,float*cosTheta,float*Theta)
{
    wErr= DCL_runPI_C1(&PI_PLL, 0, -Vq);

    *Theta+=(Wn+wErr)*dt;

    if(*Theta<-piFloat) *Theta+=2*piFloat;
    if(*Theta>piFloat) *Theta-=2*piFloat;
    if(*Theta>2*piFloat) *Theta=-piFloat;
    if(*Theta<-2*piFloat) *Theta=-piFloat;

    *sinTheta=sin(*Theta);
    *cosTheta=cos(*Theta);
}



