MEMORY
{
  /* --------------------- Program Memory ------------------------------*/    	
  PAGE 00:		/* internal Flash										*/
	VECTOR2:	org =  1008h, len = 0040h	/* displaced Int-Vectors	*/
	FLASH:		org =  1048h, len = 6FB8h   /* Flash Sector 1,2,3		*/ 
    
  PAGE 10:		/* external Flash-Page, g_wMemPagePtr(#5,4,3) = 0,0,0	*/    	
	XFLASH1:	org =  8800h, len = 7800h
	
  PAGE 20:		/* external Flash-Page, g_wMemPagePtr(#5,4,3) = 0,0,1	*/    	
	XFLASH2:	org =  8800h, len = 7800h
	
  PAGE 30:		/* external Flash-Page, g_wMemPagePtr(#5,4,3) = 0,1,0	*/    	
	XFLASH3:	org =  8800h, len = 7800h
	
  PAGE 40:		/* external Flash-Page, g_wMemPagePtr(#5,4,3) = 0,1,1	*/    	
	XFLASH4:	org =  8800h, len = 7800h
	
    
  /* ------------------------ Data Memory ------------------------------*/    	
  PAGE 01:		/* internal RAM											*/
/* 	REGS:		org =  0000h, len = 0060h	   Memory-Mapped Registers	*/
 	B2_OS:		org =  0060h, len = 0006h 	/* Gloabal State Variable	*/
 	B2:			org =  0066h, len = 001Ah	/* On Chip DARAM B2			*/
/*  Reserved	org =  0080h, len = 0180h								*/
 	B0_4:		org =  0200h, len = 0080h	/* DARAM, when CNF = 0		*/
 	B0_5:		org =  0280h, len = 0080h	/* DARAM, when CNF = 0		*/
	B1_6:		org =  0300h, len = 0080h	/* DARAM, when CNF = 0		*/	
	B1_7:		org =  0380h, len = 0080h	/* DARAM, when CNF = 0		*/	
/*  Reserved	org =  0400h, len = 0400h								*/
	SARAM:		org =  0800h, len = 0800h	/* Intern RAM, when DON = 1 */
/*  Reserved	org =  1000h, len = 6000h								*/
/*	PERIPHERY:	org =  7000h, len = 1000h	   Peripherial Registers	*/

  PAGE 11:		/* external RAM-Page, g_wMemPagePtr(#2,1,0) = 0,0,0		*/
    XDRAM1:		org =  8000h, len = 8000h		    
    
  PAGE 21:		/* external RAM-Page, g_wMemPagePtr(#2,1,0) = 0,0,1	 	*/
    XDRAM2:		org =  8000h, len = 8000h		    
}

                                            
/*======================================================================*/
/* SECTION ALLOCATION													*/
/*======================================================================*/
SECTIONS
{                           
	/*------------------------------------------------------------------*/
	/* Initialized Sections 											*/
	/*------------------------------------------------------------------*/
	/*------------------------------------------------------------------*/
	/* external Flash-Page 10											*/
	/*------------------------------------------------------------------*/
	.vector:  >	VECTOR2	PAGE 0	/* interrupt vector table				*/	
	.const:	  >	FLASH	PAGE 0 	/* data constants declared by "const"	*/
	.switch:  >	FLASH	PAGE 0 	/* table for switch statements 			*/
	.cinit:	  >	FLASH	PAGE 0 	/* data tables to initialize 			*/

    .SinTab:  > FLASH	PAGE 0	/* Sine lookup Table InitValues			*/		
    .AtanTab: > FLASH	PAGE 0	/* Atan lookup Table InitValues			*/		
       

	.text:
	{
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\AnyBus.obj 					(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\AnyJmAna.obj 					(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\Can.obj						(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\Hardware.obj					(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\Paging.obj					(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\CtrlTask\CTTest.obj			(.text )

	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTCapPos.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTComOfs.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTCurr.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTEnc.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTEnc2.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTGenPos.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTJmEmu.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTMain.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTPos.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTSafety.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTSpeed.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\CTSvPwm.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\obj\CtrlTask\SinAtanTab.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\cpu\src\rts2xx.lib					(.text )    

	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\GlobVars.obj				(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMMain.obj				(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\CtrlTask\CTDigOut.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\CtrlTask\CTPwm.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\CtrlTask\CTScope.obj		(.text )
  	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\CtrlTask\CTSync.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\RefTask\RTMain.obj		(.text )

	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCAxis.obj	(.text )   
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCSync.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCUser.obj	(.text )
	} >	FLASH	PAGE 0	/* Code in internal Flash				*/
	     

	/*------------------------------------------------------------------*/
	/* external Flash-Page 10											*/
	/*------------------------------------------------------------------*/
	.text1:
	{       
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCAxisIO.obj(.text )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCBlock.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCDrive.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCMove.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCSlope.obj	(.text )   
	} >	XFLASH1 PAGE 10


	.switch1:
	{
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCBlock.obj	(.switch )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCMove.obj	(.switch )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCSlope.obj	(.switch )   
	} >	XFLASH1 PAGE 10


	/*------------------------------------------------------------------*/
	/* external Flash-Page 20											*/
	/*------------------------------------------------------------------*/
	.text2:               		/* Build .text2 output section      	*/    
	{       
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\JMDebug.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\Init2407.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\Norm.obj			(.text )

	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMInit.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMRegs.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMRegs32.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMUser.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Scope.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Screw.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Setup.obj		(.text )
	} >	XFLASH2 PAGE 20
	

	.switch2:
	{
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMRegs32.obj	(.switch )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMUser.obj	(.switch )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Scope.obj		(.switch )
	} >	XFLASH2 PAGE 20


	/*------------------------------------------------------------------*/
	/* external Flash-Page 30											*/
	/*------------------------------------------------------------------*/
	.text3:
	{       
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\AnyJmCnt.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\AnyJmEmu.obj		(.text )

	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Adapt.obj	 	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Avr.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\ComOffs.obj	(.text )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\CtrlMgr.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\AnaIn.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\DigIn.obj		(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\DigOut.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\DriveMgr.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Encoder.obj	(.text )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\EnDat.obj		(.text )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\HiPerFace.obj	(.text )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\I2tMains.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\I2tMotor.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\LedDisp.obj 	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\LimSwitch.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Monitor.obj 	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Resolver.obj	(.text )    
	} >	XFLASH3 PAGE 30


	.switch3:
	{       
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\DriveMgr.obj	(.switch )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\ComOffs.obj	(.switch )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Encoder.obj	(.switch )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\EnDat.obj		(.switch )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\HiPerFace.obj	(.switch )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\LedDisp.obj	(.switch )
	} >	XFLASH3 PAGE 30


	/*------------------------------------------------------------------*/
	/* external Flash-Page 40											*/
	/*------------------------------------------------------------------*/
	.text4:
	{       
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\Encoder2.obj			(.text )    
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\PidCtrl.obj			(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\RefTask\RTBusRx.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\RefTask\RTBusTx.obj	(.text )
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\RefTask\RTGenPos.obj	(.text )
	} >	XFLASH4 PAGE 40


	.switch4:
	{       
	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\RefTask\RTGenPos.obj	(.switch )
	} >	XFLASH4 PAGE 40

	     
	/*------------------------------------------------------------------*/
	/* Uninitialized Sections 											*/
	/*------------------------------------------------------------------*/
	
	/* Fix Variables for Bootsector, Loader and OS						*/
	.OsState: > B2_OS	PAGE 01	/* Global State Variable				*/
	.PagePtr: > B2_OS	PAGE 01	/* Global MemoryPage Pointer			*/   
	.AnyInd:  > B2_OS	PAGE 01 /* Global AnyBus-Indication				*/
	.AppInd:  > B2_OS	PAGE 01 /* Global Application-Indication 		*/
	.AnyIdO:  > B2_OS	PAGE 01	/* Global AnyBus-Message-ID Out			*/    
	.AnyIdI:  > B2_OS	PAGE 01	/* Global AnyBus-Message-ID In			*/    

    .P4:	  > B0_4	PAGE 01	/* glob. Vars at CtrlTask-Page 4		*/	  
    .P5:	  > B0_5	PAGE 01	/* glob. Vars at CtrlTask-Page 5		*/	  

	.P6:	  > B1_6	PAGE 01	/* glob. Vars at CtrlTask-Page 6		*/	  
	.P7:	  > B1_7	PAGE 01	/* glob. Vars at CtrlTask-Page 7		*/
    .Scope:	  >	B1_7	PAGE 01	/* Variables for digital Oscilloscope	*/

    .GlobVar: > SARAM	PAGE 01	/* All other global Variables			*/
	.stack:	  >	SARAM	PAGE 01 /* C system stack						*/
	.sysmem:  >	SARAM	PAGE 01 /* C system heap ( used by malloc() )	*/
	.bss:	  >	SARAM 	PAGE 01 /* global and static variables 			*/
	.data:	  > SARAM	PAGE 01	


	.bss1:                		/* Build .bss1 output section      		*/    
	{       
	  D:\JetMove\JM2xx\OS\modules\bsp\obj\JMDebug.obj					(.bss )

	  D:\JetMove\JM2xx\OS\modules\JetMove\obj\JMUser.obj				(.bss )

	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCAxis.obj	(.bss )   
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCAxisIO.obj(.bss )   
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCBlock.obj	(.bss )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCDrive.obj	(.bss )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCMove.obj	(.bss )
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCSlope.obj	(.bss )   
/*	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCSync.obj	(.bss ) Do Not link here because of Paging! */
	  D:\JetMove\JM2xx\OS\modules\MotionControlEmbedded\obj\MCUser.obj	(.bss )
	  
	} 		  >	XDRAM1 	PAGE 11	/* Data in external RAM-Page #1			*/
    

    .CamTab:  > XDRAM2	PAGE 21 /* Tables for Caming					*/	
    .ScopeD:  > XDRAM2	PAGE 21	/* Buffer for digital Oszilloscope		*/	

} 
