@echo off
setlocal
setlocal ENABLEDELAYEDEXPANSION

REM Path to this batch script
set UNIFLASH_PATH=%~dp0

REM Path to DebugServer folder
set DEBUGSERVER_ROOT=%~dp0ccs_base\DebugServer\

set MODE=flash
set EXECUTABLE="!DEBUGSERVER_ROOT!bin\DSLite"

set GENERATED_COMMAND=-c user_files/configs/f280049c.ccxml -l user_files/settings/generated.ufsettings -s VerifyAfterProgramLoad=2 -e -v "user_files/images/ML_DPC_R18_2.hex" 
set ADDITIONALS=-n 0

REM list available modes
if "%1"=="--listMode" (
	echo.
	
	echo Usage: dslite --mode ^<mode^> arg
	echo.
	
	echo Available Modes for UniFlash CLI:
	echo   * flash [default] - on-chip flash programming
	echo   * memory          - export memory to a file
	echo   * load            - simple loader [use default options]
	echo   * serial          - serial flash programming
if exist !DEBUGSERVER_ROOT!drivers\MSP430Flasher.exe (
	echo   * mspflasher      - support MSPFlasher command line parameters [deprecated]
)
	
	exit /b 0
)

REM no parameters given, use the default generated command
if "%1" EQU "" (
	echo Executing default command:
	echo ^> dslite --mode !MODE! !GENERATED_COMMAND! !ADDITIONALS!
	echo.
	
	CMD /S /C "%EXECUTABLE% !MODE! !GENERATED_COMMAND! !ADDITIONALS!"
	exit /b !errorlevel!
)

REM user options parsing
set USEROPTIONS=%*

REM user options without the --mode
set "_args=%*"
set "_args=!_args:*%1 =!"
set "_args=!_args:*%2 =!"

if "%3"=="" (
	set USEROPTIONS2=
) else (
	set USEROPTIONS2=!_args!
)

REM custom mode from users
if "%1" EQU "--mode" (
	set MODE=%2
	set USEROPTIONS=!USEROPTIONS2!
)

REM default user options if none given
if "!USEROPTIONS!" EQU "" (
	set USEROPTIONS=-h
)

REM mspflasher support
if "%MODE%" EQU "mspflasher" (
	set EXECUTABLE=!DEBUGSERVER_ROOT!drivers\MSP430Flasher.exe
	set MODE=
)

REM execute with given user parameters
echo Executing the following command:
if "!MODE!" EQU "" (
	echo ^> !EXECUTABLE! !USEROPTIONS! !ADDITIONALS!
) else (
	echo ^> !EXECUTABLE! !MODE! !USEROPTIONS! !ADDITIONALS!
)
echo.

echo For more details and examples, please visit http://processors.wiki.ti.com/index.php/UniFlash_v4_Quick_Guide#Command_Line_Interface
echo.

CMD /S /C "%EXECUTABLE% !MODE! !USEROPTIONS! !ADDITIONALS!"

REM >> /****** BEGIN my modification to get errorlevel ******/

echo:
	echo Errorlevel: %errorlevel%
	if %errorlevel% EQU 0 (echo PASS>potenza.log) else (echo FAIL>potenza.log)
echo:

if ERRORLEVEL 1 goto errorOccurred
	echo TMS320F280049C Successfully Verified!

goto done

:errorOccurred
	echo TMS320F280049C Fail Verification!
	REM pause
	exit -1

:done 
	REM pause
	exit 0

REM >> /****** END my modification to get errorlevel ******/

REM >> exit /b !errorlevel!
