

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File
#include "string.h"


//
// Function Prototypes
//
void InitEPwm1Example(Uint16);
void InitEPwm2Example(Uint16);
void InitEPwm3Example(Uint16);
void InitEPwm4Example(Uint16);






//

#define EPWM_dead_band 45    //45 = 500ns



//
// Main
//
void main(void)
{

    //
    InitSysCtrl();

    //



    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (Uint32)&RamfuncsLoadSize);

    //
    // Call Flash Initialization to setup flash waitstates
    // This function must reside in RAM
    //

    InitFlash();

    InitEPwm1Gpio();
    InitEPwm2Gpio();
    InitEPwm3Gpio();
    InitEPwm4Gpio();


    //
    DINT;


    //
    InitPieCtrl();

    //
    // Disable CPU interrupts and clear all CPU interrupt flags
    //
    IER = 0x0000;
    IFR = 0x0000;

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2806x_DefaultIsr.c.
    // This function is found in F2806x_PieVect.c.
    //
    InitPieVectTable();

    //
    //
    // For this example, only initialize the ePWM
    //
    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
    EDIS;




    float TB_PRD=1123.0f;

    float  f_carrier = 100 ; // unit kHz


    TB_PRD = (45000.0/f_carrier);






    InitEPwm1Example((Uint16) (TB_PRD));
    InitEPwm2Example((Uint16) (TB_PRD));
    InitEPwm3Example((Uint16) (TB_PRD));
    InitEPwm4Example((Uint16) (TB_PRD));

    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;

    //

    //
    IER |= M_INT3;

    //

    //
    PieCtrlRegs.PIEIER3.bit.INTx1 = 1;
//

    //

    //
    EINT;   // Enable Global interrupt INTM
    ERTM;   // Enable Global realtime interrupt DBGM

    //
    // Step 6. IDLE loop. Just sit and loop forever (optional)
    //
    for(;;)
    {
        __asm("          NOP");
    }
}

//
// epwm1_isr -
//

//
//
// InitEPwm1Example -
//
void
InitEPwm1Example(Uint16 TB_peroid)
{
    //
    // Setup TBCLK
    //
    EPwm1Regs.TBPRD = TB_peroid;     // Set timer period 801 TBCLKs
    EPwm1Regs.TBPHS.half.TBPHS = 0x0000;     // Phase is 0
    EPwm1Regs.TBCTR = 0x0000;                // Clear counter

    //
    // Set Compare values
    //
    EPwm1Regs.CMPA.half.CMPA = 225;     // Set compare A value

    //
    // Setup counter mode
    //
    EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up & down
    EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
    EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_CTR_ZERO; // Sync down-stream module
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
    EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    //
    // Setup shadowing
    //
    EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on Zero
    EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    //
    // Set actions
    //   duty = (CMPA*2+1)/(TBPRD*2+1)
    EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;    // Set PWM1A on event A, up count
    EPwm1Regs.AQCTLA.bit.CAD = AQ_SET;  // Clear PWM1A on event A, down count

    //EPwm1Regs.AQCTLB.bit.CBU = AQ_SET;    // Set PWM1B on event B, up count
    //EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;  // Clear PWM1B on event B, down count

    //
    // set deadband
/*    EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
    EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;     // A for all
    EPwm1Regs.DBRED = 45;             //dead band  = 45*11.1ns = 500ns, OFFtime = 170ns
    EPwm1Regs.DBFED = 45;             //dead band  = 45*11.1ns = 500ns, ONtime  = 200ns
*/
    //
    // Interrupt where we will change the Compare Values
    //
    EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;      // Select INT on Zero event
    EPwm1Regs.ETSEL.bit.INTEN = 1;                 // Enable INT
    EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;            // Generate INT on 1ST event




}

//
// InitEPwm2Example -
//
void
InitEPwm2Example(Uint16 TB_peroid)
{
    //
    // Setup TBCLK
    //
    EPwm2Regs.TBPRD = TB_peroid;         // Set timer period 801 TBCLKs
    EPwm2Regs.TBPHS.half.TBPHS = 0;         // Phase is 0
    EPwm2Regs.TBCTR = 0;                    // Clear counter

    //
    // Set Compare values
    //
    EPwm2Regs.CMPA.half.CMPA = 225;     // Set compare A value


    //
    // Setup counter mode
    //
    EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
    EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;        // Enable phase loading
    EPwm2Regs.TBCTL.bit.SYNCOSEL =  TB_SYNC_IN; // sync flow-through
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
    EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    //
    // Setup shadowing
    //
    EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on Zero
    EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    //
    // Set actions
    //
    EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;    // Set PWM1A on event A, up count
    EPwm2Regs.AQCTLA.bit.CAD = AQ_SET;  // Clear PWM1A on event A, down count

    //EPwm2Regs.AQCTLB.bit.CBU = AQ_SET;    // Set PWM1B on event B, up count
    //EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;  // Clear PWM1B on event B, down count
    //
    //
    // set deadband
    EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
    EPwm2Regs.DBCTL.bit.IN_MODE = DBA_ALL;     // A for all
    EPwm2Regs.DBRED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, OFFtime = 170ns
    EPwm2Regs.DBFED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, ONtime  = 200ns

    // Interrupt where we will change the Compare Values
    //
    EPwm2Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
    EPwm2Regs.ETSEL.bit.INTEN = 0;                // Enable INT
    EPwm2Regs.ETPS.bit.INTPRD = ET_1ST;           // Generate INT on 2Nd event


//   epwm2_info.NK_Tsw = 256;
//   epwm2_info.SIN_i_Count = 85;
    //
    // Set the pointer to the ePWM module
    //

}

//
// InitEPwm3Example -
//
void
InitEPwm3Example(Uint16 TB_peroid)
{
    //
    // Setup TBCLK
    //
    EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;// Count up/down
    EPwm3Regs.TBPRD = TB_peroid;          // Set timer period
    EPwm3Regs.TBPHS.half.TBPHS = 300;         // Phase is 0
    EPwm3Regs.TBCTL.bit.PHSEN = TB_ENABLE;       // Enable phase loading
    EPwm3Regs.TBCTL.bit.SYNCOSEL =  TB_SYNC_IN; // sync flow-through
    EPwm3Regs.TBCTR = 0x0000;                     // Clear counter
    EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;      // Clock ratio to SYSCLKOUT
    EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    //
    // Setup shadow register load on ZERO
    //
    EPwm3Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwm3Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
    EPwm3Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    //
    // Set Compare values
    //
    EPwm3Regs.CMPA.half.CMPA = 225;    // Set compare A value

    //
    // Set Actions
    //
    EPwm3Regs.AQCTLA.bit.CAU = AQ_CLEAR;    // Set PWM1A on event A, up count
    EPwm3Regs.AQCTLA.bit.CAD = AQ_SET;  // Clear PWM1A on event A, down count

    //EPwm3Regs.AQCTLB.bit.CBU = AQ_SET;    // Set PWM1B on event B, up count
    //EPwm3Regs.AQCTLB.bit.CBD = AQ_CLEAR;  // Clear PWM1B on event B, down count

    //
    // set deadband
    EPwm3Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm3Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
    EPwm3Regs.DBCTL.bit.IN_MODE = DBA_ALL;     // A for all
    EPwm3Regs.DBRED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, OFFtime = 170ns
    EPwm3Regs.DBFED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, ONtime  = 200ns

    //
    // Interrupt where we will change the Compare Values
    //
    EPwm3Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
    EPwm3Regs.ETSEL.bit.INTEN = 0;                // Enable INT
    EPwm3Regs.ETPS.bit.INTPRD = ET_1ST;           // Generate INT on 3rd event


//   epwm3_info.NK_Tsw = 256;
//   epwm3_info.SIN_i_Count = 170;
    //
    // Set the pointer to the ePWM module
    //
}

//
// InitEPwm3Example -

void
InitEPwm4Example(Uint16 TB_peroid)
{
    //
    // Setup TBCLK
    //
    EPwm4Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;// Count up
    EPwm4Regs.TBPRD = TB_peroid;          // Set timer period  = 1s
    EPwm4Regs.TBPHS.half.TBPHS = 600;         // Phase is 0
    EPwm4Regs.TBCTL.bit.PHSEN = TB_ENABLE;       // enable phase loading
    EPwm4Regs.TBCTL.bit.SYNCOSEL =  TB_SYNC_IN; // sync flow-through
    EPwm4Regs.TBCTR = 0x0000;                     // Clear counter
    EPwm4Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;      // Clock ratio to SYSCLKOUT
    EPwm4Regs.TBCTL.bit.CLKDIV = TB_DIV1;         //

    //
    // Setup shadow register load on ZERO
    //
    EPwm4Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwm4Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm4Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
    EPwm4Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    //
    // Set Compare values
    //
    EPwm4Regs.CMPA.half.CMPA = 225;    // Set compare A value

    //
    // Set Actions
    //
    EPwm4Regs.AQCTLA.bit.CAU = AQ_CLEAR;    // Set PWM1A on event A, up count
    EPwm4Regs.AQCTLA.bit.CAD = AQ_SET;  // Clear PWM1A on event A, down count

    // set deadband
    EPwm4Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm4Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
    EPwm4Regs.DBCTL.bit.IN_MODE = DBA_ALL;     // A for all
    EPwm4Regs.DBRED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, OFFtime = 170ns
    EPwm4Regs.DBFED = EPWM_dead_band;             //dead band  = 45*11.1ns = 500ns, ONtime  = 200ns

    //
    // Interrupt where we will change the Compare Values
    //
    EPwm4Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
    EPwm4Regs.ETSEL.bit.INTEN = 0;                // disable INT
    //EPwm4Regs.ETPS.bit.INTPRD = ET_1ST;           // Generate INT on 1st event

}
//

//








//
// End of File
//

