/* =================================================================================
File name:       CLARKE.H  (IQ version)
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description:
Header file containing constants, data type, and macro definition for the CLARKE.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 04-15-2010	Version 1.1
------------------------------------------------------------------------------*/
#include <IQmathLib.h>
#ifndef __F28002x_CLARKE_H__
#define __F28002x_CLARKE_H__

typedef struct {  _iq  f_a;  		// Input: phase-a stator variable
				  _iq  f_b;			// Input: phase-b stator variable
				  _iq  alpha;		// Output: stationary d-axis stator variable
				  _iq  beta;		// Output: stationary q-axis stator variable
		 	 	} TRF_CLARKE;


/*-----------------------------------------------------------------------------
	Default initalizer for the CLARKE object.
-----------------------------------------------------------------------------*/
#define TRF_CLARKE_DEFAULTS { 0, \
                          0, \
                          0, \
                          0, \
              			}

/*------------------------------------------------------------------------------
	CLARKE Transformation Macro Definition
------------------------------------------------------------------------------*/

	
#define TRF_CLARKE_MACRO(v)											\
																\
v.alpha = v.f_a;													\
v.beta = _IQmpy((v.f_a +_IQmpy2(v.f_b)),_IQ(0.57735026918963));	\

//  1/sqrt(3) = 0.57735026918963

#endif // __CLARKE_H__

