//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_04_master.h>
#include <00_f28002x_DIS_11_slave.h>
#include <00_f28002x_KEY_PAD.h>
#include <00_f28002x_ISR_TASK.h>
#include <00_f28002x_MODULATION.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_PI_Controller.h>
#include <00_f28002x_PROTECTION.h>
#include <00_f28002x_PROTECTION.h>
#include <00_f28002x_RAMP_Control.h>
#include <00_f28002x_Signal_Condition.h>
#include <00_f28002x_STATE_MACHINE.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"
#include "01_f28002x_examples.h"
#include "00_f28002x_SCI.h"
///////////////////////////////////////////////////////////////////////////////////
////////// SYSTEM_PARAMETER_INIT //////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
void INIT_ALL(void)
{
    INIT_INV_PWM();
    INIT_PWM_PAR();
}

_iq theta_SIM=0;
#define f_fund 50
#define del_theta_SIM _IQ(0.001*f_fund/f_sw_KHz)
//#define del_theta_SIM _IQ(0.05)

void SYN_FRAME_CONTROL(void)
{

    theta_SIM+=del_theta_SIM;
    if(theta_SIM>_IQ(1.0))theta_SIM-=_IQ(1.0);

    VOLTAGE_dq_to_abc();
}



///////////////////////////////////////////////////////////////////
_iq mod_Vd_CUR=0;
_iq mod_Vq_CUR=0;
_iq mod_Vq_CUR_ref=0;
_iq mod_V_alfa=0;
_iq mod_V_beta=0;
_iq mod_V_a=0;
_iq mod_V_b=0;
_iq mod_V_c=0;
#define del_mod_Vq_CUR _IQ(0.001)
void VOLTAGE_dq_to_abc(void)
{

    mod_Vq_CUR_ref=_IQ(0.95);
    mod_Vq_CUR=mod_Vq_CUR_ref;
    if((mod_Vq_CUR>(mod_Vq_CUR_ref-del_mod_Vq_CUR))&&(mod_Vq_CUR<(mod_Vq_CUR_ref+del_mod_Vq_CUR)))mod_Vq_CUR=mod_Vq_CUR_ref;
    else
    {
        if((mod_Vq_CUR<(mod_Vq_CUR_ref-del_mod_Vq_CUR))&&(p_pow.p_pulse.bit.pulse_10_ms==1))mod_Vq_CUR+=del_mod_Vq_CUR;
        if((mod_Vq_CUR>(mod_Vq_CUR_ref+del_mod_Vq_CUR))&&(p_pow.p_pulse.bit.pulse_10_ms==1))mod_Vq_CUR-=del_mod_Vq_CUR;
    }

    theta_SIM=_IQ(0.0);
    mod_V_alfa=_IQmpy(mod_Vd_CUR,_IQcosPU(theta_SIM))-_IQmpy(mod_Vq_CUR,_IQsinPU(theta_SIM));
    mod_V_beta=_IQmpy(mod_Vd_CUR,_IQsinPU(theta_SIM))+_IQmpy(mod_Vq_CUR,_IQcosPU(theta_SIM));


    mod_V_a=mod_V_alfa;
    mod_V_b=-_IQmpy(mod_V_alfa, _IQ(0.5))+_IQmpy(mod_V_beta, _IQ(0.866));
    mod_V_c=-_IQmpy(mod_V_alfa, _IQ(0.5))-_IQmpy(mod_V_beta, _IQ(0.866));

    p_pow.p_var.mem.COM_mod_PH_A=mod_V_a;
    p_pow.p_var.mem.COM_mod_PH_B=mod_V_b;
    p_pow.p_var.mem.COM_mod_PH_C=mod_V_c;

    p_pow.p_stat.bit.command_initialized=1;
}



void INIT_CONVERTER_POWER(void)
{


}
/////////////////////////////////////////////////////
void RESET_ALL_FLAGS(void)
{
	p_pow.p_stat.all=0x0000;
	p_pow.p_bits.all=0x0000;

	sys.pro_flag.all=0;
	sys.sen_flag.all=0;
}
/////////////////////////////////////////////////////
void TURN_ON_CONTACTOR(void)
{


}
////////////////////////////////////////////////////
void TURN_OFF_CONTACTOR(void)
{

}




////////////////////////////////////////////////////////////////////////////////////////
void CHECK_TURN_INVERTER_ON(void)
{
	if(p_pow.p_bits.bit.GPIO_I1_STATE_bit==1)
	{
		p_pow.p_bits.bit.TURN_ON_DAB=1;
		RESET_GPIO_I1_STATE();
	}
}
void CHECK_TURN_INVERTER_OFF(void)
{
	if(p_pow.p_bits.bit.GPIO_I1_STATE_bit==1)
	{
		p_pow.p_bits.bit.TURN_ON_DAB=0;
		RESET_GPIO_I1_STATE();
	}
}
/////////////////////////////////////////////////////////////////////////////////////////
void INVERTER_PWM_RELEASE(void)
{
    RELEASE_PWM_PULSE();

    p_pow.p_stat.bit.PWM_status=1;
    p_pow.p_stat.bit.INVERTER_status=1;
}
/////// Inverter OFF /////////////////////////////////////////////////////////////////////
void INVERTER_PWM_BLOCK(void)
{
	p_pow.p_stat.bit.INVERTER_status=0;
	p_pow.p_stat.bit.PWM_status=0;
	BLOCK_PWM_PULSE();
}

//////////////////////////////////////////////////////////////////////////////////////////
#define count_1_msec ISR_KHz
Uint16 counter_1_msec=0;

#define count_10_msec (int16)(10*ISR_KHz)
Uint16 counter_10_msec=0;

#define count_100_msec (int16)(100*ISR_KHz)
Uint16 counter_100_msec=0;

#define count_500_msec (int16)(500*ISR_KHz)
Uint16 counter_500_msec=0;

void GENERATE_PULSE(void)
{
    p_pow.p_pulse.bit.pulse_1_ms=0;
    counter_1_msec++;
    if(counter_1_msec==count_1_msec)
    {
        counter_1_msec=0;
        p_pow.p_pulse.bit.pulse_1_ms=1;
    }

	p_pow.p_pulse.bit.pulse_10_ms=0;
	counter_10_msec++;
	if(counter_10_msec==count_10_msec)
	{
		counter_10_msec=0;
		p_pow.p_pulse.bit.pulse_10_ms=1;
	}

	p_pow.p_pulse.bit.pulse_100_ms=0;
	counter_100_msec++;
	if(counter_100_msec==count_100_msec)
	{
		counter_100_msec=0;
		p_pow.p_pulse.bit.pulse_100_ms=1;
	}

	p_pow.p_pulse.bit.pulse_500_ms=0;
	counter_500_msec++;
	if(counter_500_msec==count_500_msec)
	{
		counter_500_msec=0;
		p_pow.p_pulse.bit.pulse_500_ms=1;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////
void RESET_PAR_INVERTER_OFF(void)
{
	RESET_INVERTER_PAR();
	RESET_INVERTER_MODULATION_PAR();
	RESET_SIGNAL_CONDITION_PAR();

	RESET_ISR_TASK();
	RESET_DISPAY_PAR_01();
	RESET_DISPAY_PAR_02();
	RESET_PROTECTION();
}
///////////////////////////////////////////////////////////////////////////////////////////////
void RESET_INVERTER_PAR(void)
{
	p_pow.p_stat.bit.INVERTER_status=0;
	p_pow.p_stat.bit.SOFT_OFF_done=0;

	p_pow.p_pulse.bit.pulse_500_ms=0;
	p_pow.p_pulse.bit.pulse_100_ms=0;
	p_pow.p_pulse.bit.pulse_10_ms=0;
	p_pow.p_pulse.bit.pulse_1_ms=0;

	p_pow.p_stat.bit.command_initialized=0;

	p_pow.p_bits.bit.accept_NEW_duty=0;
	p_pow.p_bits.bit.activate_COM_CUR=0;
	p_pow.p_bits.bit.activate_PHASE=0;

	p_pow.p_bits.bit.CC_CHARGING_complete=0;
	p_pow.p_bits.bit.CV_CHARGING_complete=0;
	p_pow.p_stat.bit.I3_I4_PRESSED=0;

	mod_Vq_CUR=0;
	mod_Vd_CUR=0;

	theta_SIM=0;
}


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
