////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
#ifndef __00_f28002x_Converter_Power_H__
#define __00_f28002x_Converter_Power_H__

#include <IQmathLib.h>
#include "01_f28002x_device.h"
void INIT_ALL(void);
void INIT_SPI_PAR_MCP23S17(void);
void RESET_ALL_FLAGS(void);
void INIT_CONVERTER_POWER(void);
void ASSIGN_DUTY_COMMAND(void);
void INVERTER_PWM_RELEASE(void);
void INVERTER_PWM_BLOCK(void);
void RESET_PAR_INVERTER_OFF(void);
void RESET_INVERTER_PAR(void);
void CHECK_TURN_INVERTER_ON(void);
void CHECK_TURN_INVERTER_OFF(void);
void CURRENT_abc_to_dq(void);

void SYN_FRAME_CONTROL(void);
void REG_CURRENT_dq(void);
void VOLTAGE_dq_to_abc(void);

void GENERATE_PULSE(void);

void CHECK_HV_CONT_ON(void);
void TURN_ON_CONTACTOR(void);
void TURN_OFF_CONTACTOR(void);

#define act_V_dc_TH 30//30V Vdc threshold
#define V_dc_TH _IQmpyI32(VOLTAGE_to_IQ,(int16)act_V_dc_TH)

#define vol_throttle_TH_HIGH _IQ(0.10)
#define vol_throttle_TH_LOW _IQ(0.075)

struct POWER_STATUS{
	Uint16 INVERTER_status:1;			//
	Uint16 PWM_status:1;
	Uint16 SOFT_OFF_done:1;
	Uint16 adc_offset_done:1;
	Uint16 PWM_REG_loaded:1;
    Uint16 command_initialized:1;
	Uint16 HALL_A:1;
    Uint16 HALL_B:1;
	Uint16 HALL_C:1;
	Uint16 theta_FOC_assigned:1;
	Uint16 HALL_TRANSITION_1st:1;
    Uint16 HALL_TRANSITION_2nd:1;
	Uint16 ss_06:1;
    Uint16 ss_07:1;
    Uint16 I3_I4_PRESSED:1;
    Uint16 I2_I3_I4_PRESSED:1;
	};
	
union POWER_STATUS_REG{
	Uint16						all;
	struct POWER_STATUS			bit;
};

struct ECAP_INTERRUPT_REG{
    Uint16 ECAP_01_CEVT_1:1;
    Uint16 ECAP_01_CEVT_2:1;
    Uint16 ECAP_01_CEVT_3:1;
    Uint16 ECAP_01_CEVT_4:1;
    Uint16 ECAP_02_CEVT_none_1:1;
    Uint16 ECAP_02_CEVT_none_2:1;
    Uint16 ECAP_02_CEVT_none_3:1;
    Uint16 ECAP_02_CEVT_none_4:1;
    Uint16 ECAP_03_CEVT_none_1:1;
    Uint16 ECAP_03_CEVT_none_2:1;
    Uint16 ECAP_03_CEVT_none_3:1;
    Uint16 ECAP_03_CEVT_none_4:1;
    Uint16 ECAP_01_INT:1;
    Uint16 ECAP_01_none_1:1;
    Uint16 ECAP_01_none_2:1;
    Uint16 ECAP_01_none_3:1;
    };

union ECAP_INTERRUPT{
    Uint16                      all;
    struct ECAP_INTERRUPT_REG    bit;
};

struct POWER_BITS{
	Uint16 GPIO_I1_STATE_bit:1;//
	Uint16 GPIO_I2_STATE_bit:1;
	Uint16 GPIO_I3_STATE_bit:1;
	Uint16 GPIO_I4_STATE_bit:1;
	Uint16 TURN_ON_DAB:1;
    Uint16 CC_CHARGING_complete:1;
    Uint16 CV_CHARGING_complete:1;
	Uint16 activate_PHASE:1;
	Uint16 activate_COM_CUR:1;
	Uint16 accept_NEW_duty:1;
    Uint16 bb_10:1;
    Uint16 bb_11:1;
    Uint16 bb_12:1;
    Uint16 bb_13:1;
    Uint16 bb_14:1;
    Uint16 bb_15:1;
	};

union POWER_BITS_REG{
	Uint16						all;
	struct POWER_BITS			bit;
};

struct POWER_PULSE{
    Uint16 pp_10:1;
    Uint16 pulse_100_ms:1;
    Uint16 pulse_10_ms:1;
    Uint16 pulse_1_ms:1;
    Uint16 pulse_500_ms:1;
    Uint16 pp_11:1;
    Uint16 pp_00:1;//
    Uint16 pp_01:1;
    Uint16 pp_02:1;
    Uint16 pp_03:1;
    Uint16 pp_04:1;
    Uint16 pp_05:1;
    Uint16 pp_06:1;
    Uint16 pp_07:1;
    Uint16 pp_08:1;
    Uint16 pp_09:1;
    };

union POWER_PULSE_REG{
    Uint16                      all;
    struct POWER_PULSE          bit;
};

struct POWER_VOLTAGE{
	_iq V_a;
	_iq V_a_filter;
	_iq V_b;
	_iq V_b_filter;
    _iq V_c;
    _iq V_c_filter;
    _iq V_dc;
    _iq V_dc_filter;
    _iq adc_c_dummy;
	};
	
union POWER_VOLTAGE_REG{
	struct POWER_VOLTAGE	mem;//member
};

struct POWER_CURRENT{
	_iq I_dc;
	_iq I_dc_filter;
	_iq I_dc_OFFSET;
    _iq I_a;
    _iq I_a_filter;
    _iq I_b;
    _iq I_b_filter;
    _iq I_c;
    _iq I_c_filter;
    _iq adc_a_dummy;
	};

union POWER_CURRENT_REG{
	struct POWER_CURRENT	mem;
};


struct POWER_INV{
	_iq i_00;			//
	_iq inverse_samples_per_fund_cycle;
	_iq speed_RPS;
	_iq speed_RPS_normalized;
	_iq TEMP_LV;
	_iq TEMP_LV_filter;
	_iq TEMP_HV;
	_iq TEMP_HV_filter;
	_iq TEMP_TX;
	_iq TEMP_TX_filter;
	_iq TEMP_CH;
	_iq TEMP_CH_filter;
	_iq i_14;
	_iq i_15;
	};

union POWER_INV_REG{
	struct POWER_INV	mem;
};

struct POWER_VAR{
    _iq inv_PWM_full_PRD;
    _iq theta_FOC_dq;
	_iq POWER_IN;
	_iq COM_iq;
	_iq COM_id;
    _iq COMMAND_01;
    _iq COMMAND_02;
    _iq COMMAND_03;
    _iq COMMAND_04;
	_iq COM_mod_PH_A;
	_iq COM_mod_PH_B;
	_iq COM_mod_PH_C;
	_iq mod_Eb;
	_iq vol_throttle;
	};

union POWER_VAR_REG{
	struct POWER_VAR	mem;
};

struct POWER_PAR{
	Uint16 MODE_STATE;
	Uint16 fsw_Hz;
	Uint16 TB_MAX_x_2;
	Uint16 HALL_ABC_SECTOR;
	Uint16 HALL_SECTOR_OLD;
	Uint16 CONV_1st_MODE;							//
	Uint16 CONV_2nd_MODE;							//
	Uint16 CONV_3rd_MODE;
	Uint16 CONV_4th_MODE;
	Uint16 SCREEN_MODE;
	Uint16 display_DONE_STATE;
	Uint16 PAR_UP_DOWN;
	};
union POWER_PAR_REG{
	struct POWER_PAR	mem;
};

struct POWER_REG {
	union POWER_VOLTAGE_REG		p_vol;
	union POWER_CURRENT_REG		p_cur;
	union POWER_INV_REG			p_inv;
	union POWER_STATUS_REG		p_stat;
	union POWER_BITS_REG		p_bits;
	union POWER_PULSE_REG       p_pulse;
	union POWER_VAR_REG			p_var;
	union POWER_PAR_REG			p_par;
	union ECAP_INTERRUPT        ECAP_int;
};

extern volatile struct POWER_REG p_pow;


struct PROTECTION_FLAG{ // bits  description
	Uint16  I_H_high:1;					// bit 0: Inverter o/p short circuit
	Uint16  I_L_high:1;					// bit 1:
	Uint16  p_02:1;						// bit 2:
	Uint16  TEMP_1_high:1;				// bit 3:
	Uint16  TEMP_2_high:1;				// bit 4:
	Uint16  V_dc_high:1;						// bit 5:
	Uint16  p_09:1;						// bit 9:
	Uint16  p_10:1; 					// bit 10:
	Uint16  p_11:1;						// bit 11::
	Uint16  overall_pro_flag:1;			// bit 15:
	};
union PROTECTION_FLAG_REG {
	Uint16						all;
	struct PROTECTION_FLAG		bit;
};


struct SENSOR_FLAG{ // bits  description
	Uint16  I_H_sen_fault:1;				// bit 0: Inverter o/p short circuit
	Uint16  I_L_sen_fault:1;				// bit 1:
	Uint16  sen_02:1;						// bit 2:
	Uint16  overall_sen_fault:1;			// bit 3:
	Uint16  sen_04:1;						// bit 4:
	Uint16  sen_05:1;						// bit 5:
	Uint16  sen_06:1;						// bit 6:
	Uint16  sen_07:1;						// bit 7:
	Uint16  sen_08:1;						// bit 8:
	Uint16  sen_09:1;						// bit 9:
	Uint16  sen_10:1; 						// bit 10:
	Uint16  sen_11:1;						// bit 11:
	Uint16  sen_12:1;						// bit 12:
	Uint16  sen_13:1;						// bit 13:
	Uint16  sen_14:1;						// bit 14:
	Uint16  sen_15:1;						// bit 15:
	};
union SENSOR_FLAG_REG {
	Uint16						all;
	struct SENSOR_FLAG			bit;
};


struct SYSTEM_REG {
	union PROTECTION_FLAG_REG	pro_flag;
	union SENSOR_FLAG_REG		sen_flag;
};

extern volatile struct SYSTEM_REG sys;

#endif


