
#ifndef __00_f28002x_MCP4922_DAC_H__
#define __00_f28002x_MCP4922_DAC_H__

#include <IQmathLib.h>
#include "01_f28002x_device.h"

typedef struct	{
				_iq	MCP4922_CH_A;
				_iq	MCP4922_CH_B;
				} MCP4922_DAC_PAR;

#define MCP4922_DAC_PAR_0	{_IQ(0.0),_IQ(0.0)}

int16 tmp_DAC_CH_A=0;
int16 tmp_DAC_CH_B=0;
int16 tmp_DAC_cal=0;

#define DAC_A_SPI_inst 0x7000
#define DAC_B_SPI_inst 0xF000

#define DAC_offset 0x3FFF

#define DAC_max_limit 16383 //0x3FFF
#define DAC_min_limit -16383 //-0x3FFF


#define MCP4922_DAC_A_MACRO(v)														\
	if(v.MCP4922_CH_A>_IQ(1.0))v.MCP4922_CH_A=_IQ(1.0);								\
	if(v.MCP4922_CH_A<_IQ(-1.0))v.MCP4922_CH_A=_IQ(-1.0);							\
	tmp_DAC_CH_A=(int16)_IQtoIQ15(v.MCP4922_CH_A);									\
	tmp_DAC_cal=tmp_DAC_CH_A;														\
	tmp_DAC_CH_A=tmp_DAC_CH_A>>1;													\
	if(tmp_DAC_CH_A>DAC_max_limit)tmp_DAC_CH_A=DAC_max_limit;						\
	if(tmp_DAC_CH_A<DAC_min_limit)tmp_DAC_CH_A=DAC_min_limit;						\
	tmp_DAC_CH_A=tmp_DAC_CH_A+DAC_offset;											\
	tmp_DAC_CH_A=(tmp_DAC_CH_A>>3)&(0x0FFF);										\
	tmp_DAC_CH_A=DAC_A_SPI_inst+tmp_DAC_CH_A;										\
	/*	SpibRegs.SPITXBUF=0x7000;// write 0 to DAC-A	*/							\
	SpiaRegs.SPITXBUF=tmp_DAC_CH_A;													\

#define MCP4922_DAC_B_MACRO(v)														\
																					\
	if(v.MCP4922_CH_B>_IQ(1.0))v.MCP4922_CH_B=_IQ(1.0);								\
	if(v.MCP4922_CH_B<_IQ(-1.0))v.MCP4922_CH_B=_IQ(-1.0);							\
	tmp_DAC_CH_B=(int16)_IQtoIQ15(v.MCP4922_CH_B);									\
	tmp_DAC_CH_B=tmp_DAC_CH_B>>1;													\
	if(tmp_DAC_CH_B>DAC_max_limit)tmp_DAC_CH_B=DAC_max_limit;						\
	if(tmp_DAC_CH_B<DAC_min_limit)tmp_DAC_CH_B=DAC_min_limit;						\
	tmp_DAC_CH_B=tmp_DAC_CH_B+DAC_offset;											\
	tmp_DAC_CH_B=DAC_B_SPI_inst+((tmp_DAC_CH_B>>3)&(0x0FFF));						\
	/*	SpibRegs.SPITXBUF=0x7000;// write 0 to DAC-A	*/							\
	SpiaRegs.SPITXBUF=tmp_DAC_CH_B;													\



#endif
