///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_04_master.h>
#include <00_f28002x_KEY_PAD.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_STATE_MACHINE.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"
#include "01_f28002x_examples.h"
///////////////////////////////////////////////////////////////////////////////
int16 MASTER_current_line=LINE_NO_01;
int16 MASTER_current_screen=SCREEN_NO_01;
Uint16 *GET_MODE_COMMAND=0;
///////////////////////////////////////////////////////////////////////////////
Uint16 MASTER_dis_STATE=MASTER_PAR_reset_STATE;
Uint16 CALSTAT_SCREEN_over=0;// CALSTAT SCREEN, very 1st screen
Uint16 MASTER_screen_par[NUMBER_OF_SCREEN_PAR]={0,0};
Uint16 total_no_of_screens=NO_OF_RUN_SCREEN;
Uint16 MODE_LAST_line_NUMBER=LINE_NO_01;
Uint16 MODE_all_lines_displayed=0;
Uint16 MODE_currently_active=0;
Uint16 lock_PAR_screen_request=0;
Uint16 lock_PAR_screen_1st_request=0;
Uint16 repeat_current_RUN_screen=0;
Uint16 COM_LAST_line_NUMBER=LINE_NO_01;
Uint16 COM_all_lines_displayed=0;

///////////////////////////////////////////////////////////////////////////////////
void MASTER_DISPLAY_MAIN(void)
{
    switch(MASTER_dis_STATE)
    {
    case MASTER_PAR_reset_STATE:
        MASTER_reset_PAR();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_PAR_reset_done)MASTER_dis_STATE=MASTER_screen_clear_STATE;
    break;

    case MASTER_screen_clear_STATE:
        MASTER_SEND_screen_clear();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_screen_clear_done)MASTER_dis_STATE=MASTER_delay_and_next_LINE_STATE;
    break;

    case MASTER_get_line_and_screen_number_STATE:
        MASTER_GET_LINE_and_SCREEN_NUMBER();// just the parameter for that very line
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_get_line_and_screen_number_done)MASTER_dis_STATE=MASTER_make_line_ARRAY_STATE;
    break;

    case MASTER_get_line_PAR_STATE:
        MASTER_GET_RUN_LINE_PAR();// just the parameter for that very line
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_RUN_get_PAR_done)MASTER_dis_STATE=MASTER_make_line_ARRAY_STATE;
    break;

    case MASTER_make_line_ARRAY_STATE:MASTER_CREATE_LINE_array(); // array with CHAR and PAR value for one line only
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_line_array_done)MASTER_dis_STATE=MASTER_send_line_CHAR_STATE;
    break;

    case MASTER_send_line_CHAR_STATE:
        MASTER_SEND_CHAR_ONE_LINE();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_send_line_done)MASTER_dis_STATE=MASTER_check_4th_LINE_00;
    break;

    case MASTER_check_4th_LINE_00:
        MASTER_current_line++;
        if(MASTER_current_line == LINE_PER_SCREEN)MASTER_dis_STATE=MASTER_check_4th_LINE_01;//lines_in_current_screen
        else MASTER_dis_STATE=MASTER_delay_and_next_LINE_STATE;
    break;

    case MASTER_delay_and_next_LINE_STATE:
        MASTER_screen_par[0]=MASTER_current_line;
        MASTER_screen_par[1]=MASTER_current_screen;
        MASTER_DELAY_between_LINES();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_delay_between_lines_done)MASTER_dis_STATE=MASTER_get_line_and_screen_number_STATE;
    break;

    case MASTER_check_4th_LINE_01:
        if((p_pow.p_bits.bit.GPIO_I2_STATE_bit==1)&&(p_pow.p_bits.bit.GPIO_I3_STATE_bit==1))// reset if both are 1
        {
            RESET_GPIO_I2_STATE();
            RESET_GPIO_I3_STATE();
            MASTER_dis_STATE=MASTER_check_4th_LINE_04;
        }
        else MASTER_dis_STATE=MASTER_check_4th_LINE_02;
    break;
    case MASTER_check_4th_LINE_02:
        if(((p_pow.p_bits.bit.GPIO_I2_STATE_bit==1)||(p_pow.p_bits.bit.GPIO_I3_STATE_bit==1))&&(CALSTAT_SCREEN_over==1)&&(lock_PAR_screen_1st_request==0))// reject I2, I3 input at the very first screen: company display screen
        {
            lock_PAR_screen_1st_request=1;
            if(p_pow.p_bits.bit.GPIO_I2_STATE_bit==1)p_pow.p_par.mem.SCREEN_MODE=screen_COMMAND;
            if(p_pow.p_bits.bit.GPIO_I3_STATE_bit==1)p_pow.p_par.mem.SCREEN_MODE=screen_COMMAND;
        }
        MASTER_dis_STATE=MASTER_check_4th_LINE_03;
    break;
    case MASTER_check_4th_LINE_03:
        RESET_GPIO_I2_STATE();
        RESET_GPIO_I3_STATE();
        RESET_GPIO_I4_STATE();
        lock_PAR_screen_request=(!sys.sen_flag.bit.overall_sen_fault)&(!sys.pro_flag.bit.overall_pro_flag)&lock_PAR_screen_1st_request;
        MASTER_dis_STATE=MASTER_check_4th_LINE_06;
    break;
    case MASTER_check_4th_LINE_04:
        if(lock_PAR_screen_request==0)MASTER_dis_STATE=MASTER_check_4th_LINE_05;
        else MASTER_dis_STATE=MASTER_COMMAND_clear_STATE;
    break;
    case MASTER_check_4th_LINE_05:
        if(p_pow.p_bits.bit.GPIO_I4_STATE_bit==1)repeat_current_RUN_screen=!repeat_current_RUN_screen;
        RESET_GPIO_I4_STATE();
        MASTER_dis_STATE=MASTER_check_4th_LINE_06;
    break;
    case MASTER_check_4th_LINE_06:
        if((sys.sen_flag.bit.overall_sen_fault==1)||(sys.pro_flag.bit.overall_pro_flag==1))repeat_current_RUN_screen=0;
        MASTER_dis_STATE=MASTER_check_4th_LINE_07;
    break;
    case MASTER_check_4th_LINE_07:
        CALSTAT_SCREEN_over=1;// reject I2, I3 input at the very first screen: CALSTAT display screen
        MASTER_current_line=LINE_NO_01;
        if(repeat_current_RUN_screen==0)MASTER_current_screen++;// do not go to next screen if REFRESH is requested
        MASTER_dis_STATE=MASTER_check_4th_LINE_08;
    break;
    case MASTER_check_4th_LINE_08:
        // if no sensor and protection fault, look for par change request and lock the screen
        // increase one screen in case fault or sensor error
        if((sys.sen_flag.bit.overall_sen_fault==1)||(sys.pro_flag.bit.overall_pro_flag==1))total_no_of_screens=NO_OF_RUN_SCREEN+1;
        // OR keep the same no of screen
        else total_no_of_screens=NO_OF_RUN_SCREEN;
        MASTER_dis_STATE=MASTER_check_4th_LINE_09;
    break;
    case MASTER_check_4th_LINE_09:
        if(MASTER_current_screen >= total_no_of_screens)MASTER_current_screen=SCREEN_NO_01;
        MASTER_dis_STATE=MASTER_delay_and_change_SCREEN_STATE;
    break;

    case MASTER_delay_and_change_SCREEN_STATE:
        MASTER_screen_par[0]=MASTER_current_line;
        MASTER_screen_par[1]=MASTER_current_screen;
        MASTER_DELAY_between_SCREENS();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_delay_between_screens_done)MASTER_dis_STATE=MASTER_screen_clear_STATE;
    break;
////***********************************************************************************************************////
//////////////////////////////////////////  COMMAND MODE  /////////////////////////////////////////////////////////
////***********************************************************************************************************////
    case MASTER_COMMAND_clear_STATE:MASTER_SEND_screen_clear();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_screen_clear_done)MASTER_dis_STATE=MASTER_COMMAND_get_line_and_screen_number_STATE;
    break;
    case MASTER_COMMAND_get_line_and_screen_number_STATE:MASTER_GET_LINE_and_SCREEN_NUMBER();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_get_line_and_screen_number_done)MASTER_dis_STATE=MASTER_COMMAND_array_STATE;
    break;
    case MASTER_COMMAND_get_PAR_STATE:MASTER_COMMAND_get_PAR();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_COMMAND_get_par_done)MASTER_dis_STATE=MASTER_COMMAND_array_STATE;
    break;
    case MASTER_COMMAND_array_STATE:MASTER_COMMAND_create_ARRAY();
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_COMMAND_array_done)MASTER_dis_STATE=MASTER_COMMAND_send_LINE_STATE;
    break;
    case MASTER_COMMAND_send_LINE_STATE:

        MASTER_SEND_CHAR_ONE_LINE();// get scrolling screen parameters
        if(p_pow.p_par.mem.display_DONE_STATE==MASTER_send_line_done)
        {
            if(MODE_all_lines_displayed==0)MASTER_dis_STATE=MASTER_COMMAND_all_lines_00;
            else MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_00;
        }
    break;

    case MASTER_COMMAND_all_lines_00:
        if((MASTER_current_screen*LINE_PER_SCREEN+LINE_PER_SCREEN)<=(NUMBER_OF_MODES+NUMBER_OF_MODES))MODE_LAST_line_NUMBER=LINE_PER_SCREEN;
        else MODE_LAST_line_NUMBER=NUMBER_OF_MODES+NUMBER_OF_MODES-MASTER_current_screen*LINE_PER_SCREEN;// calculate
        MASTER_dis_STATE=MASTER_COMMAND_all_lines_01;
    break;
    case MASTER_COMMAND_all_lines_01:
        if(MASTER_current_line<(MODE_LAST_line_NUMBER-1))
        {
            MASTER_current_line++;// increase line number to the last line for the current screen
            MASTER_screen_par[0]=MASTER_current_line;
            MASTER_dis_STATE=MASTER_COMMAND_all_lines_02;
        }
        else MASTER_dis_STATE=MASTER_COMMAND_all_lines_03;
    break;
    case MASTER_COMMAND_all_lines_02:
        MASTER_dis_STATE=MASTER_get_line_and_screen_number_STATE;
        MASTER_dis_STATE=MASTER_COMMAND_all_lines_03;
    break;
    case MASTER_COMMAND_all_lines_03:
        MASTER_dis_STATE=MASTER_COMMAND_cursor_LINE_STATE;
        MASTER_current_line=0; // go to line 0 and blink
        MASTER_screen_par[0]=MASTER_current_line;
        MASTER_dis_STATE=MASTER_COMMAND_all_lines_03;
        MODE_all_lines_displayed=1;
    break;

///////////////////////////////////////////
    case MASTER_COMMAND_check_KEY_INPUT_00:
        if((p_pow.p_bits.bit.GPIO_I3_STATE_bit==1)&&(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP_DOWN_0))p_pow.p_par.mem.PAR_UP_DOWN=PAR_UP;
        if((p_pow.p_bits.bit.GPIO_I4_STATE_bit==1)&&(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP_DOWN_0))p_pow.p_par.mem.PAR_UP_DOWN=PAR_DOWN;
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_01:
        RESET_GPIO_I3_STATE();
        RESET_GPIO_I4_STATE();
        if(p_pow.p_par.mem.PAR_UP_DOWN!=PAR_UP_DOWN_0)
        {
            MASTER_dis_STATE=MASTER_COMMAND_alter_PAR_STATE;
            MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
            MODE_all_lines_displayed=0;
        }
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_02:
        if(p_pow.p_bits.bit.GPIO_I2_STATE_bit==1)MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
        else MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_03:
        RESET_GPIO_I2_STATE();
        MASTER_current_line++;
        MASTER_current_line++;
        MODE_currently_active++;// change the MODE
        MASTER_screen_par[0]=MASTER_current_line;
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_04:
        if((MASTER_current_screen*LINE_PER_SCREEN+MASTER_current_line)>=(NUMBER_OF_MODES+NUMBER_OF_MODES))MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
        else MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_05:
        RESET_DISPAY_PAR_01();
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_06:
        RESET_DISPAY_PAR_02();
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_07:
        RESET_DISPAY_PAR_03();
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
        MASTER_dis_STATE=MASTER_COM_clear_STATE;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_08:
        if(MASTER_current_line>=MODE_LAST_line_NUMBER)MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
        else MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_09:
        MASTER_dis_STATE=MASTER_COMMAND_cursor_LINE_STATE;
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    case MASTER_COMMAND_check_KEY_INPUT_10:
        MASTER_current_line=LINE_NO_01;
        MASTER_current_screen++;
        MASTER_screen_par[0]=MASTER_current_line;
        MASTER_screen_par[1]=MASTER_current_screen;
        MODE_all_lines_displayed=0;
        MASTER_dis_STATE=MASTER_COMMAND_clear_STATE;
        MASTER_dis_STATE=MASTER_COMMAND_check_KEY_INPUT_01;
    break;
    }
}
/////////////////////////////////////////////////////////////////////////////
Uint16 *DISPLAY_line_and_screen_number(void)
{
    return MASTER_screen_par; //1st element line number, 2nd screen number
}
/////////////////////////////////////////////////////////////////////////////

void CHECK_for_PAR_UP_DOWN(void)
{
    if((p_pow.p_bits.bit.GPIO_I3_STATE_bit==1)&&(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP_DOWN_0))p_pow.p_par.mem.PAR_UP_DOWN=PAR_UP;
    if((p_pow.p_bits.bit.GPIO_I4_STATE_bit==1)&&(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP_DOWN_0))p_pow.p_par.mem.PAR_UP_DOWN=PAR_DOWN;
    RESET_GPIO_I3_STATE();
    RESET_GPIO_I4_STATE();
}

/////////////////////////////////////////////////////////////////////////////
void CHECK_CURRENT_SCREEN_REPEAT_REQUEST(void)
{
    if(p_pow.p_bits.bit.GPIO_I4_STATE_bit==1)repeat_current_RUN_screen=!repeat_current_RUN_screen;
    RESET_GPIO_I4_STATE();
    if((sys.sen_flag.bit.overall_sen_fault==1)||(sys.pro_flag.bit.overall_pro_flag==1))repeat_current_RUN_screen=0;
}
/////////////////////////////////////////////////////////////////////////////
void RESET_DISPAY_PAR_01(void)
{
	lock_PAR_screen_1st_request=0;
	lock_PAR_screen_request=0;
	p_pow.p_bits.bit.GPIO_I1_STATE_bit=0;
	p_pow.p_bits.bit.GPIO_I2_STATE_bit=0;
	p_pow.p_bits.bit.GPIO_I3_STATE_bit=0;
	p_pow.p_bits.bit.GPIO_I4_STATE_bit=0;
}

void RESET_DISPAY_PAR_02(void)
{
    MASTER_current_line=LINE_NO_01;
    MASTER_current_screen=SCREEN_NO_01;
    MASTER_screen_par[0]=MASTER_current_line;
    MASTER_screen_par[1]=MASTER_current_screen;

    p_pow.p_par.mem.PAR_UP_DOWN=PAR_UP_DOWN_0;
    repeat_current_RUN_screen=0;
    p_pow.p_par.mem.SCREEN_MODE=screen_SCROLL;
}

void RESET_DISPAY_PAR_03(void)
{
    MODE_LAST_line_NUMBER=0;
    COM_LAST_line_NUMBER=0;
    COM_all_lines_displayed=0;
    MODE_currently_active=0;
    MODE_all_lines_displayed=0;
}

////////////////////////////////////////////////////////////

