
/////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_04_master.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_STATE_MACHINE.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////////
int16 display_RUN_parameter[NUMBER_OF_RUN_PAR];
int16 display_MODE_PAR[MAX_MODES*LINE_PER_MODE];
int16 display_COM_PAR[NUMBER_OF_COMMANDS];
Uint16 *CURSOR_line_and_screen_number;

int16 NUMBER_digits[DIG_numbers_in_LINE];

//////////////////////////////////////////////////////////////////////////////////////////////////////////
const char mode_1st_PAR_char[MODES_ARRAY][total_CHAR_in_RUN_LINE]=
                                                        {mode_1st_PAR_string_01,
                                                         mode_1st_PAR_string_02,
                                                         mode_1st_PAR_string_03,
                                                         mode_1st_PAR_string_04,
                                                         mode_1st_PAR_string_05,
                                                         mode_1st_PAR_string_06,
                                                         mode_1st_PAR_string_07,
                                                         mode_1st_PAR_string_08,
                                                         mode_1st_PAR_string_09,};
////////////////////////////////////////////////////////////////////////////////////////
const char mode_2nd_PAR_char[MODES_ARRAY][total_CHAR_in_RUN_LINE]=
                                                    {mode_2nd_PAR_string_01,
                                                     mode_2nd_PAR_string_02,
                                                     mode_2nd_PAR_string_03,
                                                     mode_2nd_PAR_string_04,
                                                     mode_2nd_PAR_string_05,
                                                     mode_2nd_PAR_string_06,
                                                     mode_2nd_PAR_string_07,};
////////////////////////////////////////////////////////////////////////////////////////
const char mode_3rd_PAR_char[MODES_ARRAY][total_CHAR_in_RUN_LINE]=
                                        {mode_3rd_PAR_string_01,
                                        mode_3rd_PAR_string_02,
                                        mode_3rd_PAR_string_03,
                                        mode_3rd_PAR_string_04,
                                        mode_3rd_PAR_string_05,};
//////////////////////////////////////////////////////////////////////////////////
const char mode_4th_PAR_char[MODES_ARRAY][total_CHAR_in_RUN_LINE]=
                                        {mode_4th_PAR_string_01,
                                        mode_4th_PAR_string_02,
                                        mode_4th_PAR_string_03,
                                        mode_4th_PAR_string_04,
                                        mode_4th_PAR_string_05,};


////////////////////////////////////////////////////////////////////////////////////////////////////

const char command_PAR_char[NUMBER_OF_COMMANDS][total_CHAR_in_RUN_LINE]=
                                                    {command_string_01,
                                                     command_string_02,
                                                     command_string_03,
                                                     command_string_04,
                                                     command_string_05,
                                                     command_string_06,
                                                     command_string_07,
                                                     command_string_08,
                                                     };

////////////////////////////////////////////////////////////////////////////////////////////////////
const char display_STRING_RUN_MODE[NUMBER_OF_RUN_PAR][total_CHAR_in_RUN_LINE]=
                                {run_string_01,
                                run_string_02,
                                run_string_03,
                                run_string_04,
                                run_string_05,
                                run_string_06,
                                run_string_07,
                                run_string_08,
                                run_string_09,
                                run_string_10,
                                run_string_11,
                                run_string_12,
                                run_string_13,
                                run_string_14,
                                run_string_15,
                                run_string_16,
                                };

/////////////////////////////////////////////////////////////////////////
const char CALSTAT_SCREEN_4_LINES[LINE_PER_SCREEN][total_CHAR_in_RUN_LINE]=
                                    {calstat_string_01,
                                     calstat_string_02,
                                     calstat_string_03,
                                     calstat_string_04,};

const char FAULT_ARRAY_30_LINES[number_of_faults][total_CHAR_in_RUN_LINE]=
                                {fault_string_00,
                                fault_string_01,
                                fault_string_02,
                                fault_string_03,
                                fault_string_04,
                                fault_string_05,
                                fault_string_06,
                                fault_string_07,
                                fault_string_08,
                                fault_string_09,
                                fault_string_10,
                                fault_string_11,
                                fault_string_12,
                                fault_string_13,
                                fault_string_14,
                                fault_string_15,
                                fault_string_16,
                                fault_string_17,
                                fault_string_18,
                                fault_string_19,
                                fault_string_20,
                                fault_string_21,
                                fault_string_22,
                                fault_string_23,
                                fault_string_24,
                                fault_string_25,
                                fault_string_26,
                                fault_string_27,
                                fault_string_28,
                                fault_string_29,
                                };
//////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
Uint16 index_ARRAY_main=CASE_00;
Uint16 index_ARRAY_aux=CASE_00;
void MASTER_reset_PAR(void)
{
    display_RUN_parameter[index_ARRAY_main]=0;
    index_ARRAY_main++;
    if(index_ARRAY_main>=NUMBER_OF_RUN_PAR)
    {
        index_ARRAY_main=CASE_00;
        p_pow.p_par.mem.display_DONE_STATE=MASTER_PAR_reset_done;
    }
}
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
Uint16 display_line_number=0;
Uint16 display_screen_number=0;
void MASTER_GET_LINE_and_SCREEN_NUMBER(void) // line and screen number
{
    CURSOR_line_and_screen_number=DISPLAY_line_and_screen_number();
    display_line_number=CURSOR_line_and_screen_number[0];//1st element is line number
    display_screen_number=CURSOR_line_and_screen_number[1];//2nd element is screen number
    p_pow.p_par.mem.display_DONE_STATE=MASTER_get_line_and_screen_number_done;
}
/////////////////////////////////////////////////////////////////////////////

void MASTER_COMMAND_get_PAR(void)// only ref PAR, gets displayed when PAR screen is requested to be locked
{
    switch(display_line_number+display_screen_number*LINE_PER_SCREEN)
    {
    case CASE_00:
        display_COM_PAR[CASE_00]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_01,(int16)Ki_display);
    break;
    case CASE_01:
        display_COM_PAR[CASE_01]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_02,(int16)Ki_display);
    break;
    case CASE_02:
        display_COM_PAR[CASE_02]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_03,(int16)Ki_display);
    break;
    case CASE_03:
        display_COM_PAR[CASE_03]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_04,(int16)Ki_display);
    break;

    case CASE_04:
        display_COM_PAR[CASE_04]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_01,(int16)Ki_display);
    break;
    case CASE_05:
        display_COM_PAR[CASE_05]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_01,(int16)Ki_display);
    break;
    case CASE_06:
        display_COM_PAR[CASE_06]=_IQmpyI32int(p_pow.p_var.mem.COMMAND_01,(int16)Ki_display);
    break;
//    case CASE_07:
//        display_COM_PAR[CASE_07]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
//    break;

    }
    p_pow.p_par.mem.display_DONE_STATE=MASTER_COMMAND_get_par_done;
}
///////////////////////////////////////////////////////////////
void MASTER_GET_RUN_LINE_PAR(void)// parameters for scrolling screen
{
    switch(display_line_number+display_screen_number*LINE_PER_SCREEN)
    {
    case CASE_00:
        display_RUN_parameter[CASE_00]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_01:
        display_RUN_parameter[CASE_01]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_02:
        display_RUN_parameter[CASE_02]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_03:
        display_RUN_parameter[CASE_03]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;

    case CASE_04:
        display_RUN_parameter[CASE_04]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_05:
        display_RUN_parameter[CASE_05]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_06:
        display_RUN_parameter[CASE_06]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_07:
        display_RUN_parameter[CASE_07]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;

    case CASE_08:
        display_RUN_parameter[CASE_08]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_09:
        display_RUN_parameter[CASE_09]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_10:
        display_RUN_parameter[CASE_10]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_11:
        display_RUN_parameter[CASE_11]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;

    case CASE_12:
        display_RUN_parameter[CASE_12]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_13:
        display_RUN_parameter[CASE_13]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_14:
        display_RUN_parameter[CASE_14]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;
    case CASE_15:
        display_RUN_parameter[CASE_15]=_IQmpyI32int(p_pow.p_var.mem.COM_id,(int16)Ki_display);
    break;

    }
    p_pow.p_par.mem.display_DONE_STATE=MASTER_RUN_get_PAR_done;
}

////////////////////////////////////////////////////////////////////
//////// define these for line 1 ///////////////////////////////////
////////////////////////////////////////////////////////////////////
int16 digit_times_10000=0;
int16 digit_times_01000=0;
int16 digit_times_00100=0;
int16 digit_times_00010=0;

int16 digit_10000_th_place=0;
int16 digit_01000_th_place=0;
int16 digit_00100_th_place=0;
int16 digit_00010_th_place=0;
int16 digit_00001_th_place=0;
/////////////////////////////////////////////////////
//////////// CREATE ARRAY  //////////////////////////
int16 screen_one_LINE_CHAR[total_CHAR_in_RUN_LINE];
Uint16 LINE_column_number=0;
Uint16 char_string_no=0;
Uint16 fault_index=0;
Uint16 CALSTAT_PAGE_display_done=0;
Uint16 multiplier_absent=0;

Uint16 fault_index_MAX=number_of_faults-1;
Uint16 fault_pointer=0;
Uint16 digitize_done=0;
Uint16 flt_index_done=0;
void MASTER_CREATE_LINE_array(void)// for one line
{
    switch(index_ARRAY_main)
    {
    case CASE_00:
        index_ARRAY_main++;
    break;
    case CASE_01:
        char_string_no=display_line_number+display_screen_number*LINE_PER_SCREEN;// one string of 20 character
        index_ARRAY_main++;
    break;
    case CASE_02:
        if(display_screen_number>=NO_OF_RUN_SCREEN)index_ARRAY_main=CASE_array_FAULT_PUNCH;
        else
        {
            if(CALSTAT_PAGE_display_done==0)index_ARRAY_main=CASE_array_CALSTAT_PUNCH;
            else index_ARRAY_main=CASE_array_RUN_DIGIT_PUNCH;
        }
    break;

    case CASE_array_FAULT_PUNCH:
        switch(index_ARRAY_aux)
        {
        case CASE_00:
            MASTER_ASSIGN_FLT();// get FLT details
            if(flt_index_done==1)index_ARRAY_aux++;
        break;
        case CASE_01:
            screen_one_LINE_CHAR[LINE_column_number]=FAULT_ARRAY_30_LINES[fault_index][LINE_column_number];
            LINE_column_number++;
            if(LINE_column_number>=total_CHAR_full_LINE)
            {
                LINE_column_number=0;
                index_ARRAY_main=CASE_array_PUNCH_END;
            }
        break;
        }
    break;

    case CASE_array_CALSTAT_PUNCH:// get 20 CHAR of CALSTAT page
        screen_one_LINE_CHAR[LINE_column_number]=CALSTAT_SCREEN_4_LINES[char_string_no][LINE_column_number];// get the string
        LINE_column_number++;
        if(LINE_column_number>=total_CHAR_full_LINE)
        {
            LINE_column_number=0;
            if(char_string_no>=(LINE_PER_SCREEN-1))CALSTAT_PAGE_display_done=1;// CALSTAT_PAGE_display_skip=1 at the third line
            index_ARRAY_main=CASE_array_PUNCH_END;// CALSTAT_PAGE_display_skip=0 CASE
        }
    break;

    case CASE_array_RUN_DIGIT_PUNCH:// digitize NUMBER
        switch(index_ARRAY_aux)
        {
        case CASE_00:
            MASTER_EXTRACT_DIGITS(display_RUN_parameter[char_string_no]);// get digits of the number to be displayed
            if(digitize_done==1)index_ARRAY_aux++;
        break;
        case CASE_01:
            digitize_done=0;
            index_ARRAY_aux++;
        break;
        case CASE_02:
            screen_one_LINE_CHAR[LINE_column_number]=display_STRING_RUN_MODE[char_string_no][LINE_column_number];
            index_ARRAY_aux++;
        break;
        case CASE_03:// PUNCH PARAMETER
            if(LINE_column_number>=DIG_1st_position_in_LINE && LINE_column_number<(DIG_1st_position_in_LINE+DIG_numbers_in_LINE))screen_one_LINE_CHAR[LINE_column_number]=NUMBER_digits[LINE_column_number-DIG_1st_position_in_LINE];
            index_ARRAY_aux=0;
            LINE_column_number++;
            if(LINE_column_number>=total_CHAR_full_LINE)
            {
                LINE_column_number=0;
                index_ARRAY_main=CASE_array_PUNCH_END;
            }
        break;
        }
    break;
    case CASE_array_PUNCH_END:
        p_pow.p_par.mem.display_DONE_STATE=MASTER_line_array_done;
        index_ARRAY_main=CASE_00;
        index_ARRAY_aux=CASE_00;
    break;
    }
}
/////////////////////////////////////////////////////////////////
Uint16 index_NUMBER_main=0;
void MASTER_EXTRACT_DIGITS(int16 number_to_decimate)
{
    index_NUMBER_main++;
    switch(index_NUMBER_main)
    {
    case 1:
        // get the sign calculation first and assign to the first element in array for display
        //int16 number_to_decimateculation_number=tmp_j[(display_line_number-1)];
        NUMBER_digits[0]='-';
        if((number_to_decimate & 0x8000)==0)NUMBER_digits[0]=' ';// sign bit AND(1000-0000-0000-0000)
        // reverse the sign if negative
        if(number_to_decimate<0)number_to_decimate=-number_to_decimate;
        // get the digits as below
     break;
     case 2:
         if(multiplier_absent==0)
         {
             digit_times_10000=number_to_decimate/10000;
             digit_times_01000=number_to_decimate/1000;
             digit_times_00100=number_to_decimate/100;
             digit_times_00010=number_to_decimate/10;
         }
     break;
     case 3:
        if(multiplier_absent==1)
        {
            digit_times_10000=digit_times_01000;
            digit_times_01000=digit_times_00100;
            digit_times_00100=digit_times_00010;
            digit_times_00010=number_to_decimate;
        }
     break;
     case 4:
        digit_10000_th_place=digit_times_10000;
        digit_01000_th_place=digit_times_01000-digit_times_10000*10;
     break;
     case 5:
        digit_00100_th_place=digit_times_00100-digit_times_01000*10;
        digit_00010_th_place=digit_times_00010-digit_times_00100*10;
     break;
     case 6:
        digit_00001_th_place=number_to_decimate-digit_times_00010*10;
        if(multiplier_absent==1)digit_00001_th_place=0;
     break;
     case 7:
        NUMBER_digits[1]=digit_10000_th_place+off_ASCII;//0x0030 to offset for ASCII
        NUMBER_digits[2]=digit_01000_th_place+off_ASCII;
     break;
     case 8:
        NUMBER_digits[3]=digit_00100_th_place+off_ASCII;
        NUMBER_digits[4]=digit_00010_th_place+off_ASCII;
     break;
     case 9:
        NUMBER_digits[5]='.';// decimal point
        NUMBER_digits[6]=digit_00001_th_place+off_ASCII;
     break;
     case 10:

        // assign leading digits (either leading 1st digit or leading first two digits)
        //blank character if they are zero
        if(digit_times_10000==0)
        {
            NUMBER_digits[1]=NUMBER_digits[0]; //pass the sign bit to the subsequent but if the leading bit =0
            NUMBER_digits[0]=' ';
        }
     break;
     case 11:
        if((digit_times_10000==0)&&(digit_times_01000==0))
        {
            NUMBER_digits[2]=NUMBER_digits[1];
            NUMBER_digits[1]=' ';
        }
     break;
     case 12:
        if((digit_times_10000==0)&&(digit_times_01000==0)&&(digit_times_00100==0))
        {
            NUMBER_digits[3]=NUMBER_digits[2];
            NUMBER_digits[2]=' ';
        }
     break;
     case 13:
         digitize_done=1;
         index_NUMBER_main=0;
     break;
     default: break;
    }
}
Uint16 index_FLT_main=0;
void MASTER_ASSIGN_FLT(void)
{
    index_FLT_main++;
    fault_pointer=fault_index;
    switch(index_FLT_main)
    {
    case 1:
        if(display_line_number==0)fault_pointer=fault_index_MAX;// array of 30
    break;
    case 2:
        if((sys.sen_flag.bit.I_H_sen_fault==1)&&(fault_pointer>FLT_INDEX_01))fault_index=FLT_INDEX_01;
        if((sys.sen_flag.bit.I_H_sen_fault==1)&&(fault_pointer>FLT_INDEX_02))fault_index=FLT_INDEX_02;
        if((sys.sen_flag.bit.I_L_sen_fault==1)&&(fault_pointer>FLT_INDEX_03))fault_index=FLT_INDEX_03;
    break;
    case 3:
        if((sys.sen_flag.bit.I_L_sen_fault==1)&&(fault_pointer>FLT_INDEX_04))fault_index=FLT_INDEX_04;

        if((sys.pro_flag.bit.I_H_high==1)&&(fault_pointer>FLT_INDEX_05))fault_index=FLT_INDEX_05;
        if((sys.pro_flag.bit.I_L_high==1)&&(fault_pointer>FLT_INDEX_06))fault_index=FLT_INDEX_06;
    break;
    case 4:
        if((sys.pro_flag.bit.TEMP_1_high==1)&&(fault_pointer>FLT_INDEX_07))fault_index=FLT_INDEX_07;
        if((sys.pro_flag.bit.TEMP_2_high==1)&&(fault_pointer>FLT_INDEX_08))fault_index=FLT_INDEX_08;

        if((sys.pro_flag.bit.V_dc_high==1)&&(fault_pointer>FLT_INDEX_09))fault_index=FLT_INDEX_09;

    break;
    case 5:
        if((sys.pro_flag.bit.V_dc_high==1)&&(fault_pointer>FLT_INDEX_10))fault_index=FLT_INDEX_10;
        if((sys.pro_flag.bit.V_dc_high==1)&&(fault_pointer>FLT_INDEX_11))fault_index=FLT_INDEX_11;
        if((sys.pro_flag.bit.V_dc_high==1)&&(fault_pointer>FLT_INDEX_12))fault_index=FLT_INDEX_12;
    break;
    case 6:

    break;
    case 7:

    break;

    case 8:

    break;
    case 9:

    break;

    case 10:
        flt_index_done=1;
        index_FLT_main=0;
    break;
    default: break;
    }
}

Uint16 COM_column_number=0;
Uint16 index_COM_step=CASE_00;
void MASTER_COMMAND_create_ARRAY(void)
{
    switch(index_COM_step)
    {
    case CASE_00:
        multiplier_absent=0;
        MASTER_EXTRACT_DIGITS(display_COM_PAR[display_line_number+display_screen_number*LINE_PER_SCREEN]);
        if(digitize_done==1)
        {
            index_COM_step=CASE_01;
            digitize_done=0;
        }
    break;
    case CASE_01:
        screen_one_LINE_CHAR[COM_column_number]=command_PAR_char[display_line_number+display_screen_number*LINE_PER_SCREEN][COM_column_number];
        Call_PAR_COM_punch();
        index_COM_step=CASE_02;
    break;
    case CASE_02:
        COM_column_number++;
        if(COM_column_number>=total_CHAR_full_LINE)
        {
            p_pow.p_par.mem.display_DONE_STATE=MASTER_COMMAND_array_done;
            COM_column_number=display_column_01;
            index_COM_step=CASE_00;
        }
        else index_COM_step=CASE_01;
    break;
    }
}

void Call_PAR_COM_punch(void)
{
	if(COM_column_number>=DIG_1st_position_in_LINE && COM_column_number<(DIG_1st_position_in_LINE+DIG_numbers_in_LINE))screen_one_LINE_CHAR[COM_column_number]=NUMBER_digits[COM_column_number-DIG_1st_position_in_LINE];
}

////////////////////////////////////////////////////////////////////
Uint16 portion_SCREEN_LINE=0;
#define SCREEN_LINE_1st_half 0
#define SCREEN_LINE_2nd_half 1
#define DELAY_BET_two_batches 2
Uint16 counter_MASTER_send=0;
Uint16 SCI_int_CLEAR=0;
void MASTER_SEND_screen_clear(void)
{
    SciaRegs.SCITXBUF.all=send_clear_string[counter_MASTER_send];
    counter_MASTER_send++;
    if(counter_MASTER_send>=total_CHAR_half_LINE)
    {
        p_pow.p_par.mem.display_DONE_STATE=MASTER_screen_clear_done;
        counter_MASTER_send=0;
    }
    SCI_int_CLEAR=send_clear_string[counter_MASTER_send];
}
////////////////////////////////////////////////////////////////////
Uint16 counter_DELAY_BET_two_batches=0;
Uint16 SCI_int_RUN=0;
void MASTER_SEND_CHAR_ONE_LINE(void)// one CHAR and at a time: 20 CHAR one after the other
{
    switch(portion_SCREEN_LINE)
    {
    case SCREEN_LINE_1st_half:
        SciaRegs.SCITXBUF.all=screen_one_LINE_CHAR[counter_MASTER_send];
        counter_MASTER_send++;
        if(counter_MASTER_send>=total_CHAR_half_LINE)portion_SCREEN_LINE=DELAY_BET_two_batches;
    break;

    case DELAY_BET_two_batches:
        counter_DELAY_BET_two_batches++;
        if(counter_DELAY_BET_two_batches>=count_DELAY_BET_two_batches)
        {
            counter_DELAY_BET_two_batches=0;
            portion_SCREEN_LINE=SCREEN_LINE_2nd_half;
        }
    break;

    case SCREEN_LINE_2nd_half:
        SciaRegs.SCITXBUF.all=screen_one_LINE_CHAR[counter_MASTER_send];
        counter_MASTER_send++;
        if(counter_MASTER_send>=total_CHAR_full_LINE)
        {
            p_pow.p_par.mem.display_DONE_STATE=MASTER_send_line_done;
            portion_SCREEN_LINE=SCREEN_LINE_1st_half;
            counter_MASTER_send=0;
        }
    break;
    }
    SCI_int_RUN=screen_one_LINE_CHAR[counter_MASTER_send];
}
////////////////////////////////////////////////////////////////////
void MASTER_DELAY_between_LINES(void)
{
    counter_DELAY_BET_two_batches++;
    if(counter_DELAY_BET_two_batches>=count_DELAY_BET_two_batches)
    {
        counter_DELAY_BET_two_batches=0;
        p_pow.p_par.mem.display_DONE_STATE=MASTER_delay_between_lines_done;
    }
}
Uint16 counter_DELAY_BET_screens=0;
void MASTER_DELAY_between_SCREENS(void)
{
    counter_DELAY_BET_screens++;
    if(counter_DELAY_BET_screens>=count_DELAY_BET_screens)
    {
        counter_DELAY_BET_screens=0;
        p_pow.p_par.mem.display_DONE_STATE=MASTER_delay_between_screens_done;
    }
}
////////////////////////////////////////////////////////////////////
