//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_04_master.h>
#include <00_f28002x_KEY_PAD.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_PROTECTION.h>
#include <00_f28002x_STATE_MACHINE.h>
#include "01_f28002x_device.h"
#include <IQmathLib.h>
///////////////////////////////////////////////////////////////////////////////////
Uint16 MCP23S17_MODE_COMMAND[NUMBER_OF_SCREEN_PAR]={0,0};
Uint16 *GET_DIS_line_screen_NO=0;
void INIT_DISPLAY_PAR(void)
{
    MCP23S17_MODE_COMMAND[0]=NUMBER_OF_MODES;
    MCP23S17_MODE_COMMAND[1]=NUMBER_OF_COMMANDS;

    p_pow.p_par.mem.CONV_1st_MODE=MODE_1_01_COM_PH_LV_to_HV;
    p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_04_duty_BLD_LV;
    p_pow.p_par.mem.CONV_3rd_MODE=0;
    p_pow.p_par.mem.CONV_4th_MODE=0;
    p_pow.p_par.mem.SCREEN_MODE=screen_SCROLL;
    p_pow.p_par.mem.display_DONE_STATE=0;
    p_pow.p_par.mem.PAR_UP_DOWN=0;

    p_pow.p_var.mem.COMMAND_01=0;
    p_pow.p_var.mem.COMMAND_02=0;
    p_pow.p_var.mem.COMMAND_03=0;
    p_pow.p_var.mem.COMMAND_04=0;
}
////////////////////////////////////////////////////////////////////////////////////
Uint16 *NUMBER_MODE_COMMAND(void)
{
    return MCP23S17_MODE_COMMAND;
}

////////////////////////////////////////////////////////////////////////////////////
/////////////////// SET PARAMETERS /////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
Uint16 MODE_ID=0;

void ALTER_MODE_PARAMETER(void)
{
    GET_DIS_line_screen_NO=DISPLAY_line_and_screen_number();

    if(p_pow.p_par.mem.MODE_STATE==STATE_READY)
	{
        MODE_ID=GET_DIS_line_screen_NO[0]+GET_DIS_line_screen_NO[1]*LINE_PER_SCREEN;

        switch(MODE_ID)
		{
			case display_LINE_01: MODE_LINE_01();

            break;

			case display_LINE_03: MODE_LINE_03();

            break;

			case display_LINE_05: MODE_LINE_05();
			break;

			case display_LINE_07: MODE_LINE_07();
            break;

            case display_LINE_09: MODE_LINE_09();
            break;

            case display_LINE_11: MODE_LINE_11();
            break;

			default:break;
		}
	}

	p_pow.p_par.mem.PAR_UP_DOWN=PAR_UP_DOWN_0;
}
////////////////////////////////////////////////////////////////////////////////////
/////////////////// COMMAND PARAMETERS /////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
Uint16 COMMAND_ID=0;
void ALTER_COMMAND_PARAMETER(void)
{
    GET_DIS_line_screen_NO=DISPLAY_line_and_screen_number();

    if((p_pow.p_par.mem.MODE_STATE==STATE_READY)||(p_pow.p_par.mem.MODE_STATE==STATE_RUN))
	{
	    COMMAND_ID=GET_DIS_line_screen_NO[0]+GET_DIS_line_screen_NO[1]*LINE_PER_SCREEN;

	    switch(COMMAND_ID)
		{
		case display_LINE_01: COMMAND_LINE_01();
        break;

		case display_LINE_02: COMMAND_LINE_02();
		break;

		case display_LINE_03: COMMAND_LINE_03();
		break;

		case display_LINE_04: COMMAND_LINE_04();
		break;

        case display_LINE_05: COMMAND_LINE_05();
        break;

		case display_LINE_06: COMMAND_LINE_06();
        break;

		case display_LINE_07: COMMAND_LINE_07();
		break;

        case display_LINE_08: COMMAND_LINE_08();
        break;

        case display_LINE_09: COMMAND_LINE_09();
        break;

        case display_LINE_10: COMMAND_LINE_10();
        break;

        case display_LINE_11: COMMAND_LINE_11();
        break;

        case display_LINE_12: COMMAND_LINE_12();
        break;

        case display_LINE_13: COMMAND_LINE_13();
        break;

        case display_LINE_14: COMMAND_LINE_14();
        break;

        case display_LINE_15: COMMAND_LINE_15();
        break;

        case display_LINE_16: COMMAND_LINE_16();
        break;

        case display_LINE_17: COMMAND_LINE_17();
        break;

        case display_LINE_18: COMMAND_LINE_18();
        break;

        case display_LINE_19: COMMAND_LINE_19();
        break;

        case display_LINE_20: COMMAND_LINE_20();
        break;

		default:
		break;
		}
	}

	p_pow.p_par.mem.PAR_UP_DOWN=PAR_UP_DOWN_0;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////// MODE LINES ///////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void MODE_LINE_01(void)
{
    switch(p_pow.p_par.mem.CONV_1st_MODE)
    {
    case MODE_1_01_COM_PH_LV_to_HV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_01_COM_PH_LV_to_HV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_02_COM_PH_HV_to_LV;
    break;

    case MODE_1_02_COM_PH_HV_to_LV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_01_COM_PH_LV_to_HV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_03_COM_CUR_LV_to_HV;
    break;

    case MODE_1_03_COM_CUR_LV_to_HV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_02_COM_PH_HV_to_LV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_04_COM_CUR_HV_to_LV;
    break;

    case MODE_1_04_COM_CUR_HV_to_LV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_03_COM_CUR_LV_to_HV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_05_COM_CC_CV;
    break;

    case MODE_1_05_COM_CC_CV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_04_COM_CUR_HV_to_LV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_06_COM_BUILD_LV;
    break;

    case MODE_1_06_COM_BUILD_LV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_05_COM_CC_CV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_07_COM_BUILD_HV;
    break;

    case MODE_1_07_COM_BUILD_HV:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_06_COM_BUILD_LV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_08_EXTERNAL_PWM;
    break;

    case MODE_1_08_EXTERNAL_PWM:
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_07_COM_BUILD_HV;
        if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_1st_MODE=MODE_1_08_EXTERNAL_PWM;
    break;

    default:break;
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void MODE_LINE_03(void)
{
    switch(p_pow.p_par.mem.CONV_2nd_MODE)
    {
        case MODE_2_01_duty_VOL_DEPT:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_01_duty_VOL_DEPT;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_02_duty_COMMAND;
        break;
        case MODE_2_02_duty_COMMAND:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_01_duty_VOL_DEPT;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_03_duty_FIXED;
        break;

        case MODE_2_03_duty_FIXED:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_02_duty_COMMAND;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_04_duty_BLD_LV;
        break;

        case MODE_2_04_duty_BLD_LV:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_03_duty_FIXED;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_05_duty_BLD_HV;
        break;

        case MODE_2_05_duty_BLD_HV:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_04_duty_BLD_LV;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_05_duty_BLD_HV;
        break;

        case MODE_2_06_duty_MIN:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_06_duty_MIN;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_06_duty_MIN;
        break;

        default:break;
    }
//    if((p_pow.p_par.mem.CONV_1st_MODE==MODE_1_05_COM_BUILD_LV)||(p_pow.p_par.mem.CONV_1st_MODE==MODE_1_06_COM_BUILD_HV))p_pow.p_par.mem.CONV_2nd_MODE=MODE_2_01_duty_VOL_DEPT;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void MODE_LINE_05(void)
{
    switch(p_pow.p_par.mem.CONV_3rd_MODE)
    {
        case MODE_3_01_BLD_CUR_MODE:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_3rd_MODE=MODE_3_01_BLD_CUR_MODE;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_3rd_MODE=MODE_3_02_BLD_VOL_MODE;
        break;
        case MODE_3_02_BLD_VOL_MODE:
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_par.mem.CONV_3rd_MODE=MODE_3_01_BLD_CUR_MODE;
            if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_par.mem.CONV_3rd_MODE=MODE_3_02_BLD_VOL_MODE;
        break;

        default:break;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void MODE_LINE_07(void)
{

}

void MODE_LINE_09(void)
{

}

void MODE_LINE_11(void)
{

}
////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////// COMMAND LINES /////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_01(void)
{
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_var.mem.COMMAND_01+=_IQ(0.02001);
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_var.mem.COMMAND_01-=_IQ(0.02001);
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_02(void)
{
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_var.mem.COMMAND_02+=_IQ(0.01001);
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_var.mem.COMMAND_02-=_IQ(0.01001);
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_03(void)
{
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_var.mem.COMMAND_03+=_IQ(0.01001);
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_var.mem.COMMAND_03-=_IQ(0.01001);
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_04(void)
{
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_UP)p_pow.p_var.mem.COMMAND_04+=_IQ(0.01001);
    if(p_pow.p_par.mem.PAR_UP_DOWN==PAR_DOWN)p_pow.p_var.mem.COMMAND_04-=_IQ(0.01001);
}
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_05(void)
{

}
/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_06(void)
{

}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_07(void)
{

}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void COMMAND_LINE_08(void)
{

}
//////////////////////////////////////////////////////////////////////////////////////////////////////

void COMMAND_LINE_09(void)
{

}


void COMMAND_LINE_10(void)
{

}

void COMMAND_LINE_11(void)
{

}

void COMMAND_LINE_12(void)
{

}

void COMMAND_LINE_13(void)
{

}

void COMMAND_LINE_14(void)
{

}

void COMMAND_LINE_15(void)
{

}



void COMMAND_LINE_16(void)
{

}

void COMMAND_LINE_17(void)
{

}

void COMMAND_LINE_18(void)
{

}

void COMMAND_LINE_19(void)
{

}

void COMMAND_LINE_20(void)
{

}

void RESET_COMMAND_DUTY(void)
{

}


///////////////////////////////////////////////////////////////////////////////////////
