///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_11_slave.h>
#include <00_f28002x_KEY_PAD.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_STATE_MACHINE.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"
#include <00_f28002x_PARAMETER.h>
////////////////////////////////////////////////////////////////////////////////
#define slave_string_START_CHAR '$'
#define slave_string_END_CHAR '#'
#define slave_string_CLEAR_MODE 'b'
#define slave_string_RUN_MODE 'a'
Uint16 CLEAR_array[15];
Uint16 RUN_LINE_01_array[15];
Uint16 index_SCI_RX=0;
Uint16 counter_SCI_RX_01=0;
Uint16 counter_SCI_RX_analyse=0;
Uint16 counter_SCI_RX_clear=0;
Uint16 display_ARRAY_20_CHAR[number_CHAR_in_display_LINE];
Uint16 SCIA_CHAR_received=0;

interrupt void SCIA_INTERRUPT(void)
{
    SCIA_CHAR_received=1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;
}
/////////////////////////////////////////////////////////////////////////////////
Uint16 slave_display_done=0;
Uint16 slave_display_STATE=SLAVE_SCREEN_INIT_STATE;
Uint16 SCREEN_line_number=0;
Uint16 index_LINE_CHAR=0;

void SLAVE_DISPLAY_RUN(void)
{
    switch(slave_display_STATE)
    {
    case SLAVE_SCREEN_INIT_STATE:
        SLAVE_DISPLAY_INIT_CONFIG();
        if(slave_display_done==slave_screen_init_done)slave_display_STATE=SLAVE_SCREEN_WAIT_STATE;
    case SLAVE_SCREEN_WAIT_STATE:
        if(SCIA_CHAR_received==1)
        {
            SCIA_CHAR_received=0;
            for(index_SCI_RX=0;index_SCI_RX<number_SCIA_BUFFER;index_SCI_RX++)RUN_LINE_01_array[index_SCI_RX]=SciaRegs.SCIRXBUF.all;
            counter_SCI_RX_01++;
            SciaRegs.SCIFFRX.bit.RXFIFORESET=0; //Write 0 to reset the FIFO pointer to zero, and hold in reset
            SciaRegs.SCIFFRX.bit.RXFIFORESET=1; //Re-enable receive FIFO operation

            slave_display_STATE=SLAVE_SCREEN_ANALYSE_STATE;
        }
    break;
    case SLAVE_SCREEN_ANALYSE_STATE:
        if((RUN_LINE_01_array[0]==slave_string_START_CHAR)&&(RUN_LINE_01_array[14]==slave_string_END_CHAR))
        {
            if(RUN_LINE_01_array[1]==slave_string_CLEAR_MODE)slave_display_STATE=SLAVE_SCREEN_FLY_CLEAR_STATE;
            if(RUN_LINE_01_array[1]==slave_string_RUN_MODE)slave_display_STATE=SLAVE_CREATE_LINE_01_STATE;
            counter_SCI_RX_analyse++;
        }
    break;
    case SLAVE_SCREEN_FLY_CLEAR_STATE:
        SLAVE_SCREEN_CLEAR();
        if(slave_display_done==slave_screen_clear_done)
        {
            slave_display_done=slave_screen_done_reset;
            slave_display_STATE=SLAVE_SCREEN_WAIT_STATE;
        }
    break;
    case SLAVE_SCREEN_SCROLL_CLEAR_STATE:
        SLAVE_SCREEN_CLEAR();
        if(slave_display_done==slave_screen_clear_done)
        {
            slave_display_done=slave_screen_done_reset;
            slave_display_STATE=SLAVE_SEND_FULL_LINE_STATE;
        }
    break;

    case SLAVE_SCREEN_ADDRESS_STATE:
        SLAVE_LINE_ADDRESS();
        if(slave_display_STATE==slave_screen_address_done)
        {
            slave_display_done=slave_screen_done_reset;
            if(RUN_LINE_01_array[2]==CHAR_1)slave_display_STATE=SLAVE_SCREEN_SCROLL_CLEAR_STATE;
            else slave_display_STATE=SLAVE_SEND_FULL_LINE_STATE;
        }
    break;
    case SLAVE_CREATE_LINE_01_STATE:
        if((RUN_LINE_01_array[2]==CHAR_0)||(RUN_LINE_01_array[2]==CHAR_2)||(RUN_LINE_01_array[2]==CHAR_4)||(RUN_LINE_01_array[2]==CHAR_6))
        {
            for(index_LINE_CHAR=0;index_LINE_CHAR<number_CHAR_in_SCI_batch;index_LINE_CHAR++)display_ARRAY_20_CHAR[index_LINE_CHAR]=RUN_LINE_01_array[index_LINE_CHAR+4];
            slave_display_STATE=SLAVE_SCREEN_WAIT_STATE;
        }
        else slave_display_STATE=SLAVE_CREATE_LINE_02_STATE;
    break;
    case SLAVE_CREATE_LINE_02_STATE:
        for(index_LINE_CHAR=0;index_LINE_CHAR<number_CHAR_in_SCI_batch;index_LINE_CHAR++)display_ARRAY_20_CHAR[index_LINE_CHAR+number_CHAR_in_SCI_batch]=RUN_LINE_01_array[index_LINE_CHAR+4];
        if(RUN_LINE_01_array[2]==CHAR_1)SCREEN_line_number=0;
        if(RUN_LINE_01_array[2]==CHAR_3)SCREEN_line_number=1;
        if(RUN_LINE_01_array[2]==CHAR_5)SCREEN_line_number=2;
        if(RUN_LINE_01_array[2]==CHAR_7)SCREEN_line_number=3;
        slave_display_STATE=SLAVE_SCREEN_ADDRESS_STATE;
    break;
    case SLAVE_SEND_FULL_LINE_STATE:
        SLAVE_SEND_LINE_CHAR();
        if(slave_display_STATE==slave_screen_line_done)slave_display_STATE=SLAVE_SCREEN_WAIT_STATE;
    break;


    }
}
/////////////////////////////////////////////////////////////////////////////////
void SLAVE_DISPLAY_INIT(void)
{
#if(BLDC_BOARD==0)
            //set up SPI so that no delay between two successive 16 bit transmission
            //thats the way MCP23S17 works, SPI is set at SPI.h as one delay between
            //two 16 bit transmission, the following line will override that
            SpiaRegs.SPIFFCT.bit.TXDLY=0;// for MCP23S17 conf. delay between two 16 bit SPI should be 0
            //configure MCP ports A and B as required
            // for display cmplete A port and B0,B1,B2 from B are used
            // Port A0-A7->DB0-DB7, and RS-B0,R/W-B1, E-B2
            SpiaRegs.SPITXBUF=EXPANDER_IODIRA;//48h(bits: 0100-1XX0)-00h for IODIRA as register 13/05/2013
            SpiaRegs.SPITXBUF=EXPANDER_PORT_AB;//0000-0000 (portA o/p), 0001-0000 (bit4 IODIRB i/p, others o/p)
            //the other 5 bits (B3-B7) can be used for other purpose.
#endif
#if(BLDC_BOARD==3)
            SpibRegs.SPIFFCT.bit.TXDLY=0;
            SpibRegs.SPITXBUF=EXPANDER_IODIRA;
            SpibRegs.SPITXBUF=EXPANDER_PORT_AB;
#endif

}
//////////////////////////////////////////////////////////////////////////
Uint16 slave_index_MAIN=0;
Uint16 display_char_digit=0;
void SLAVE_DISPLAY_INIT_CONFIG(void)
{
    slave_index_MAIN++;
    switch(slave_index_MAIN)
    {
        case SW_CASE_01:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_02:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_03:display_char_digit=display_reset+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_04:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_05:display_char_digit=display_reset+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;

        case SW_CASE_06:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_07:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_08:display_char_digit=display_reset+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_09:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_10:display_char_digit=display_reset+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;

        case SW_CASE_11:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_12:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_13:display_char_digit=display_reset+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_14:display_char_digit=display_reset+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_15:display_char_digit=display_reset+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;

        case SW_CASE_16:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_17:display_char_digit=double_line+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_18:display_char_digit=double_line+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_19:display_char_digit=double_line+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_20:display_char_digit=double_line+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;

        case SW_CASE_21:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_22:display_char_digit=display_ON+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_23:display_char_digit=display_ON+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_24:display_char_digit=display_ON+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_25:display_char_digit=display_ON+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;

        case SW_CASE_26:display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_27:display_char_digit=auto_increment+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_28:display_char_digit=auto_increment+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_29:display_char_digit=auto_increment+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_30:display_char_digit=auto_increment+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_31:slave_index_MAIN=0;slave_display_done=slave_screen_init_done;break;
        default:break;
    }
//    counter_SCI_RX_clear++;
}

///////////////////////////////////////////////////////
//////////// DISPLAY SCREEN CLEAR /////////////////////
///////////////////////////////////////////////////////
void SLAVE_SCREEN_CLEAR(void)
{
    slave_index_MAIN++;
    switch(slave_index_MAIN)
    {
        case SW_CASE_01:
        display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_02:
        display_char_digit=clear_display+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_03:
        display_char_digit=clear_display+E_1_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_04:
        display_char_digit=clear_display+E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_05:
        display_char_digit=clear_display+E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_06:slave_index_MAIN=0;slave_display_done=slave_screen_clear_done;break;
        default:break;
    }
    counter_SCI_RX_clear++;
}

////////////////////////////////////////////////////////////////////
////////////// Display starting address for LINE 1 /////////////////
////////////////////////////////////////////////////////////////////

Uint16 line_add_offset=0;
void SLAVE_LINE_ADDRESS(void)
{
    slave_index_MAIN++;
    switch(slave_index_MAIN)
    {
        case SW_CASE_01:
//            CURSOR_line_and_screen_number=DISPLAY_line_and_screen_number();
//            SCREEN_line_number=CURSOR_line_and_screen_number[0];//1st element is line number

        break;

        case SW_CASE_02:
            switch(SCREEN_line_number)
            {
            case 0:
                line_add_offset=add_off_line_0;
            break;
            case 1:
                line_add_offset=add_off_line_1;
            break;
            case 2:
                line_add_offset=add_off_line_2;
            break;
            case 3:
                line_add_offset=add_off_line_3;
            break;
            }
        break;
        case SW_CASE_03:
            display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_04:
            display_char_digit=E_0_RW_0_RS_0;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_05:
            display_char_digit=E_1_RW_0_RS_0+display_add_0+line_add_offset;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_06:
            display_char_digit=E_0_RW_0_RS_0+display_add_0+line_add_offset;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_07:
            display_char_digit=E_0_RW_1_RS_1;DISPLAY_SPI_LOAD(display_char_digit);break;
        case SW_CASE_08:slave_index_MAIN=0;slave_display_STATE=slave_screen_address_done;break;
        default: break;
    }
}
////////////////////////////////////////////////////////////////
///////////// DISPLAY ROUTINE //////////////////////////////////
Uint16 CHAR_position_in_LINE=0;
Uint16 CHAR_variable=0;
void SLAVE_SEND_LINE_CHAR(void)// one CHAR and at a time: 20 CHAR one after the other
{
    slave_index_MAIN++;
    switch(slave_index_MAIN)
    {

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//  case 0: reset states: E_0_RW_1_RS_0=0x0002
//  case 1: make transitions: E_0_RW_0_RS_1 to RW=0 and RS=1
//  case 2: make transition: E_1_RW_0_RS_1: E=1 and release data as well
//  case 3: make transition: E_0_RW_0_RS_1: E=0 and keep the data as well
//  case 4: make transition: E_0_RW_1_RS_0: RW=1, RS=0
        case SW_CASE_01:
        //shift 8 bit right to get it to Port A
        ////data enable RS=1(B0), needed as per JHD162A for data loading (not instruction)
        //  new_tmp1_MCP23S17=(int16)((tmp_16_digit[new_tmp1_counter]<<8)&(0xFF00))+data_enable;
        CHAR_variable=E_0_RW_1_RS_0;DISPLAY_SPI_LOAD(CHAR_variable);break;
        case SW_CASE_02:
        CHAR_variable=E_0_RW_0_RS_1;DISPLAY_SPI_LOAD(CHAR_variable);break;
        case SW_CASE_03:
        CHAR_variable=E_1_RW_0_RS_1+((display_ARRAY_20_CHAR[CHAR_position_in_LINE]<<8)&(0xFF00));DISPLAY_SPI_LOAD(CHAR_variable);break;
        case SW_CASE_04:
        CHAR_variable=E_0_RW_0_RS_1+((display_ARRAY_20_CHAR[CHAR_position_in_LINE]<<8)&(0xFF00));DISPLAY_SPI_LOAD(CHAR_variable);break;
        case SW_CASE_05:
        CHAR_variable=E_0_RW_1_RS_0;DISPLAY_SPI_LOAD(CHAR_variable);slave_index_MAIN=0;CHAR_position_in_LINE++;break;// tmp1_counter represents one CHARACTER
    }

//        GpioDataRegs.GPBSET.bit.GPIO34=1;
        if(CHAR_position_in_LINE>=number_CHAR_in_display_LINE)
        {
            slave_display_STATE=slave_screen_line_done;
            CHAR_position_in_LINE=0;// upto 20 CHAR for one line
        }

//      GpioDataRegs.GPBCLEAR.bit.GPIO34=1;
}


////////////////////////////////////////////////////////////////////
////////////// MCP23S17 bit sets ///////////////////////////////////
///////////////////////////////////////////////////////////////////
void DISPLAY_SPI_LOAD(Uint16 input_char_digit)
{
#if(BLDC_BOARD==0)
    SpiaRegs.SPITXBUF=EXPANDER_GPIOA;
    SpiaRegs.SPITXBUF=input_char_digit;
#endif
#if(BLDC_BOARD==3)
    SpibRegs.SPITXBUF=EXPANDER_GPIOA;
    SpibRegs.SPITXBUF=input_char_digit;
#endif
}








/////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
void RESET_SLAVE_DISPAY_PAR(void)
{

}

///////////////////////////////////////////////////////////////////////////////
