//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
#ifndef __00_f28002x_SLAVE_DISPLAY_H__
#define __00_f28002x_SLAVE_DISPLAY_H__
//#include <IQmathLib.h>
#include <00_f28002x_PARAMETER.h>
#include "01_f28002x_device.h"
#include "01_f28002x_examples.h"
//////////////////////////////////////////////////////////////
#define MCP23S17_IODIRA 0x00
#define MCP23S17_IODIRB 0x01
#define MCP23S17_IPOLA  0x02
#define MCP23S17_IPOLB  0x03
#define MCP23S17_GPINTENA   0x04
#define MCP23S17_GPINTENB   0x05
#define MCP23S17_DEFVALA    0x06
#define MCP23S17_DEFVALB    0x07
#define MCP23S17_INTCONA    0x08
#define MCP23S17_INTCONB    0x09
#define MCP23S17_IOCON  0x0A
#define MCP23S17_GPPUA  0x0C
#define MCP23S17_GPPUB  0x0D
#define MCP23S17_INTFA  0x0E
#define MCP23S17_INTFB  0x0F
#define MCP23S17_INTCAPA    0x10
#define MCP23S17_INTCAPB    0x11
#define MCP23S17_GPIOA  0x12
#define MCP23S17_GPIOB  0x13
#define MCP23S17_OLATA  0x14
#define MCP23S17_OLATB  0x15
//JHD126A DB0-DB7 = MCP23S17 A0-A7, RS=B0,R/W=B1,E=B2
//default instruction code 0x-8bits-04, port B= 04:RS=0(B0),R/W=0(B1),E=1(B2)
//default data code 0x-8bits-02, port B= RS=0(B0),R/W=1(B1),E=0(B2)
//byte stands for instruction or data, for data write

// MCP23S17 hardware address 000 - look at MCP23S17 datashet, bit stream : 0100-0000-(0000-0000)
// most sig 4 bit 0100 (MCP23S17),next 4 bits A2(=0)A1(=0)A0(=0)R/W(=0)
// this results 40
#define MCP23S17_address 0x4000         //A2=0,A1=0,A0=0 -> second nibble=0100, 1st nibble=0100(4)
#define double_line 0x3800//assuming RS=0(B0),R/W=0(B1),E=0(B2), they will be adjusted separately,double line, 8 bit data
#define display_ON  0x0C00 // 1-display bit-cursor bit-blinking bit
//#define   display_ON  0x0F00
#define auto_increment  0x0600
#define clear_display   0x0100
#define address_offset  0x8000 //DB7=1 needs for address load
#define display_reset   0x3000

#define EXPANDER_PORT_AB 0x0000;//all port A,B bits as output(0000-0000-0000-0000)
#define EXPANDER_IODIRA MCP23S17_address+MCP23S17_IODIRA//0x4800
#define EXPANDER_GPIOA  MCP23S17_address+MCP23S17_GPIOA//0x4812
///////////////////////////////////////////////////////////////////
#define instruction 0x0000//RS=0(B0),R/W=0,E=0
#define data_enable 0x0001//RS=1(B0),R/W,E=0
#define data_disable 0x0000
#define write_enable    0x0002//RS=0,R/W=1(B1),E=0
#define display_enable  0x0004//RS=0(B0),R/W=0,E=1(B2)
#define RW_down 0x0000
#define E_up 0x0004
#define E_down 0x0000
#define RW_up 0x0002
///////////////////////////////////////////////////////////////////
//// E=1, RW=0, RS=1 for data
#define E_0_RW_1_RS_0 0x0002
#define E_0_RW_0_RS_1 0x0001
#define E_1_RW_0_RS_1 0x0005
//// E=1, RW=0, RS=0 for address
#define E_0_RW_1_RS_1 0x0003
#define E_0_RW_0_RS_0 0x0000
#define E_1_RW_0_RS_0 0x0004

////////////////////////////////////////////////////////////////////
#define off_ASCII 0x0030
#define display_add_0 address_offset //1nd place in 1st line (1000-0000:DB7-DB0)-(RS(B0)-0,R/W(B1)-0),1000-0000-XXXX-XX00
#define add_off_line_0 0
#define add_off_line_1 0x4000
#define add_off_line_2 0x1400
#define add_off_line_3 0x5400
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
interrupt void SCIA_INTERRUPT(void);
void SLAVE_DISPLAY_RUN(void);
void DISPLAY_SPI_LOAD(Uint16);
void SLAVE_DISPLAY_INIT(void);
void SLAVE_DISPLAY_INIT_CONFIG(void);

void SLAVE_SCREEN_CLEAR(void);
void SLAVE_LINE_ADDRESS(void);
void SLAVE_SEND_LINE_CHAR(void);
void SLAVE_SCREEN_LINE_03(void);
void SLAVE_SCREEN_LINE_04(void);
void SLAVE_INIT_DISPLAY_PAR(void);
///////////////////////////////////////////////////////////
#define CHAR_0 '0'
#define CHAR_1 '1'
#define CHAR_2 '2'
#define CHAR_3 '3'
#define CHAR_4 '4'
#define CHAR_5 '5'
#define CHAR_6 '6'
#define CHAR_7 '7'
///////////////////////////////////////////////////////////
///// Display side parameters ////////////////////////////

#define SLAVE_SCREEN_INIT_STATE 1
#define SLAVE_SCREEN_WAIT_STATE 2
#define SLAVE_SCREEN_ANALYSE_STATE 3
#define SLAVE_SCREEN_FLY_CLEAR_STATE 4
#define SLAVE_SCREEN_SCROLL_CLEAR_STATE 5
#define SLAVE_SCREEN_ADDRESS_STATE 6
#define SLAVE_CREATE_LINE_01_STATE 7
#define SLAVE_CREATE_LINE_02_STATE 8
#define SLAVE_SEND_FULL_LINE_STATE 9
#define number_SCIA_BUFFER 15
#define number_CHAR_in_display_LINE 20
#define number_CHAR_in_SCI_batch 10
////////////////////////////////////////////////////////////
#define slave_screen_done_reset 0
#define slave_screen_init_done 1
#define slave_screen_clear_done 2
#define slave_screen_address_done 3
#define slave_screen_line_done 3

////////////////////////////////////////////////////////////
#define SW_CASE_00 0
#define SW_CASE_01 1
#define SW_CASE_02 2
#define SW_CASE_03 3
#define SW_CASE_04 4

#define SW_CASE_05 5
#define SW_CASE_06 6
#define SW_CASE_07 7
#define SW_CASE_08 8
#define SW_CASE_09 9

#define SW_CASE_10 10
#define SW_CASE_11 11
#define SW_CASE_12 12
#define SW_CASE_13 13
#define SW_CASE_14 14

#define SW_CASE_15 15
#define SW_CASE_16 16
#define SW_CASE_17 17
#define SW_CASE_18 18
#define SW_CASE_19 19

#define SW_CASE_20 20
#define SW_CASE_21 21
#define SW_CASE_22 22
#define SW_CASE_23 23
#define SW_CASE_24 24

#define SW_CASE_25 25
#define SW_CASE_26 26
#define SW_CASE_27 27
#define SW_CASE_28 28
#define SW_CASE_29 29

#define SW_CASE_30 30
#define SW_CASE_31 31
#define SW_CASE_32 32
#define SW_CASE_33 33
#define SW_CASE_34 34


#endif
