/* =================================================================================
File name:       IPARK.H   (IQ version)
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description:
Header file containing constants, data type, and macro definitions for the IPARK.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 10-15-2009	Version 1.0
------------------------------------------------------------------------------*/
#ifndef __00_f28002x_INV_PARK_H__
#define __00_f28002x_INV_PARK_H__

typedef struct {  _iq  alpha;  		// Output: stationary d-axis stator variable
				  _iq  beta;		// Output: stationary q-axis stator variable
				  _iq  f_d;			// Input: rotating d-axis stator variable
				  _iq  f_q;			// Input: rotating q-axis stator variable
				  _iq  SIN;
				  _iq  COS;
		 	 	} TRF_INV_PARK;


/*-----------------------------------------------------------------------------
Default initalizer for the IPARK object.
-----------------------------------------------------------------------------*/
#define TRF_INV_PARK_DEFAULTS {  0, \
                          0, \
                          0, \
                          0, \
                          0, \
						  0, \
              			  }

/*------------------------------------------------------------------------------
	Inverse PARK Transformation Macro Definition
------------------------------------------------------------------------------*/


#define TRF_INV_PARK_MACRO(v)										\
																\
v.alpha = _IQmpy(v.f_d,v.COS) - _IQmpy(v.f_q,v.SIN);			\
v.beta = _IQmpy(v.f_q,v.COS) + _IQmpy(v.f_d,v.SIN);

#endif // __IPARK_H__

