////////////////////////////////////////////////////////////////
// Include header files used in the main function
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_ISR_TASK.h>
#include <00_f28002x_PARAMETER.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"
#include <math.h>
#include "02_f28002x_global_functions.h"
#include "01_f28002x_examples.h"
#include <00_f28002x_STATE_MACHINE.h>
#include <00_f28002x_DEFINE_GPIO.h>
#include <00_f28002x_DIS_11_slave.h>
/////////////////////////////////////////////////////////////////
volatile struct SYSTEM_REG sys;
volatile struct POWER_REG p_pow;
Uint16 counter_ADC=0;
Uint16 counter_PWM=0;
Uint16 counter_DELAY=0;
void main(void)
{
    InitSysCtrl();

    SETUP_GPIO();

    DINT;
    InitPieCtrl();
    IER = 0x0000;
    IFR = 0x0000;

    InitPieVectTable();
//    InitCpuTimers();

    EINT;
    ERTM;

	INIT_ALL();


// INTERRUPT ADC FOR CONVERSION

//    EPwm1Regs.ETSEL.bit.INTEN = 1;   // Enable EPWM1INT generation              PWM1
//    EPwm1Regs.ETSEL.bit.INTSEL = 1;  // Enable interrupt CNT_PRD               PWM1
//    EPwm1Regs.ETPS.bit.INTPRD = 1;   // Generate interrupt on the 1st event     PWM1
//    EPwm1Regs.ETCLR.bit.INT = 1;     // Enable more interrupts                  PWM1

// idea is to keep f_sw=20KHz, so (a) ISR_KHz=20KHz and f_sw_in_one_ISR=1 or (b) ISR_KHz=10KHz and f_sw_in_one_ISR=2 and so on

    EPwm1Regs.ETSEL.bit.SOCAEN = 1;     // Enable SOC on A group
    EPwm1Regs.ETSEL.bit.SOCASEL = 1;    // Select SOC on CTR=0
    EPwm1Regs.ETPS.bit.SOCPSSEL = 1;    // select ETSOCPS for 0-15 events, page 1767, spruin7a
    EPwm1Regs.ETSOCPS.bit.SOCAPRD2 = f_sw_in_one_ISR; // SOCA every PWM TINER_0 event to trigger ADC
    EPwm1Regs.ETCLR.bit.SOCA = 1;      // clears SOCA flag

// Enable global Interrupts and higher priority real-time debug events:
	EINT;		// Enable Global interrupt INTM
	ERTM;		// Enable Global real time interrupt DBGM

// IDLE loop. Just sit and loop forever:	
	for(;;)		//infinite loop
	{
//        if(AdcaRegs.ADCINTFLG.bit.ADCINT1==1) // check if ADC is done with conversion
//        {
//
////        GpioDataRegs.GPBSET.bit.GPIO34=1;// GPIO to see execution time
//
//
//            counter_ADC++;
//            AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;// clear ADC flag to accept future interrupt
//
//            EXECUTE_ADC_TASK(); // adc signals filter etc
//
//            Call_STATE_TRANSITION();
//
//            EXECUTE_OTHER_TASK();
//
//
//        }
//
////        GpioDataRegs.GPBCLEAR.bit.GPIO34=1;// GPIO to see execution time

	}
}
//////////////////////////////////////////////////////////////////////

