
#include <00_f28002x_CLARKE.h>
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_INV_PARK.h>
#include <00_f28002x_MODULATION.h>
#include <00_f28002x_PARAMETER.h>
#include <00_f28002x_PARK.h>
#include <00_f28002x_PI_Controller.h>
#include <00_f28002x_STATE_MACHINE.h>
#include <IQmathLib.h>
#include "01_f28002x_device.h"

///////////////////////////////////////////////////////

PWM_REG_LOAD INV_PWM_REG_LOAD=PWM_REG_LOAD_0;
Uint16 TB_MAX=0;
////////////////////////////////////////////////////////
void INIT_MODULATION_PAR(void)
{

}


void INIT_INV_PWM(void)
{
//    INIT_TRIP_PWM_REGISTERS();

//	BLOCK_PWM_PULSE();


// this should be after two lines above ************ very imp
	INIT_PWM_REGISTERS();//define DBCNTROL after TRIP to avoid short pulses
}
//////////////////////////////////////////////////////
#define inverse_f_sw_KHz _IQdiv(_IQ(1.0),_IQ(f_sw_KHz))
#define RISING_EDGE_LOAD (int16)(dead_time_MOSFET_us*CPU_CLK_MHz)
Uint16 PWM_REG_LOAD_MAX=0;
Uint16 PWM_REG_LOAD_MIN=0;
void INIT_PWM_PAR(void)
{
	p_pow.p_par.mem.fsw_Hz=f_sw_KHz*1000;
    TB_MAX=_IQmpyI32int(inverse_f_sw_KHz,(long)CPU_CLK_MHz_times_500);

    p_pow.p_par.mem.TB_MAX_x_2=TB_MAX+TB_MAX;
    p_pow.p_var.mem.inv_PWM_full_PRD=_IQ(1.0/TB_MAX);
    p_pow.p_var.mem.inv_PWM_full_PRD=_IQmpy(_IQ(0.5),p_pow.p_var.mem.inv_PWM_full_PRD);

    INV_PWM_REG_LOAD.PERIOD_MAX=TB_MAX;
	EPwm1Regs.DBRED.all = RISING_EDGE_LOAD+RISING_EDGE_LOAD;
	EPwm2Regs.DBRED.all = RISING_EDGE_LOAD;
	EPwm3Regs.DBRED.all = RISING_EDGE_LOAD;

	EPwm1Regs.DBFED.all = RISING_EDGE_LOAD+RISING_EDGE_LOAD;
	EPwm2Regs.DBFED.all = RISING_EDGE_LOAD;
	EPwm3Regs.DBFED.all = RISING_EDGE_LOAD;

	TB_MAX=100;

	EPwm1Regs.TBPRD = TB_MAX;
	EPwm2Regs.TBPRD = TB_MAX;
	EPwm3Regs.TBPRD = TB_MAX;

	PWM_REG_LOAD_MIN=RISING_EDGE_LOAD+RISING_EDGE_LOAD;
//	PWM_REG_LOAD_MIN=RISING_EDGE_LOAD;
	PWM_REG_LOAD_MAX=TB_MAX-PWM_REG_LOAD_MIN;


    EPwm1Regs.CMPA.bit.CMPA=TB_MAX>>1;
    EPwm1Regs.CMPB.bit.CMPB=TB_MAX>>1;

//    EPwm1Regs.CMPA.bit.CMPA=0;
//    EPwm1Regs.CMPB.bit.CMPB=0;
}
//////////////////////////////////////////////////////
Uint16 PWM_value_load=0;
Uint16 counter_PWM_load=0;
void PWM_REGISTER_LOAD(void)
{
    INV_PWM_REG_LOAD.mod_PHASE_A = _IQ(0.5)+_IQmpy(_IQ(0.5),p_pow.p_var.mem.COM_mod_PH_A);
    INV_PWM_REG_LOAD.mod_PHASE_B = _IQ(0.5)+_IQmpy(_IQ(0.5),p_pow.p_var.mem.COM_mod_PH_B);
    INV_PWM_REG_LOAD.mod_PHASE_C = _IQ(0.5)+_IQmpy(_IQ(0.5),p_pow.p_var.mem.COM_mod_PH_C);

    PWM_COMP_REG_LOAD_VALUE();

	PWM_value_load=INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_A;

    if(PWM_value_load>PWM_REG_LOAD_MAX)PWM_value_load=PWM_REG_LOAD_MAX;
    if(PWM_value_load<PWM_REG_LOAD_MIN)PWM_value_load=PWM_REG_LOAD_MIN;
	EPwm1Regs.CMPA.bit.CMPA=PWM_value_load;
	EPwm1Regs.CMPB.bit.CMPB=PWM_value_load;

    PWM_value_load=INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_B;

    if(PWM_value_load>PWM_REG_LOAD_MAX)PWM_value_load=PWM_REG_LOAD_MAX;
    if(PWM_value_load<PWM_REG_LOAD_MIN)PWM_value_load=PWM_REG_LOAD_MIN;
    EPwm2Regs.CMPA.bit.CMPA=PWM_value_load;

    PWM_value_load=INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_C;

    if(PWM_value_load>PWM_REG_LOAD_MAX)PWM_value_load=PWM_REG_LOAD_MAX;
    if(PWM_value_load<PWM_REG_LOAD_MIN)PWM_value_load=PWM_REG_LOAD_MIN;
    EPwm3Regs.CMPA.bit.CMPA=PWM_value_load;

	p_pow.p_stat.bit.PWM_REG_loaded=1;
	counter_PWM_load++;
	EPwm1Regs.EPWMSYNCINSEL.bit.SEL=0;
	EPwm1Regs.EPWMSYNCOUTEN.bit.SWEN=0;
}
///////////////////////////////////////////////////////////////
void PWM_COMP_REG_LOAD_VALUE(void)
{
    INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_A=_IQmpyI32int(INV_PWM_REG_LOAD.mod_PHASE_A,(long)INV_PWM_REG_LOAD.PERIOD_MAX);
    INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_B=_IQmpyI32int(INV_PWM_REG_LOAD.mod_PHASE_B,(long)INV_PWM_REG_LOAD.PERIOD_MAX);
    INV_PWM_REG_LOAD.PWM_REG_LOAD_PH_C=_IQmpyI32int(INV_PWM_REG_LOAD.mod_PHASE_C,(long)INV_PWM_REG_LOAD.PERIOD_MAX);
}
///////////////////////////////////////////////////////////////
void INIT_PWM_REGISTERS(void)
{
    EPwm1Regs.TBPHS.all = 0;
    EPwm2Regs.TBPHS.all = 0;
    EPwm3Regs.TBPHS.all = 0;
    EPwm4Regs.TBPHS.all = 0;

    EPwm1Regs.TBCTL.all = PWM_1_INV_INIT;
    EPwm2Regs.TBCTL.all = PWM_2_INV_INIT;
    EPwm3Regs.TBCTL.all = PWM_2_INV_INIT;
    EPwm4Regs.TBCTL.all = PWM_2_INV_INIT;

    EPwm1Regs.CMPCTL.all = CMPCTL_INIT_STATE;
    EPwm2Regs.CMPCTL.all = CMPCTL_INIT_STATE;
    EPwm3Regs.CMPCTL.all = CMPCTL_INIT_STATE;
    EPwm4Regs.CMPCTL.all = CMPCTL_INIT_STATE;

    EPwm1Regs.AQCTLA.all = CAU_CLEAR+CAD_SET;
    EPwm2Regs.AQCTLA.all = CAU_CLEAR+CAD_SET;
    EPwm3Regs.AQCTLA.all = CAU_CLEAR+CAD_SET;
    EPwm4Regs.AQCTLA.all = CAU_CLEAR+CAD_SET;
    EPwm1Regs.AQCTLB.all = CBU_CLEAR+CBD_SET;

    EPwm1Regs.PCCTL.all = CHPEN_DISABLE;
    EPwm2Regs.PCCTL.all = CHPEN_DISABLE;
    EPwm3Regs.PCCTL.all = CHPEN_DISABLE;
    EPwm4Regs.PCCTL.all = CHPEN_DISABLE;

    EPwm1Regs.DBCTL.all = DB_POLSEL_INVERTER;
    EPwm2Regs.DBCTL.all = DB_POLSEL_INVERTER;
    EPwm3Regs.DBCTL.all = DB_POLSEL_INVERTER;
    EPwm4Regs.DBCTL.all = DB_POLSEL_INVERTER;

    EPwm1Regs.EPWMSYNCINSEL.bit.SEL=0;
    EALLOW;
    EPwm1Regs.TZCTL.all=0xFFFF;
    EDIS;
}
////////////////////////////////////////////////////////////////
void INIT_TRIP_PWM_REGISTERS(void)
{
        EALLOW;
//    EPwm1Regs.TZCTL.bit.TZA=2;
//    EPwm1Regs.TZCTL.bit.TZB=2;
//    EPwm2Regs.TZCTL.bit.TZA=2;
//    EPwm2Regs.TZCTL.bit.TZB=2;
//    EPwm3Regs.TZCTL.bit.TZA=2;
//    EPwm3Regs.TZCTL.bit.TZB=2;
//    EPwm4Regs.TZCTL.bit.TZA=2;
//    EPwm4Regs.TZCTL.bit.TZB=2;
        EDIS;
}
////////////////////////////////////////////////////////////////
void RELEASE_PWM_PULSE(void)
{
    EALLOW;
//    EPwm1Regs.TZCLR.bit.OST=1;
//    EPwm2Regs.TZCLR.bit.OST=1;
//    EPwm3Regs.TZCLR.bit.OST=1;
    EDIS;
}


void BLOCK_PWM_PULSE(void)
{
    EALLOW;
//    EPwm1Regs.TZFRC.bit.OST=1;
//    EPwm2Regs.TZFRC.bit.OST=1;
//    EPwm3Regs.TZFRC.bit.OST=1;
    EDIS;
}



void RESET_INVERTER_MODULATION_PAR(void)
{
	p_pow.p_stat.bit.PWM_REG_loaded=0;
}
