/////////////////////////////////////////////////////////////////////////
#ifndef __00_f28002x_Parameter_H__
#define __00_f28002x_Parameter_H__

/////////////////////////////////////////////////////////////////////////

#define CONVERTER_PRESENT 1
#define FOC_CONTROL_CURRENT 0 //1

// ***** BOARD TYPE *******
// 0: LAUNCHXL-F280025C, TI
// 1: OJMAN TECHNOLOGIES
// 2: CALSTAT BLDC INVERTER BOARD NEW ON 2022/09/26,
// 3:CALSTAT STANDALONE uC board
#define BLDC_BOARD 3 //2


// ****** CONTROL TYPE *******
// 0: three phase, del_PWM_theta=0;
// 1: FOC: three phase, with del_PWM_theta calculated based on HALL ABC,
// 2: two phase switching, trapezoidal
#define CONTROL_SCHEME 1 //1

/////////////////////////////////////////////////////////////////////////
#ifndef true
#define false 0
#define true  1
#endif
/////////////////////////////////////////////////////////////////////////
#define PI 3.14159265358979
#define One_thousand 1000
#define One_hundred 100
#define One_ten 10

// Define the system frequency (MHz)
#define CPU_CLK_MHz 100 //100 MHz
#define CPU_CLK_Hz (CPU_CLK_MHz*1000000)
#define K_back_EMF 0.124 // per HERTZ
#define LSPCLK_SCALE 14
#define dead_time_MOSFET_us 0.05//1.0 //in uSec

#define CPU_TIMER_KHz 100 // 100KHz CPU TIMER
// idea is to keep f_sw=20KHz, so (a) ISR_KHz=20KHz and f_sw_in_one_ISR=1 or (b) ISR_KHz=10KHz and f_sw_in_one_ISR=2 and so on
#define ISR_KHz 60 // 20 KHz ISR frequency
#define f_sw_in_one_ISR 1 // f_sw same as ISR_KHz
#define f_sw_KHz (ISR_KHz*f_sw_in_one_ISR)
#define MAX_f_fund 250

#define INIT_POS_MAX_VAL 0x7530 // 30,000 decimal
#define N_count 500 // count in one rotation of encoder of one channel
#define f_encoder 50.0 // 50Hz means 20 ms unit time for counting the cap counter
#define speed_rps_count_scale _IQ(f_encoder/(N_count*4)) // 4 stand for rising and falling edge QEP count, speed in rps
//////////////////////////////////////////////////////////////////////////

#define ISR_LOOP_ms 1
#define del_f_stator_feq 5
#define max_f_stator_target 50
#define min_f_stator_target 5

#define motor_speed_0_to_1_thers _IQ(0.4) //rps 0.4=0.4*60=24 rpm
#define motor_speed_1_to_0_thers _IQ(0.2) //rps 0.2=0.2*60=12 rpm
#define mod_level_dc_gen_boost_0 _IQ(0.4)
//////////////////////////////////////////////////////////////////////////
//////////////// Vsolar and Isolar ///////////////////////////////////////
////////// assume voltage and current scales same as battery /////////////
#define Kv_scale One_hundred // for voltage, actual voltage is Kv_scale times the IQ value
#define Ki_scale One_hundred //for current
#define Kp_scale One_ten//for power
#define Kt_scale One_hundred//for temperature

#define Kv_display Kv_scale*One_ten // for voltage
#define Ki_display Ki_scale*One_ten //for current
#define Kp_diaplay Kp_scale*One_ten//for power
#define Kt_display Kt_scale*One_ten//for temperature

#define VOLTAGE_to_IQ _IQ((float)1/Kv_scale)// 1/Kv_scale
#define CURRENT_to_IQ _IQ((float)1/Ki_scale)// 1/Ki_scale
#define POWER_to_IQ _IQ((float)1/Kp_scale)// 1/Kv_scale
#define TEMP_to_IQ _IQ((float)1/Kt_scale)// 1/Ki_scale

#define run_PI_in_sec 100

#define V_OVER_F_RATIO_0 _IQ(0.040001)//
#define del_volt_over_hz_ratio _IQ(0.005)
#define del_feed_forward_duty _IQ(0.02)
#define max_feed_forward_duty _IQ(0.4)

#define actual_Ia_AMP_REF_min 0
#define actual_Ia_AMP_REF_max 10
#define actual_del_Ia_AMP _IQ(0.5)
#define actual_Ia_rated _IQ(5.0)
#define actual_DC_VOL_GEN_upper_thres 200
#define actual_DC_VOL_GEN_lower_thres 180
#define macro_del_Ia_AMP _IQmpy(CURRENT_to_IQ,actual_del_Ia_AMP)
#define macro_Ia_rated _IQmpy(CURRENT_to_IQ,actual_Ia_rated)
#define inverse_Ia_rated _IQ(1.0/_IQtoF(macro_Ia_rated))
#define macro_Ia_AMP_REF_min _IQmpyI32(CURRENT_to_IQ,(int16)actual_Ia_AMP_REF_min)
#define macro_Ia_AMP_REF_max _IQmpyI32(CURRENT_to_IQ,(int16)actual_Ia_AMP_REF_max)
#define macro_DC_VOL_GEN_upper_thres _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_DC_VOL_GEN_upper_thres)
#define macro_DC_VOL_GEN_lower_thres _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_DC_VOL_GEN_lower_thres)

#define del_mod_level_dc_gen_boost _IQ(0.02)
#define max_mod_level_dc_gen_boost _IQ(0.6)
#define min_mod_level_dc_gen_boost _IQ(0.2)

#define dc_machine_ramp_time 20 // 10 sec
#define del_mod_level_dc_gen_brake _IQ(1.0/(run_PI_in_sec*dc_machine_ramp_time))
#define del_mod_level_dc_motor _IQ(0.5/(run_PI_in_sec*dc_machine_ramp_time))

#define rated_DC_MACHINE_speed 25 // rps=1500 rpm
#define inverse_rated_DC_MACHINE_speed _IQ(1.0/rated_DC_MACHINE_speed)

#define count_DELAY_INITIAL (int16)(100*ISR_KHz)// 2 sec
#define count_BAT_INITIAL (int16)(100*ISR_KHz)// 3 sec
#define fault_reset_count (int16)(f_fund*20.0)// 10 sec
#define count_ADC_OFFSET (int16)(1000*ISR_KHz)// 1 second

#endif// this endif is for the file, keep it

