/* =================================================================================
File name:       PARK.H (IQ version)
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description:
Header file containing constants, data type, and macro definitions for the PARK.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 10-15-2009	Version 1.0
------------------------------------------------------------------------------*/
#ifndef __00_f28002x_PARK_H__
#define __00_f28002x_PARK_H__

typedef struct {  _iq  alpha;  		// Input: stationary d-axis stator variable
				  _iq  beta;	 	// Input: stationary q-axis stator variable
				  _iq  f_d;			// Output: rotating d-axis stator variable
				  _iq  f_q;			// Output: rotating q-axis stator variable
				  _iq  SIN;
				  _iq  COS;
		 	 	} TRF_PARK;


/*-----------------------------------------------------------------------------
Default initalizer for the PARK object.
-----------------------------------------------------------------------------*/
#define TRF_PARK_DEFAULTS {   0, \
                          0, \
                          0, \
                          0, \
                          0, \
						  0, \
              			  }

/*------------------------------------------------------------------------------
	PARK Transformation Macro Definition
------------------------------------------------------------------------------*/


#define TRF_PARK_MACRO(v)											\
																	\
	v.f_d = _IQmpy(v.alpha,v.COS) + _IQmpy(v.beta,v.SIN);			\
    v.f_q = _IQmpy(v.beta,v.COS) - _IQmpy(v.alpha,v.SIN);

#endif // __PARK_H__
