

#ifndef __00_f28002x_PI_Controller_H__
#define __00_f28002x_PI_Controller_H__

#define max_mod_level _IQ(0.6)
typedef struct {  _iq  command;
				  _iq  feedback;
				  _iq  error;
				  _iq  Kp;
				  _iq  Ki;
				  _iq  out_p;
				  _iq  out_i;
				  _iq  out_pi;
				  _iq  out_Max;
				  _iq  out_Min;
		 	 	} PI_REG;


#define Mod_index_PI_defaults {_IQ(0.0),			\
									_IQ(0.0),		\
									_IQ(0.0),		\
									_IQ(0.1),		\
									_IQ(0.1),		\
									_IQ(0.0),		\
									_IQ(0.0),		\
									_IQ(0.0),		\
									max_mod_level,	\
									_IQ(0.0),		\
												}




#define PI_MACRO(v)																			\
	v.error = v.command - v.feedback;														\
	v.out_p=_IQmpy(v.Kp,v.error);															\
	v.out_p = _IQsat(v.out_p, v.out_Max, v.out_Min);										\
	v.out_i= v.out_i+_IQmpy(v.Ki,v.error);													\
	v.out_i = _IQsat(v.out_i, v.out_Max, v.out_Min);										\
	v.out_pi = v.out_p + v.out_i;															\
	v.out_pi = _IQsat(v.out_pi, v.out_Max, v.out_Min);
#endif
