

#ifndef __00_f28002x_Protection_H__
#define __00_f28002x_Protection_H__

void Call_PROTECTION(void);
void Call_OVER_CURRENT(void);
void Call_OVER_TEMP(void);
void Call_CURRENT_SENSOR_TEST(void);
void Call_OVER_VOLTAGE(void);
void Call_UNDER_VOLTAGE(void);
void RESET_PROTETION_FLAG(void);
void RESET_PROTECTION(void);

#define COUNT_OV_I_H 2
#define COUNT_OV_I_L 2

#define COUNT_OV_V_H 2
#define COUNT_OV_V_L 2

#define COUNT_UV_V_H 10
#define COUNT_UV_V_L 10

#define COUNT_OV_TEMP 20

#define actual_OVER_TEMP_LIMIT 72 // 60 deg C
#define OVER_TEMP_LIMIT _IQmpyI32(TEMP_to_IQ,(int16)actual_OVER_TEMP_LIMIT)

#define act_I_H_LIMIT 18
#define act_I_H_LIM_INS 25
#define act_I_L_LIMIT 40
#define act_I_L_LIM_INS 50

#define I_H_LIMIT _IQmpyI32(CURRENT_to_IQ,(int16)act_I_H_LIMIT)
#define I_L_LIMIT _IQmpyI32(CURRENT_to_IQ,(int16)act_I_L_LIMIT)
#define I_H_LIM_INS _IQmpyI32(CURRENT_to_IQ,(int16)act_I_H_LIM_INS)
#define I_L_LIM_INS _IQmpyI32(CURRENT_to_IQ,(int16)act_I_L_LIM_INS)

#define I_L_LIM_0 _IQmpy(_IQ(1.3),I_H_LIMIT)

#define act_I_H_POLARITY_LIMIT _IQ(0.6)
#define I_H_POLARITY_LIMIT _IQmpy(CURRENT_to_IQ,act_I_H_POLARITY_LIMIT)

#define act_I_L_POLARITY_LIMIT _IQ(5.0)
#define I_L_POLARITY_LIMIT _IQmpy(CURRENT_to_IQ,act_I_L_POLARITY_LIMIT)


#define actual_OVER_V_L_LIM 150
#define OVER_V_L_LIM _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_OVER_V_L_LIM)
#define actual_OVER_V_H_LIM 450
#define OVER_V_H_LIM _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_OVER_V_H_LIM)

#define actual_UNDER_V_L_LIM 70
#define UNDER_V_L_LIM _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_UNDER_V_L_LIM)
#define actual_UNDER_V_H_LIM 290
#define UNDER_V_H_LIM _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_UNDER_V_H_LIM)

#endif
