

#ifndef __00_f28002x_SCI_H__
#define __00_f28002x_SCI_H__
#include <00_f28002x_PARAMETER.h>
#include "01_f28002x_device.h"
#include "01_f28002x_examples.h"

void RESET_RX(void);
void ENABLE_TX(void);
void SEND_TX(void);
void RESET_TX(void);
#define SCI_BAUD_KHz 4.8 //
#define SCI_BRR (int16)((float)CPU_CLK_MHz*1000/(SCI_BAUD_KHz*8*LSPCLK_SCALE)-1)

#define INIT_SCI_MACRO()																								\
																														\
	SciaRegs.SCICCR.all =0x0007;   /* 1 stop bit,No loopback,No parity,8 char bits,async mode, idle-line protocol*/		\
	SciaRegs.SCICTL1.bit.SWRESET=1;																						\
	SciaRegs.SCICTL1.bit.TXENA=1;																						\
	SciaRegs.SCICTL1.bit.RXENA=1;																						\
	SciaRegs.SCICTL2.all =0x0003;																						\
	SciaRegs.SCICTL2.bit.TXINTENA =0;																					\
	SciaRegs.SCICTL2.bit.RXBKINTENA =0;																					\
	SciaRegs.SCIHBAUD.all = 0x0000;																						\
																														\
	/*SciaRegs.SCILBAUD = 0x0031;	*/	/* 31h = 38.4Kbaud @ LSPCLK = 60/4 MHz	*/										\
	SciaRegs.SCILBAUD.all = SCI_BRR;			/* 20h = 57.6Kbaud @ LSPCLK = 60/4 MHz	*/								\
	/*SciaRegs.SCILBAUD = 0x0010;	*/	/* 10h = 115.2Kbaud @ LSPCLK = 60/4 MHz	*/										\
																														\
	SciaRegs.SCICTL1.all =0x0023;		/* Relinquish SCI from Reset			*/										\
																														\
/*	SciaRegs.SCIFFTX.all=0xE040;	*/	/* ENable FIFO enhancement				*/										\
/*	SciaRegs.SCIFFTX.all=0x8040;	*/	/* DISable FIFO enhancement				*/										\
/*	SciaRegs.SCIFFRX.all=0x204F;	*/																					\
	SciaRegs.SCIFFTX.bit.SCIRST=0;																						\
	SciaRegs.SCIFFTX.bit.SCIRST=1;																						\
	SciaRegs.SCIFFTX.bit.SCIFFENA=1;																					\
	SciaRegs.SCIFFTX.bit.TXFIFORESET=0;					    															\
	SciaRegs.SCIFFRX.bit.RXFIFORESET=0;																					\
	SciaRegs.SCIFFTX.bit.TXFIFORESET=1;			    																	\
	SciaRegs.SCIFFRX.bit.RXFIFORESET=1;																					\
	SciaRegs.SCIFFCT.bit.FFTXDLY=4;	/* delay of 4 BAUD CYCLE */		       												\
	SciaRegs.SCIPRI.bit.FREESOFT=0x1;																					\
    SciaRegs.SCIFFRX.bit.RXFFIENA=1;  /* enable RX interrupt */                                                         \
    SciaRegs.SCIFFRX.bit.RXFFIL=15;   /* generate interrupt after 15 fill */                                            \


#endif
