/* ==================================================================================
File name:       F28035_SPI.H
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Target: TMS320F2803x family
              
=====================================================================================
History:
-------------------------------------------------------------------------------------
 04-15-2010	Version 1.1 
------------------------------------------------------------------------------------*/

#ifndef __00_f28002x_SPI_H__
#define __00_f28002x_SPI_H__

/*------------------------------------------------------------------------------
 SPI Macro initialization 
------------------------------------------------------------------------------*/

#define INIT_SPI_A_MACRO()																		    \
																								    \
	EALLOW;																						    \
	SpiaRegs.SPICCR.bit.SPISWRESET=0; /* Reset SPI	*/											    \
	SpiaRegs.SPICCR.bit.SPICHAR=0xF;			/*16-bit character	*/							    \
	SpiaRegs.SPICCR.bit.SPILBK=0;	/* loop back disabled*/										    \
	SpiaRegs.SPICTL.bit.SPIINTENA=0;															    \
	SpiaRegs.SPICTL.bit.CLK_PHASE=1;															    \
	SpiaRegs.SPICTL.bit.MASTER_SLAVE=1;															    \
   	SpiaRegs.SPICTL.bit.TALK=1;																	    \
   	SpiaRegs.SPICTL.bit.OVERRUNINTENA=0;														    \
   	SpiaRegs.SPIBRR.all=0x00FF;			/* Baud rate max=LSPCLK/256, so min effective value=3 */	\
	SpiaRegs.SPIFFTX.bit.SPIRST=1;	/* page 31*/												    \
	SpiaRegs.SPIFFTX.bit.SPIFFENA=1;	/*to let SPIRXINT as SPIRXINT , pg 20*/					    \
	SpiaRegs.SPIFFTX.bit.TXFFIENA=0;	/* page 31, enable TX interrupt*/						    \
	SpiaRegs.SPIFFTX.bit.TXFFIL=0;	/* page 31, int with 2 words*/								    \
	SpiaRegs.SPIFFCT.all=0x00;		/* zero delay */											    \
	SpiaRegs.SPIPRI.bit.TRIWIRE=0;		/* 3 wire system */										    \
	SpiaRegs.SPIPRI.bit.FREE=1;		/*free run*/												    \
	SpiaRegs.SPIFFCT.bit.TXDLY=1;	/*in FIFO mode this delay has to be atleast one CLK pg 33*/	    \
	SpiaRegs.SPICCR.bit.SPISWRESET=1;  /* SPI ready		*/										    \
	SpiaRegs.SPIFFTX.bit.TXFIFO=1;																    \
	EDIS;																						    \




#define INIT_SPI_B_MACRO()                                                                          \
                                                                                                    \
    EALLOW;                                                                                         \
    SpibRegs.SPICCR.bit.SPISWRESET=0; /* Reset SPI  */                                              \
    SpibRegs.SPICCR.bit.SPICHAR=0xF;            /*16-bit character  */                              \
    SpibRegs.SPICCR.bit.SPILBK=0;   /* loop back disabled*/                                         \
    SpibRegs.SPICTL.bit.SPIINTENA=0;                                                                \
    SpibRegs.SPICTL.bit.CLK_PHASE=1;                                                                \
    SpibRegs.SPICTL.bit.MASTER_SLAVE=1;                                                             \
    SpibRegs.SPICTL.bit.TALK=1;                                                                     \
    SpibRegs.SPICTL.bit.OVERRUNINTENA=0;                                                            \
    SpibRegs.SPIBRR.all=0x00FF;         /* Baud rate max=LSPCLK/256, so min effective value=3 */    \
    SpibRegs.SPIFFTX.bit.SPIRST=1;  /* page 31*/                                                    \
    SpibRegs.SPIFFTX.bit.SPIFFENA=1;    /*to let SPIRXINT as SPIRXINT , pg 20*/                     \
    SpibRegs.SPIFFTX.bit.TXFFIENA=0;    /* page 31, enable TX interrupt*/                           \
    SpibRegs.SPIFFTX.bit.TXFFIL=0;  /* page 31, int with 2 words*/                                  \
    SpibRegs.SPIFFCT.all=0x00;      /* zero delay */                                                \
    SpibRegs.SPIPRI.bit.TRIWIRE=0;      /* 3 wire system */                                         \
    SpibRegs.SPIPRI.bit.FREE=1;     /*free run*/                                                    \
    SpibRegs.SPIFFCT.bit.TXDLY=1;   /*in FIFO mode this delay has to be atleast one CLK pg 33*/     \
    SpibRegs.SPICCR.bit.SPISWRESET=1;  /* SPI ready     */                                          \
    SpibRegs.SPIFFTX.bit.TXFIFO=1;                                                                  \
    EDIS;                                                                                           \

#endif
