/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
#include <00_f28002x_CONVERTER.h>
#include <00_f28002x_DIS_04_master.h>
#include <00_f28002x_Signal_Condition.h>
#include <00_f28002x_STATE_MACHINE.h>
#include "00_F28002x_Parameter.h"
/////////////////////////////////////////////////////

LOW_PASS_FILTER FILTER_V_DC=filter_0;
LOW_PASS_FILTER FILTER_V_A=filter_0;
LOW_PASS_FILTER FILTER_V_B=filter_0;
LOW_PASS_FILTER FILTER_V_C=filter_0;

LOW_PASS_FILTER FILTER_I_A=filter_0;
LOW_PASS_FILTER FILTER_I_B=filter_0;
LOW_PASS_FILTER FILTER_I_C=filter_0;
LOW_PASS_FILTER FILTER_I_dc=filter_0;

LOW_PASS_FILTER FIL_TEMP_1=filter_0;
LOW_PASS_FILTER FIL_TEMP_2=filter_0;

LOW_PASS_FILTER FIL_TEMP_3=filter_0;
LOW_PASS_FILTER FIL_TEMP_4=filter_0;

Uint16 counter_ADC_OFFSET=0;
_iq OFFSET_I_A=OFF_I_A;
_iq OFFSET_I_B=OFF_I_B;
_iq OFFSET_I_C=OFF_I_C;
_iq OFFSET_I_dc=OFF_I_dc;
_iq VOL_BUILD=0;
_iq V_BAT_CCCV=0;
#define del_V_BAT_01 _IQ(0.02)
#define del_V_BAT_02 _IQ(0.0001)
_iq del_V_BAT=del_V_BAT_01;
////////////////////////////////////
volatile struct ADC_REGISTERS ADC_RESULTS;
////////////////////////////////////
void INIT_ADC_OFF_GAIN(void)
{

//	p_pow.p_stat.bit.adc_offset_done=1;
    V_BAT_CCCV=FORCE_V_L;
}

#define I_dq _IQ(0.10)
#define theta_i_dq _IQ(0.25)
Uint16 counter_V_BAT_CCCV=0;
#define count_V_BAT_CCCV (ISR_KHz*1000)
#define R_BAT _IQ(5.5)
_iq CALCULATE_VI=0;

void Assign_ADC_RESULTS()
{

    //F28027 PROCESSOR
    ADC_RESULTS.PIN_04_a06_ADC_A_RESULT_0               =AdcaResultRegs.ADCRESULT0 & 0x0FFF;
    ADC_RESULTS.PIN_05_a03_ADC_A_RESULT_1               =AdcaResultRegs.ADCRESULT1 & 0x0FFF;
    ADC_RESULTS.PIN_06_a02_ADC_A_RESULT_2               =AdcaResultRegs.ADCRESULT2 & 0x0FFF;
    ADC_RESULTS.PIN_07_a15_ADC_A_RESULT_3               =AdcaResultRegs.ADCRESULT3 & 0x0FFF;
    ADC_RESULTS.PIN_08_a11_ADC_A_RESULT_4               =AdcaResultRegs.ADCRESULT4 & 0x0FFF;
    ADC_RESULTS.PIN_09_a05_ADC_A_RESULT_5               =AdcaResultRegs.ADCRESULT5 & 0x0FFF;
    ADC_RESULTS.PIN_10_a01_ADC_A_RESULT_6               =AdcaResultRegs.ADCRESULT6 & 0x0FFF;
    ADC_RESULTS.PIN_11_a00_ADC_A_RESULT_7               =AdcaResultRegs.ADCRESULT7 & 0x0FFF;

    ADC_RESULTS.PIN_14_c01_ADC_C_RESULT_0               =AdccResultRegs.ADCRESULT0 & 0x0FFF;
    ADC_RESULTS.PIN_15_c03_ADC_C_RESULT_1               =AdccResultRegs.ADCRESULT1 & 0x0FFF;
    ADC_RESULTS.PIN_16_c11_ADC_C_RESULT_2               =AdccResultRegs.ADCRESULT2 & 0x0FFF;
    ADC_RESULTS.PIN_19_c14_ADC_C_RESULT_3               =AdccResultRegs.ADCRESULT3 & 0x0FFF;
    ADC_RESULTS.PIN_20_c08_ADC_C_RESULT_4               =AdccResultRegs.ADCRESULT4 & 0x0FFF;
    ADC_RESULTS.PIN_21_c10_ADC_C_RESULT_5               =AdccResultRegs.ADCRESULT5 & 0x0FFF;
    ADC_RESULTS.PIN_XX_cXX_ADC_A_RESULT_6               =AdccResultRegs.ADCRESULT5 & 0x0FFF;
    ADC_RESULTS.PIN_XX_cXX_ADC_A_RESULT_7               =AdccResultRegs.ADCRESULT5 & 0x0FFF;


    p_pow.p_vol.mem.V_dc=_IQ15toIQ(ADC_RESULTS.PIN_04_a06_ADC_A_RESULT_0<<3);
    p_pow.p_var.mem.vol_throttle=_IQ15toIQ(ADC_RESULTS.PIN_05_a03_ADC_A_RESULT_1<<3);// throttle voltage BLDC
	p_pow.p_cur.mem.I_dc=_IQ15toIQ(ADC_RESULTS.PIN_06_a02_ADC_A_RESULT_2<<3);
//	p_pow.p_cur.mem.I_a=_IQ15toIQ(ADC_RESULTS.PIN_07_a15_ADC_A_RESULT_3<<3);
//	p_pow.p_cur.mem.I_b=_IQ15toIQ(ADC_RESULTS.PIN_08_a11_ADC_A_RESULT_4<<3);
//	p_pow.p_cur.mem.I_c=_IQ15toIQ(ADC_RESULTS.PIN_09_a05_ADC_A_RESULT_5<<3);
	p_pow.p_cur.mem.adc_a_dummy=_IQ15toIQ(ADC_RESULTS.PIN_10_a01_ADC_A_RESULT_6<<3);
	p_pow.p_cur.mem.adc_a_dummy=_IQ15toIQ(ADC_RESULTS.PIN_11_a00_ADC_A_RESULT_7<<3);

    p_pow.p_vol.mem.V_b=_IQ15toIQ(ADC_RESULTS.PIN_14_c01_ADC_C_RESULT_0<<3);
    p_pow.p_vol.mem.V_c=_IQ15toIQ(ADC_RESULTS.PIN_15_c03_ADC_C_RESULT_1<<3);
    p_pow.p_vol.mem.V_a=_IQ15toIQ(ADC_RESULTS.PIN_16_c11_ADC_C_RESULT_2<<3);
    p_pow.p_cur.mem.I_a=_IQ15toIQ(ADC_RESULTS.PIN_19_c14_ADC_C_RESULT_3<<3);
    p_pow.p_cur.mem.I_b=_IQ15toIQ(ADC_RESULTS.PIN_20_c08_ADC_C_RESULT_4<<3);
    p_pow.p_cur.mem.I_c=_IQ15toIQ(ADC_RESULTS.PIN_21_c10_ADC_C_RESULT_5<<3);
//    p_pow.p_vol.mem.adc_c_dummy=_IQ15toIQ(ADC_RESULTS.PIN_19_c14_ADC_C_RESULT_3<<3);
//    p_pow.p_vol.mem.adc_c_dummy=_IQ15toIQ(ADC_RESULTS.PIN_20_c08_ADC_C_RESULT_4<<3);
//    p_pow.p_vol.mem.adc_c_dummy=_IQ15toIQ(ADC_RESULTS.PIN_21_c10_ADC_C_RESULT_5<<3);


	p_pow.p_inv.mem.TEMP_LV=_IQ15toIQ(ADC_RESULTS.PIN_XX_cXX_ADC_A_RESULT_6<<3);
	p_pow.p_inv.mem.TEMP_HV=_IQ15toIQ(ADC_RESULTS.PIN_XX_cXX_ADC_A_RESULT_7<<3);

#if(CONVERTER_PRESENT==0)
	CALCULATE_VI=_IQmpy(I_dq,_IQcosPU(p_pow.p_var.mem.theta_FOC_dq+theta_i_dq));
	CALCULATE_VI=_IQdiv(CALCULATE_VI,GAIN_I_A);
	p_pow.p_cur.mem.I_a=CALCULATE_VI+OFFSET_I_A;

    CALCULATE_VI=_IQmpy(I_dq,_IQcosPU(p_pow.p_var.mem.theta_FOC_dq+theta_i_dq-_IQ(0.33333)));
    CALCULATE_VI=_IQdiv(CALCULATE_VI,GAIN_I_B);
    p_pow.p_cur.mem.I_b=CALCULATE_VI+OFFSET_I_B;

    CALCULATE_VI=_IQmpy(I_dq,_IQcosPU(p_pow.p_var.mem.theta_FOC_dq+theta_i_dq+_IQ(0.33333)));
    CALCULATE_VI=_IQdiv(CALCULATE_VI,GAIN_I_C);
    p_pow.p_cur.mem.I_c=CALCULATE_VI+OFFSET_I_C;

#endif
}

////////////////////////////////////////////////////////
//////////// ADC Vinv OFFSET CALCULATION ///////////////
void Call_ADC_OFFSET(void)
{
    counter_ADC_OFFSET++;
    if(counter_ADC_OFFSET>=count_ADC_OFFSET)
	{
//		p_pow.p_cur.mem.I_a_OFFSET=OFFSET_I_A;
//		p_pow.p_cur.mem.I_b_OFFSET=OFFSET_I_B;
//		p_pow.p_cur.mem.I_c_OFFSET=OFFSET_I_C;
        p_pow.p_stat.bit.adc_offset_done=1;
		counter_ADC_OFFSET=0;
	}
	else
	{
	    OFFSET_I_A+=_IQmpy(FILTER_I_A.w_break_ac,(p_pow.p_cur.mem.I_a-OFFSET_I_A));
	    OFFSET_I_B+=_IQmpy(FILTER_I_B.w_break_ac,(p_pow.p_cur.mem.I_b-OFFSET_I_B));
	    OFFSET_I_C+=_IQmpy(FILTER_I_C.w_break_ac,(p_pow.p_cur.mem.I_c-OFFSET_I_C));
	    OFFSET_I_dc+=_IQmpy(FILTER_I_dc.w_break_ac,(p_pow.p_cur.mem.I_dc-OFFSET_I_dc));
	}
}

/////////////////////////////////////////////////////////////////////

void Call_FILTER_VI(void)
{
	FILTER_V_DC.x_value=_IQmpy((p_pow.p_vol.mem.V_dc-OFFSET_V_DC),GAIN_V_DC);
	FILTER_V_DC.y_value+=_IQmpy(FILTER_V_DC.w_break_ac,(FILTER_V_DC.x_value-FILTER_V_DC.y_value));
	p_pow.p_vol.mem.V_dc_filter=FILTER_V_DC.y_value;

	FILTER_V_A.x_value=_IQmpy((p_pow.p_vol.mem.V_a-OFFSET_V_A),GAIN_V_A);
	FILTER_V_A.y_value+=_IQmpy(FILTER_V_A.w_break_ac,(FILTER_V_A.x_value-FILTER_V_A.y_value));
	p_pow.p_vol.mem.V_a_filter=FILTER_V_A.y_value;

    FILTER_V_B.x_value=_IQmpy((p_pow.p_vol.mem.V_b-OFFSET_V_B),GAIN_V_B);
    FILTER_V_B.y_value+=_IQmpy(FILTER_V_B.w_break_ac,(FILTER_V_B.x_value-FILTER_V_B.y_value));
    p_pow.p_vol.mem.V_b_filter=FILTER_V_B.y_value;

    FILTER_V_C.x_value=_IQmpy((p_pow.p_vol.mem.V_a-OFFSET_V_C),GAIN_V_C);
    FILTER_V_C.y_value+=_IQmpy(FILTER_V_C.w_break_ac,(FILTER_V_C.x_value-FILTER_V_C.y_value));
    p_pow.p_vol.mem.V_c_filter=FILTER_V_C.y_value;

    FILTER_I_A.x_value=_IQmpy((p_pow.p_cur.mem.I_a-OFFSET_I_A),GAIN_I_A);
    FILTER_I_A.y_value+=_IQmpy(FILTER_I_A.w_break_ac,(FILTER_I_A.x_value-FILTER_I_A.y_value));
    p_pow.p_cur.mem.I_a_filter=FILTER_I_A.y_value;

    FILTER_I_B.x_value=_IQmpy((p_pow.p_cur.mem.I_b-OFFSET_I_B),GAIN_I_B);
    FILTER_I_B.y_value+=_IQmpy(FILTER_I_B.w_break_ac,(FILTER_I_B.x_value-FILTER_I_B.y_value));
    p_pow.p_cur.mem.I_b_filter=FILTER_I_B.y_value;

    FILTER_I_C.x_value=_IQmpy((p_pow.p_cur.mem.I_c-OFFSET_I_C),GAIN_I_C);
    FILTER_I_C.y_value+=_IQmpy(FILTER_I_C.w_break_ac,(FILTER_I_C.x_value-FILTER_I_C.y_value));
    p_pow.p_cur.mem.I_c_filter=FILTER_I_C.y_value;

    FILTER_I_dc.x_value=_IQmpy((p_pow.p_cur.mem.I_dc-OFFSET_I_dc),GAIN_I_dc);
    FILTER_I_dc.y_value+=_IQmpy(FILTER_I_dc.w_break_ac,(FILTER_I_dc.x_value-FILTER_I_dc.y_value));
    p_pow.p_cur.mem.I_dc_filter=FILTER_I_dc.y_value;
}

/////////////////////////////////////////////////////
void Call_FILTER_TEMP(void)
{
	FIL_TEMP_1.x_value=_IQmpy(p_pow.p_inv.mem.TEMP_LV,K_IQ_to_V_AD22103KTZ)-T_AD22103KTZ_0;
	FIL_TEMP_1.x_value=_IQmpy(FIL_TEMP_1.x_value,K_T_AD22103KTZ);
	FIL_TEMP_1.y_value+=_IQmpy(FIL_TEMP_1.w_break_dc,(FIL_TEMP_1.x_value-FIL_TEMP_1.y_value));
#if(CONVERTER_PRESENT==0)
	FIL_TEMP_1.y_value=macro_FORCE_TEMP;//20 deg C
#endif
	p_pow.p_inv.mem.TEMP_LV=FIL_TEMP_1.y_value;
	p_pow.p_inv.mem.TEMP_LV_filter+=_IQmpy(_IQ(0.1),p_pow.p_inv.mem.TEMP_LV-p_pow.p_inv.mem.TEMP_LV_filter);

	FIL_TEMP_2.x_value=_IQmpy(p_pow.p_inv.mem.TEMP_HV,K_IQ_to_V_AD22103KTZ)-T_AD22103KTZ_0;
	FIL_TEMP_2.x_value=_IQmpy(FIL_TEMP_2.x_value,K_T_AD22103KTZ);
	FIL_TEMP_2.y_value+=_IQmpy(FIL_TEMP_2.w_break_dc,(FIL_TEMP_2.x_value-FIL_TEMP_2.y_value));
#if(CONVERTER_PRESENT==0)
	FIL_TEMP_2.y_value=macro_FORCE_TEMP;//20 deg C
#endif
	p_pow.p_inv.mem.TEMP_HV=FIL_TEMP_2.y_value;
	p_pow.p_inv.mem.TEMP_HV_filter+=_IQmpy(_IQ(0.2),p_pow.p_inv.mem.TEMP_HV-p_pow.p_inv.mem.TEMP_HV_filter);

	FIL_TEMP_3.x_value=_IQmpy(p_pow.p_inv.mem.TEMP_TX,K_IQ_to_V_AD22103KTZ)-T_AD22103KTZ_0;
	FIL_TEMP_3.x_value=_IQmpy(FIL_TEMP_3.x_value,K_T_AD22103KTZ);
	FIL_TEMP_3.y_value+=_IQmpy(FIL_TEMP_3.w_break_dc,(FIL_TEMP_3.x_value-FIL_TEMP_3.y_value));
#if(CONVERTER_PRESENT==0)
	FIL_TEMP_3.y_value=macro_FORCE_TEMP;//20 deg C
#endif
	p_pow.p_inv.mem.TEMP_TX=FIL_TEMP_3.y_value;
	p_pow.p_inv.mem.TEMP_TX_filter+=_IQmpy(_IQ(0.2),p_pow.p_inv.mem.TEMP_TX-p_pow.p_inv.mem.TEMP_TX_filter);

	FIL_TEMP_4.x_value=_IQmpy(p_pow.p_inv.mem.TEMP_CH,K_IQ_to_V_AD22103KTZ)-T_AD22103KTZ_0;
	FIL_TEMP_4.x_value=_IQmpy(FIL_TEMP_4.x_value,K_T_AD22103KTZ);
	FIL_TEMP_4.y_value+=_IQmpy(FIL_TEMP_4.w_break_dc,(FIL_TEMP_4.x_value-FIL_TEMP_4.y_value));
#if(CONVERTER_PRESENT==0)
	FIL_TEMP_4.y_value=macro_FORCE_TEMP;//20 deg C
#endif
	p_pow.p_inv.mem.TEMP_CH=FIL_TEMP_4.y_value;
	p_pow.p_inv.mem.TEMP_CH_filter+=_IQmpy(_IQ(0.2),p_pow.p_inv.mem.TEMP_CH-p_pow.p_inv.mem.TEMP_CH_filter);
}

/////////////////////////////////////////////////////////////////
//////// Moving Average /////////////////////////////////////////
void FIND_AVERAGE(AVE_PAR_8 *p_ave)
{
	p_ave->element_00=p_ave->element_01;
	p_ave->element_01=p_ave->element_02;
	p_ave->element_02=p_ave->element_03;
	p_ave->element_03=p_ave->element_04;
	p_ave->element_04=p_ave->element_05;
	p_ave->element_05=p_ave->element_06;
	p_ave->element_06=p_ave->element_07;
	p_ave->element_07=p_ave->element_new;

	p_ave->ave_value=p_ave->element_00+p_ave->element_01+p_ave->element_02+p_ave->element_03;
	p_ave->ave_value=p_ave->ave_value+p_ave->element_04+p_ave->element_05+p_ave->element_06+p_ave->element_07;

	p_ave->ave_value=p_ave->ave_value>>3;
}

/////// Find Vac Max Min ////////////////////////
_iq Find_max(_iq max_var, _iq max_value)
{
	if(max_var>max_value)max_value=max_var;
	return max_value;
}
_iq Find_min(_iq min_var, _iq min_value)
{
	if(min_var<min_value)min_value=min_var;
	return min_value;
}

_iq heavy_filter_w=_IQ(0.1);
#define w_I_heavy _IQ(0.2)
_iq tmp_V_H_heavy_filter=0;
_iq tmp_V_L_heavy_filter=0;
_iq tmp_V_B_heavy_filter=0;
_iq tmp_I_H_heavy_filter=0;
_iq tmp_I_L_heavy_filter=0;
void Call_HEAVY_FILTER_VI(void)
{


}
///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
void RESET_SIGNAL_CONDITION_PAR(void)
{
	p_pow.p_vol.mem.V_a=0;
	p_pow.p_vol.mem.V_a_filter=0;

    p_pow.p_vol.mem.V_b=0;
    p_pow.p_vol.mem.V_b_filter=0;

    p_pow.p_vol.mem.V_c=0;
    p_pow.p_vol.mem.V_c_filter=0;

    p_pow.p_vol.mem.V_dc=0;
    p_pow.p_vol.mem.V_dc_filter=0;

	p_pow.p_cur.mem.I_a=0;
	p_pow.p_cur.mem.I_a_filter=0;

    p_pow.p_cur.mem.I_b=0;
    p_pow.p_cur.mem.I_b_filter=0;

    p_pow.p_cur.mem.I_c=0;
    p_pow.p_cur.mem.I_c_filter=0;

    p_pow.p_cur.mem.I_dc=0;
    p_pow.p_cur.mem.I_dc_filter=0;

	p_pow.p_inv.mem.TEMP_LV=0;
	p_pow.p_inv.mem.TEMP_LV_filter=0;

	p_pow.p_inv.mem.TEMP_HV=0;
	p_pow.p_inv.mem.TEMP_HV_filter=0;

	p_pow.p_inv.mem.TEMP_TX=0;
	p_pow.p_inv.mem.TEMP_TX_filter=0;

	p_pow.p_inv.mem.TEMP_CH=0;
	p_pow.p_inv.mem.TEMP_CH_filter=0;

	V_BAT_CCCV=FORCE_V_L;
	del_V_BAT=del_V_BAT_01;
}
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
