

#ifndef __00_f28002x_Signal_Condition_H__
#define __00_f28002x_Signal_Condition_H__

#include <IQmathLib.h>
#include "01_f28002x_device.h"
#include "00_F28002x_Parameter.h"

void FIND_AVERAGE();
void Call_ADC_OFFSET(void);
void RESET_ADC_VAR(void);
void Call_FILTER_VI(void);
void Call_HEAVY_FILTER_VI(void);

void Call_FILTER_TEMP(void);
void Call_HEAVY_FILTER_TEMP(void);

void Call_SIM_VOL_ANGLE(void);
void INIT_ADC_OFF_GAIN(void);
void RESET_SIGNAL_CONDITION_PAR(void);

_iq Find_max();
_iq Find_min();

void Assign_ADC_RESULTS(void);

// 1.5K/(1.5K+47K)=0.0309278
// 0.0309278*100V=3.09278V = _IQ(0.9372)
// Kv=1/0.9372=1.067

#define GAIN_V_DC _IQ(1.067)
#define GAIN_V_A _IQ(2.63)
#define GAIN_V_B _IQ(2.63)
#define GAIN_V_C _IQ(2.63)

#define OFFSET_V_DC _IQ(0.0)
#define OFFSET_V_A _IQ(0.0)
#define OFFSET_V_B _IQ(0.0)
#define OFFSET_V_C _IQ(0.0)

#define GAIN_I_A _IQ(1.3)
#define GAIN_I_B _IQ(1.3)
#define GAIN_I_C _IQ(1.3)
#define GAIN_I_dc _IQ(1.3)

#define OFF_I_A _IQ(0.5)
#define OFF_I_B _IQ(0.5)
#define OFF_I_C _IQ(0.5)
#define OFF_I_dc _IQ(0.5)

#define GAIN_TEMP _IQ(3.3)
#define OFFSET_TEMP _IQ(0.0)

//#define actual_FORCE_V_H 220
#define act_FORCE_V_H 360
#define FORCE_V_H _IQmpyI32(VOLTAGE_to_IQ,(int16)act_FORCE_V_H)
#define act_FORCE_V_L 96
#define FORCE_V_L _IQmpyI32(VOLTAGE_to_IQ,(int16)act_FORCE_V_L)

#define actual_FORCE_I_H 5
#define macro_FORCE_I_H _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_FORCE_I_H)
#define actual_FORCE_I_L -20
#define macro_FORCE_I_L _IQmpyI32(VOLTAGE_to_IQ,(int16)actual_FORCE_I_L)

#define actual_FORCE_TEMP 12
#define macro_FORCE_TEMP _IQmpyI32(TEMP_to_IQ,(int16)actual_FORCE_TEMP)
// formula: V0=Vs/3.3V*(0.25V+abs_T*0.028V/deg C)
// abs_T in deg C=(V0_IQ*3.3V-0.25V)/0.028 and then divide by 100
#define K_IQ_to_V_AD22103KTZ _IQ(3.3)// SUPPLY 3.3V TO AD22103KTZ
#define K_T_AD22103KTZ _IQ(0.357)
#define T_AD22103KTZ_0 _IQ(0.25)

#define R_LOAD_LV _IQ(4.6) //1.6
#define R_LOAD_HV _IQ(83.3) //43.3

typedef struct{
	_iq element_00;
	_iq element_01;
	_iq element_02;
	_iq element_03;
	_iq element_04;
	_iq element_05;
	_iq element_06;
	_iq element_07;
	_iq element_new;
	_iq ave_value;
	}AVE_PAR_8;

#define ave_8_0 {_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0),_IQ(0.0)}

typedef struct{
		_iq x_value;
		_iq y_value;
		_iq w_break_ac;
		_iq w_break_dc;
		}LOW_PASS_FILTER;

#define filter_0 {0,0,_IQ(0.3),_IQ(0.3)}

//F280023 PROCESSOR
//////////////////////////////////////////////////
// PIN: 4: a6/c6 -> a6
// PIN: 5: a3/c5 -> a3
// PIN: 6: a2/c9 -> a2
// PIN: 7: a15/c7 -> a15
// PIN: 8: a11/c0 -> a11
// PIN: 9: a5/c2 -> a5
// PIN: 10: a1 -> a1
// PIN: 11: a0/c15 -> a0
/////////////////////////////////////////////////
// PIN: 14: a12/c1 -> c1
// PIN: 15: a7/c3 -> c3
// PIN: 16: a8/c11 -> c11
// PIN: 19: a4/c14 -> c14
// PIN: 20: a9/c8 -> c8
// PIN: 21: a10/c10 -> c10
/////////////////////////////////////////////////
struct ADC_REGISTERS{
    int16 PIN_04_a06_ADC_A_RESULT_0;
    int16 PIN_05_a03_ADC_A_RESULT_1;
    int16 PIN_06_a02_ADC_A_RESULT_2;
    int16 PIN_07_a15_ADC_A_RESULT_3;
    int16 PIN_08_a11_ADC_A_RESULT_4;
    int16 PIN_09_a05_ADC_A_RESULT_5;
    int16 PIN_10_a01_ADC_A_RESULT_6;
    int16 PIN_11_a00_ADC_A_RESULT_7;
    int16 PIN_14_c01_ADC_C_RESULT_0;
    int16 PIN_15_c03_ADC_C_RESULT_1;
    int16 PIN_16_c11_ADC_C_RESULT_2;
    int16 PIN_19_c14_ADC_C_RESULT_3;
    int16 PIN_20_c08_ADC_C_RESULT_4;
    int16 PIN_21_c10_ADC_C_RESULT_5;
    int16 PIN_XX_cXX_ADC_A_RESULT_6;
    int16 PIN_XX_cXX_ADC_A_RESULT_7;
    };

extern volatile struct ADC_REGISTERS ADC_RESULTS;


#endif
