
//
#include <01_f28002x_device.h>      // Header File Include File
#include "01_f28002x_examples.h"    // Examples Include File
#include <00_f28002x_PARAMETER.h>
//
// SetVREF - Set Vref mode. Function to select reference mode and offset trim.
// Offset trim for Internal VREF 3.3 is unique.  All other modes use the same
// offset trim. Also note that when the mode parameter is ADC_EXTERNAL, the
// ref parameter has no effect.
//
// In this device, the bandgaps are common for all the ADC instances,
// hence common Vref configuration needs to be done for all the ADCs. This
// API configures same Vref configuration for all the supported ADCs in the
// device.
//
void INIT_ADC(void)
{
    //
    // Setup VREF as internal
    //
    Set_ADC_VREF(ADC_ADCA, ADC_INTERNAL, ADC_VREF3P3);

    EALLOW;

    //
    // Set ADCCLK divider to /4
    //
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
    AdccRegs.ADCCTL2.bit.PRESCALE = 6;

    //
    // Set pulse positions to late
    //
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
    AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;

    //
    // Power up the ADC and then delay for 1 ms
    //
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    EDIS;

    DELAY_US(1000);

    INIT_ADC_SOC();
}

void Set_ADC_VREF(int module, int mode, int ref)
{
    Uint16 *offset, offsetShiftVal;

    if((mode == ADC_INTERNAL) && (ref == ADC_VREF3P3))
    {
        offsetShiftVal = 8U;         // Internal / 1.65v mode offset
    }
    else
    {
        offsetShiftVal = 0U;        // All other modes
    }

    //
    // Set up pointer to offset trim in OTP for ADCA.
    //
    offset = (Uint16 *)((Uint32)0x70166U);

    EALLOW;

    //
    // Get offset trim from OTP and write it to the register for ADCA.
    //
    AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = (*offset >> offsetShiftVal) & 0xFFU;

    //
    // Set up pointer to offset trim in OTP for ADCC.
    //
    offset = (Uint16 *)((Uint32)0x70167U);

    //
    // Get offset trim from OTP and write it to the register for ADCC.
    //
    AdccRegs.ADCOFFTRIM.bit.OFFTRIM = (*offset >> offsetShiftVal) & 0xFFU;

    //
    // Configure the reference mode for ADCA and ADCC (internal or external).
    //
    AnalogSubsysRegs.ANAREFCTL.bit.ANAREFASEL = mode;
    AnalogSubsysRegs.ANAREFCTL.bit.ANAREFCSEL = mode;

    //
    // Configure the reference voltage for ADCA and ADCC (3.3V or 2.5V).
    //
    AnalogSubsysRegs.ANAREFCTL.bit.ANAREFA2P5SEL = ref;
    AnalogSubsysRegs.ANAREFCTL.bit.ANAREFC2P5SEL = ref;

    EDIS;
}

#define TRIGSEL_ADCTRIG0_SOFTWARE 0
#define TRIGSEL_ADCTRIG1_CPU_TIMER_0 1
#define TRIGSEL_ADCTRIG2_CPU_TIMER_1 2
#define TRIGSEL_ADCTRIG3_CPU_TIMER_1 3
#define TRIGSEL_ADCTRIG4_XINT2 4
#define TRIGSEL_ADCTRIG5_PWM1_SOCA 5
#define TRIGSEL_ADCTRIG6_PWM1_SOCB 6
#define TRIGSEL_ADCTRIG7_PWM2_SOCA 7
#define TRIGSEL_ADCTRIG8_PWM2_SOCB 8
#define TRIGSEL_ADCTRIG9_PWM3_SOCA 9
#define TRIGSEL_ADCTRIG10_PWM3_SOCB 10
#define TRIGSEL_ADCTRIG11_PWM4_SOCA 11
#define TRIGSEL_ADCTRIG12_PWM4_SOCB 12
#define ACQPS_WINDOW 6

#define PWM4_INT_SOCA_ADC 11
#define PWM_TIMER_CNT_ZERO 1
#define PWM_TIMER_CNT_PRD 2
#define PWM_TIMER_CNT_ZERO_PRD_BOTH 3
#define PWM_TIMER_CNT_UP_CPM_A 4
#define PWM_TIMER_CNT_DN_CPM_A 5
#define PWM_TIMER_CNT_UP_CPM_B 6
#define PWM_TIMER_CNT_DN_CPM_B 7


#define ADC_CH_A_00 0
#define ADC_CH_A_01 1
#define ADC_CH_A_02 2
#define ADC_CH_A_03 3
#define ADC_CH_A_04 4
#define ADC_CH_A_05 5
#define ADC_CH_A_06 6
#define ADC_CH_A_07 7

#define ADC_CH_A_08 8
#define ADC_CH_A_09 9
#define ADC_CH_A_10 10
#define ADC_CH_A_11 11
#define ADC_CH_A_12 12
#define ADC_CH_A_13 13
#define ADC_CH_A_14 14
#define ADC_CH_A_15 15


#define ADC_CH_C_00 0
#define ADC_CH_C_01 1
#define ADC_CH_C_02 2
#define ADC_CH_C_03 3
#define ADC_CH_C_04 4
#define ADC_CH_C_05 5
#define ADC_CH_C_06 6
#define ADC_CH_C_07 7

#define ADC_CH_C_08 8
#define ADC_CH_C_09 9
#define ADC_CH_C_10 10
#define ADC_CH_C_11 11
#define ADC_CH_C_12 12
#define ADC_CH_C_13 13
#define ADC_CH_C_14 14
#define ADC_CH_C_15 15

#define ADCINT_SOC_7 7

void INIT_ADC_SOC(void)
{
//////////////////////////////////////////////////
// PIN: 4: a6/c6 -> a6
// PIN: 5: a3/c5 -> a3
// PIN: 6: a2/c9 -> a2
// PIN: 7: a15/c7 -> a15
// PIN: 8: a11/c0 -> a11
// PIN: 9: a5/c2 -> a5
// PIN: 10: a1 -> a1
// PIN: 11: a0/c15 -> a0
/////////////////////////////////////////////////
// PIN: 14: a12/c1 -> c1
// PIN: 15: a7/c3 -> c3
// PIN: 16: a8/c11 -> c11
// PIN: 19: a4/c14 -> c14
// PIN: 20: a9/c8 -> c8
// PIN: 21: a10/c10 -> c10
/////////////////////////////////////////////////
    EALLOW;

    AdcaRegs.ADCSOC0CTL.bit.CHSEL = ADC_CH_A_06;     // SOC0 will convert pin ADCINA0
    AdcaRegs.ADCSOC0CTL.bit.ACQPS = ACQPS_WINDOW;     // Sample window is 10 SYSCLK cycles
    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;   // Trigger on ePWM1 SOCA

    AdcaRegs.ADCSOC1CTL.bit.CHSEL = ADC_CH_A_03;
    AdcaRegs.ADCSOC1CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC2CTL.bit.CHSEL = ADC_CH_A_02;
    AdcaRegs.ADCSOC2CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC3CTL.bit.CHSEL = ADC_CH_A_15;
    AdcaRegs.ADCSOC3CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC4CTL.bit.CHSEL = ADC_CH_A_11;
    AdcaRegs.ADCSOC4CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC5CTL.bit.CHSEL = ADC_CH_A_05;
    AdcaRegs.ADCSOC5CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC6CTL.bit.CHSEL = ADC_CH_A_01;
    AdcaRegs.ADCSOC6CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC6CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdcaRegs.ADCSOC7CTL.bit.CHSEL = ADC_CH_A_00;
    AdcaRegs.ADCSOC7CTL.bit.ACQPS = ACQPS_WINDOW;
    AdcaRegs.ADCSOC7CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

///////////////////////////////////////////////////////////
////////////////// ADC -C /////////////////////////////////
///////////////////////////////////////////////////////////
    AdccRegs.ADCSOC0CTL.bit.CHSEL = ADC_CH_C_01;
    AdccRegs.ADCSOC0CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC0CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdccRegs.ADCSOC1CTL.bit.CHSEL = ADC_CH_C_03;
    AdccRegs.ADCSOC1CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC1CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdccRegs.ADCSOC2CTL.bit.CHSEL = ADC_CH_C_11;
    AdccRegs.ADCSOC2CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC2CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdccRegs.ADCSOC3CTL.bit.CHSEL = ADC_CH_C_14;
    AdccRegs.ADCSOC3CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC3CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdccRegs.ADCSOC4CTL.bit.CHSEL = ADC_CH_C_08;
    AdccRegs.ADCSOC4CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC4CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;

    AdccRegs.ADCSOC5CTL.bit.CHSEL = ADC_CH_C_10;
    AdccRegs.ADCSOC5CTL.bit.ACQPS = ACQPS_WINDOW;
    AdccRegs.ADCSOC5CTL.bit.TRIGSEL = TRIGSEL_ADCTRIG5_PWM1_SOCA;
/////////////////////////////////////////////////////////////

    AdcaRegs.ADCINTSEL1N2.bit.INT1CONT=1;
    AdcaRegs.ADCINTSEL1N2.bit.INT1E=1;
    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL=ADCINT_SOC_7;
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS=1; // EOC after conversion complete NOT@SOC
/////////////////////////////////////////////////////////////

    EDIS;
}
// End of File
