
#include <01_f28002x_device.h>
#include "01_f28002x_examples.h"

//
// Defines
//

#define ADC_EXT_REF_TSSLOPE  (*(int16_t *)((uintptr_t)0x701B2)) //Slope of temperature sensor

#define ADC_EXT_REF_TSOFFSET (*(int16_t *)((uintptr_t)0x701B3)) //Temperature offset


//
// Globals
//
int16_t tempSensor_tempSlope;
int16_t tempSensor_tempOffset;
float32_t tempSensor_scaleFactor;

//
// InitTempSensor - Initialize the temperature sensor by powering up the
//                  sensor, loading the calibration values from OTP to RAM,
//                  and recording the intended VREFHI voltage.
//                  Note: This function doesn't support VREFLO != 0.0V,
//                  but this could be implemented if desired.
//
void InitTempSensor(float vrefhi_voltage)
{
    EALLOW;

    //
    //power up the the temperature sensor
    //
    AnalogSubsysRegs.TSNSCTL.bit.ENABLE = 1;

    //
    //delay to allow the sensor to power up
    //
    DELAY_US(1000);


    //
    //need to remember VREFHI voltage so that sensor readings can be scaled
    //to match 2.5V values used for calibration data.
    //
    tempSensor_scaleFactor = vrefhi_voltage;

    EDIS;
}

//
// GetTemperatureC - This function uses the reference data stored in OTP to
//                   convert the raw temperature sensor reading into degrees C
//
int16_t GetTemperatureC(uint16_t sensorSample)
{
    float32_t temp;
    temp = (float32_t)((tempSensor_scaleFactor / 2.5F) * sensorSample);

    //
    //Read the Slope and Offset from OTP
    //
    tempSensor_tempSlope = ADC_EXT_REF_TSSLOPE;
    tempSensor_tempOffset = ADC_EXT_REF_TSOFFSET;

    return((int16_t)((((int32_t)temp - tempSensor_tempOffset) * 4096) /
            tempSensor_tempSlope));

}

//
// GetTemperatureK - This function uses the reference data stored in OTP to
//                   convert the raw temperature sensor reading into degrees K
//
int16_t GetTemperatureK(uint16_t sensorSample)
{
    float32_t temp;

   //
   // Read temp sensor slope and offset locations from OTP and convert
   //
    tempSensor_tempSlope = ADC_EXT_REF_TSSLOPE;
    tempSensor_tempOffset = ADC_EXT_REF_TSOFFSET;
   temp = (float32_t)sensorSample * (tempSensor_scaleFactor / 2.5F);
   return((int16_t)(((((int32_t)temp - tempSensor_tempOffset) * 4096) /
           tempSensor_tempSlope) + 273));
}

//
// End of file
//
