
#define ESC_BASE         (0x00050000)

#define DATA_LINK_LAYER_STATUS                  (0x00000110 / 2)

#define APPLICATION_LAYER_CONTROL_OFFSET        (0x00000120 / 2)
#define APPLICATION_LAYER_STATUS_OFFSET         (0x00000130 / 2)
#define APPLICATION_LAYER_EVENTMASK_OFFSET      (0x00000204 / 2)
#define APPLICATION_LAYER_EVENT_REQUEST_OFFSET  (0x00000220 / 2)

#define MII_CONTROL_AND_STATUS_OFFSET               (0x00000510 / 2)
#define MII_PHY_ADDRESS_AND_REGISTER_ADDRESS_OFFSET (0x00000512 / 2)
#define MII_PHY_DATA_OFFSET                         (0x00000514 / 2)
#define MII_ACCESS_STATE_OFFSET                     (0x00000516 / 2)
#define MII_PHY_PORTS_STATUS_OFFSET                 (0x00000518 / 2)

#define INPUT_OFFSET     (0x00001100 / 2)
#define OUTPUT_OFFSET    (0x00001400 / 2)


MEMORY
{
   DATA_LINK_LAYER_STATUS_REF          : origin = (ESC_BASE + DATA_LINK_LAYER_STATUS), length = 0x0000001

   APPLICATION_LAYER_CONTROL_REG       : origin = (ESC_BASE + APPLICATION_LAYER_CONTROL_OFFSET), length = 0x0000001
   APPLICATION_LAYER_STATUS_REG        : origin = (ESC_BASE + APPLICATION_LAYER_STATUS_OFFSET), length = 0x0000001
   APPLICATION_LAYER_EVENTMASK_REG     : origin = (ESC_BASE + APPLICATION_LAYER_EVENTMASK_OFFSET), length = 0x0000002
   APPLICATION_LAYER_EVENT_REQUEST_REG : origin = (ESC_BASE + APPLICATION_LAYER_EVENT_REQUEST_OFFSET), length = 0x0000002

   MII_CONTROL_AND_STATUS_REG               : origin = (ESC_BASE + MII_CONTROL_AND_STATUS_OFFSET), length = 0x0000001
   MII_PHY_ADDRESS_AND_REGISTER_ADDRESS_REG : origin = (ESC_BASE + MII_PHY_ADDRESS_AND_REGISTER_ADDRESS_OFFSET), length = 0x0000001
   MII_PHY_DATA_REG                         : origin = (ESC_BASE + MII_PHY_DATA_OFFSET), length = 0x0000001
   MII_ACCESS_STATE_REG                     : origin = (ESC_BASE + MII_ACCESS_STATE_OFFSET), length = 0x0000001
   MII_PHY_PORTS_STATUS_REG                 : origin = (ESC_BASE + MII_PHY_PORTS_STATUS_OFFSET), length = 0x0000001

   ETHERCAT_PDO_INPUTS		: origin = (ESC_BASE + INPUT_OFFSET), length = 0x0000010
   ETHERCAT_PDO_OUTPUTS 	: origin = (ESC_BASE + OUTPUT_OFFSET), length = 0x0000010
}

SECTIONS
{
   DataLinkLayerStatusRegFile    : > DATA_LINK_LAYER_STATUS_REF, type=NOINIT

   ApplicationLayerControlRegFile       : > APPLICATION_LAYER_CONTROL_REG, type=NOINIT
   ApplicationLayerStatusRegFile        : > APPLICATION_LAYER_STATUS_REG, type=NOINIT
   ApplicationLayerEventMaskRegFile     : > APPLICATION_LAYER_EVENTMASK_REG, type=NOINIT
   ApplicationLayerEventRequestRegFile  : > APPLICATION_LAYER_EVENT_REQUEST_REG, type=NOINIT

   MIIControlAndStatusRegFile             : > MII_CONTROL_AND_STATUS_REG, type=NOINIT
   MIIPHYAddressAndRegisterAddressRegFile : > MII_PHY_ADDRESS_AND_REGISTER_ADDRESS_REG, type=NOINIT
   MIIPHYDataRegFile                      : > MII_PHY_DATA_REG, type=NOINIT
   MIIAccessStateRegFile                  : > MII_ACCESS_STATE_REG, type=NOINIT
   MIIPHYPortStatusRegFile                : > MII_PHY_PORTS_STATUS_REG, type=NOINIT

   EthercatPdoInputsFile   : > ETHERCAT_PDO_INPUTS, type=NOINIT
   EthercatPdoOutputsFile  : > ETHERCAT_PDO_OUTPUTS, type=NOINIT
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/

