/*
 * PhoenixonControls_AD5547.h
 *
 *  Created on: 2018. 5. 20.
 *      Author: BGKim
 */

#ifndef PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5547_H_
#define PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5547_H_


#define AD5547_REFERENCE_VOLTAGE			(float)(5.0)
#define AD5547_RESOLUTION					(float)(65536.0)
#define AD5547_ZERO_VOLTAGE_BIPOLAR		    (float)(32768.0)
#define AD5547_ZERO_VOLTAGE_UNIPOLAR		(float)(0.0)
#define AD5547_BIPOLAR_GAIN					(float)(AD5547_REFERENCE_VOLTAGE / (AD5547_RESOLUTION / 2.0))
#define AD5547_UNIPOLAR_GAIN				(float)(AD5547_REFERENCE_VOLTAGE / AD5547_RESOLUTION)

#define AD5547_A0_SET						DSP_GPIO66_O_DAC_A0_SET()
#define AD5547_A0_CLEAR						DSP_GPIO66_O_DAC_A0_CLEAR()

#define AD5547_A1_SET						DSP_GPIO67_O_DAC_A1_SET()
#define AD5547_A1_CLEAR						DSP_GPIO67_O_DAC_A1_CLEAR()

#define AD5547_VOLTAGE_N_RS_SET				DSP_GPIO86_O_DAC_V_N_RESET_SET()
#define AD5547_VOLTAGE_N_RS_CLEAR			DSP_GPIO86_O_DAC_V_N_RESET_CLEAR()

#define AD5547_CURRENT_N_RS_SET				DSP_GPIO87_O_DAC_I_N_RESET_SET()
#define AD5547_CURRENT_N_RS_CLEAR			DSP_GPIO87_O_DAC_I_N_RESET_CLEAR()

#define AD5547_FINE_CURRENT_N_RS_SET		DSP_GPIO68_O_DAC_FINE_I_N_RESET_SET()
#define AD5547_FINE_CURRENT_N_RS_CLEAR		DSP_GPIO68_O_DAC_FINE_I_N_RESET_CLEAR()

#define AD5547_VOLTAGE_N_WR_ADDRESS			(Uint32)(0x100014)   //y0 = (Uint16)(0x100010) 00X0b DAC_LDAC_FINE_I
#define AD5547_CURRENT_N_WR_ADDRESS			(Uint32)(0x100019)   //y1 = (Uint16)(0x100011) 00X1b ADC CNVST
#define AD5547_FINE_CURRENT_N_WR_ADDRESS	(Uint32)(0x100018)   //y2 = (Uint16)(0x100014) 01X0b DAC_nWR_V
                                                                 //y3 = (Uint16)(0x100015) 01X1b DAC_LDAC_V
#define AD5547_VOLTAGE_LDAC_ADDRESS			(Uint32)(0x100015)   //y4 = (Uint16)(0x100018) 10X0b DAC_LDAC_nWR_FINE_I
#define AD5547_CURRENT_LDAC_ADDRESS			(Uint32)(0x10001C)   //y5 = (Uint16)(0x100019) 10X1b DAC_nWR_I
#define AD5547_FINE_CURRENT_LDAC_ADDRESS	(Uint32)(0x100010)   //y6 = (Uint16)(0x10001C) 11X0b DAC_LDAC_I
                                                                 //y7 = (Uint16)(0x10001D) 11X1b

#define AD5547_VOTAGE_WIRTE_DATA(X)			{DSP_EmifWrite(AD5547_VOLTAGE_N_WR_ADDRESS, X);}
#define AD5547_CURRENT_WIRTE_DATA(X)		{DSP_EmifWrite(AD5547_CURRENT_N_WR_ADDRESS, X);}
#define AD5547_FINE_CURRENT_WIRTE_DATA(X)	{DSP_EmifWrite(AD5547_FINE_CURRENT_N_WR_ADDRESS, X);}

#define AD5547_VOTAGE_LDAC					{DSP_EmifWrite(AD5547_VOLTAGE_LDAC_ADDRESS, 0xFFFF);}
#define AD5547_CURRENT_LDAC					{DSP_EmifWrite(AD5547_CURRENT_LDAC_ADDRESS, 0xFFFF);}
#define AD5547_FINE_CURRENT_LDAC			{DSP_EmifWrite(AD5547_FINE_CURRENT_LDAC_ADDRESS, 0xFFFF);}

typedef enum
{
	AD5547_A,
	AD5547_NON_OUTPUT,
	AD5547_ALL_OUTPUT,
	AD5547_B
}E_AD5547_OUTPUT_SELECT;

typedef enum
{
	AD5547_VOLTAGE,
	AD5547_INTEGRATION_VOLTAGE,
	AD5547_CURRENT_MASTER,
	AD5547_CURRENT_SLAVE,
	AD5547_FINE_CURRENT_MASTER,
	AD5547_FINE_CURRENT_SLAVE,
	AD5547_ALL_CHANNEL
}E_AD5547_CHANNEL_SELECT;

void AD5547_Init(void);
Uint16 AD5547_Reset(void);
Uint16 AD5547_OutputSelect(E_AD5547_OUTPUT_SELECT e_Port);
//Uint16 AD5547_OutputLoad(E_AD5547_CHANNEL_SELECT e_Channel);
Uint16 AD5547_Write(E_AD5547_CHANNEL_SELECT e_Channel, Uint16 ui_Data);

#endif /* PHOENIXON_CONTROLS_CPU_INCLUDE_PHOENIXONCONTROLS_AD5547_H_ */
