//###########################################################################
//
// FILE:    hw_memmap.h
//
// TITLE:   Macros defining the memory map of the CM4.
//
//###########################################################################
// $Copyright:
// Copyright (C) 2016 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

#ifndef HW_MEMMAP_H
#define HW_MEMMAP_H
#define  AESW_BASE                0x4004AC00U    //AES Wrapper Registers
#define  AES_BASE                 0x4004A000U    //AES Registers
#define  NVIC_BASE                0xE000E000U    //NVIC Registers
#define  CPUTIMER0_BASE           0x40084000U    //CPUTIMER0 Registers
#define  CPUTIMER1_BASE           0x40084010U    //CPUTIMER1 Registers
#define  CPUTIMER2_BASE           0x40084020U    //CPUTIMER2 Registers
#define  GCRC_BASE                0x40040000U    //GCRC Registers
#define  NMI_BASE                 0x40081000U    //NMI Registers
#define  WD_BASE                  0x40080000U    //WD Registers
#define  CMSYSCTL_BASE            0x400FC000U    //CM System Control Registers
#define  DMPU_BASE                0x400CC000U    //DMPU Registers
#define  EMPU_BASE                0x400CD000U    //EMPU Registers
#define  UDMA_BASE                0x400FF000U    //UDMA Registers
#define  GPIODATA_BASE            0x40083000U    //GPIO Data Registers
#define  GPIODATAREAD_BASE        0x40083100U    //GPIO Data Read Registers
#define  I2C0_BASE                0x40020000U    //I2C0 Registers
#define  SSI0_BASE                0x40008000U    //SSI0 Registers
#define  UART0_BASE               0x4000C000U    //UART0 Registers
#define  IPC_CMTOCPU1_BASE        0x400FD000U    //CPU1TOCM  IPC Registers
#define  IPC_CMTOCPU2_BASE        0x400FD080U    //CPU2TOCM IPC Registers
#define  FLASH0CTRL_BASE          0x400FA000U    // Flash control registers
#define  FLASH0ECC_BASE           0x400FA600U    // Flash ECC error log registers
#define  CMMEMCFG_BASE            0x400FE000U    //CM Memory Configuration Registers
#define  CMMEMORYERROR_BASE       0x400FE400U    //CM Memory Error Registers
#define  CMMEMORYDIAGERROR_BASE   0x400FE800U    //CM Memory Diagnostics and Error Registers
#define  EMAC_BASE                0x400C0000U    //Ethernet MAC Registers
#define  EMAC_SS_BASE             0x400C2000U    //Ethernet MAC Sub-System Registers
#define  CANA_BASE                0x40070000U    //CANA Registers
#define  CANB_BASE                0x40074000U    //CANB Registers
#define  MCAN_SS_BASE             0x4007C400U    //MCAN Sub-System Registers
#define  MCAN_BASE                0x4007C600U    //MCAN Registers
#define  MCAN_ERROR_BASE          0x4007C800U    //MCAN Error Registers
#define  DCSM_Z1_BASE             0x40085000U    //DCSM Zone1 Registers
#define  DCSM_Z2_BASE             0x40085100U    //DCSM Zone2 Registers
#define  DCSMCOMMON_BASE          0x40085180U    //DCSM Common Registers
#define  ESC_SS_BASE              0x400AFC00U    //Ethercat Sub-System Registers
#define  ESC_SS_CONFIG_BASE       0x400AFE00U    //Ethercat Sub-System configuration Registers
#define  C1RAM_BASE               0x1FFFC000U    //C1RAM
#define  C0RAM_BASE               0x1FFFE000U    //C0RAM
#define  S0RAM_BASE               0x20000000U    //S0RAM
#define  S1RAM_BASE               0x20004000U    //S1RAM
#define  S2RAM_BASE               0x20008000U    //S2RAM
#define  S3RAM_BASE               0x2000C000U    //S3RAM
#define  E0RAM_BASE               0x20010000U    //E0RAM
#define  CPU1TOCMMSGRAM0_BASE     0x20080000U    //CPU1 TO CM MSGRAM0
#define  CPU1TOCMMSGRAM1_BASE     0x20080800U    //CPU1 TO CM MSGRAM1
#define  CMTOCPU1MSGRAM0_BASE     0x20082000U    //CM TO CPU1 MSGRAM0
#define  CMTOCPU1MSGRAM1_BASE     0x20082800U    //CM TO CPU1 MSGRAM1
#define  CPU2TOCMMSGRAM0_BASE     0x20084000U    //CPU2 TO CM MSGRAM0
#define  CPU2TOCMMSGRAM1_BASE     0x20084800U    //CPU2 TO CM MSGRAM1
#define  CMTOCPU2MSGRAM0_BASE     0x20086000U    //CM TO CPU2 MSGRAM0
#define  CMTOCPU2MSGRAM1_BASE     0x20086800U    //CM TO CPU2 MSGRAM1
#define  MCAN0_BASE               0x40078000U    //MCAN0 Registers
#define  USB0_BASE                0x40050000U    //USB0 Registers

#endif // HW_MEMMAP_H
