/*
 * Struct.h
 *
 *  Created on: Aug 18, 2022
 *      Author: 210055498
 */

#ifndef SOURCE_STRUCT_H_
#define SOURCE_STRUCT_H_

typedef enum ModeEnum {
   STANDBY_MODE = 0,
   RUN_MODE,
   FAULT_MODE
} ModeTypedef;

typedef enum StateEnum {
   STANDBY_STATE = 0,
   RUN_STATE,
   FAULT_STATE
} StateTypedef;

typedef enum SubStatesEnum {
   ENTRY = 0,
   IN,
   EXIT
} SubStatesTypedef;

struct AdcGainStruct {
   float      Iind;
   float      Vout;
   float      Vdc;
   float      Iext;
   float      BodeExc;
};

union FaultCodeUnion {
   struct {                                    // Bit
      unsigned long   OvercurrentInd    :  1;  //   0
      unsigned long   DcOvervoltage     :  1;  //   1
      unsigned long   DcOutUndervoltage :  1;  //   2
      unsigned long   DesatA            :  1;  //   3
      unsigned long   DesatB            :  1;  //   4
      unsigned long   DesatC            :  1;  //   5
      unsigned long   CAN_Comm          :  1;  //   6
      unsigned long   reserved          : 25;  //   7 .. 31
   } Bit;
   struct {
      unsigned int    I0;
      unsigned int    I1;
   } Int;
   unsigned long      All;
};

union DiscreteIOUnion {
   struct {                              //  Bit
      unsigned int   Bit0          :  1; //    0
      unsigned int   Bit1          :  1; //    1
      unsigned int   Bit2          :  1; //    2
      unsigned int   Bit3          :  1; //    3
      unsigned int   reserved      : 12; //    4 .. 15
   } Bit;
   unsigned int      All;
};

struct VLPI_Def {
   float Kp;
   float Ki;
   float UL;
   float LL;
};

struct PI_Def {
   float Kp;
   float Ki;
};

struct Cal_struct {
   float             CoreClockFreq;            // core clock frequency in Hz
   float             TimerClockFreq;           // timer clock frequency in Hz
   float             SwitchingFreq;            // switching frequency in Hz
   float             BackgroundFreq;           // background task frequency in Hz
   float             DeadTime;                 // PWM dead time
   float             InductorCurrentRange;
   float             VoltageOutputRange;
   float             ExtCurrentRange;
   float             VdcRange;
   float             OversamplingRate;         // Oversampling rate
   float             LedPeriod;                // Blinking LED period
   float             CanTimeout;               // Can Timeout shutdowns converter

   float             IndOvercurrent;           // Inductor overcurrent threshold
   float             IndOvercurrentTimeout;    // Inductor overcurrent timeout
   float             DcOvervoltage;            // Dc link overvoltage threshold
   float             DcOvervoltageTimeout;     // Dc link overvoltage timeout
   float             DcOutUndervoltage;        // Dc output undervoltage threshold
   float             DcOutUndervoltageTimeout; // Dc output undervoltage timeout

   float             TempFreqLPF_def;

   struct PI_Def     CurrZRegDef;

   struct {
      long           N;
      float          X0;
      float          Step;
      float          Data[21];
   } RtdTempLookup1D1StructDef;

   float             GuiGain[5][4];
};

#endif /* SOURCE_STRUCT_H_ */
