/*
 * Func.h
 *
 *  Created on: Feb 20, 2019
 *      Author: 212315224
 */

#ifndef FUNC_H_
#define FUNC_H_

struct abc {
   float a;
   float b;
   float c;
};

struct xy {
   float x;
   float y;
};

struct xyz {
   float x;
   float y;
   float z;
};

struct dq {
   float d;
   float q;
};

struct dqo {
   float d;
   float q;
   float o;
};

struct phase {
   float Theta;
   float Sin;
   float Cos;
};

struct Dfilt1 {
   float out;
   float Zminus1;
   float D0;
   float N1;
   float N0;
};

struct Dfilt2 {
   float out;
   float Zminus1;
   float Zminus2;
   float D1;
   float D0;
   float N2;
   float N1;
   float N0;
};

struct ZP1Struct {
   float Z;
   float P;
};

struct ZP2Struct {
   float Z1;
   float P1;
   float Z2;
   float P2;
};

struct Filt2Struct {
   float fc;
   float Q;
};

struct BGF2Struct {
   float fc;
   float Qn;
   float Qd;
};


struct VLPI_Data {
   float  Error;       /*  0 */
   float  FF;          /*  4 */
   float  ErrorPrev;   /*  8 */
   float  Kp;          /* 12 */
   float  Ki;          /* 16 */
   float  Integral;    /* 20 */
   float  UL;          /* 24 */
   float  LL;          /* 28 */
   float* Tsmp;        /* 30 */
};

struct Lookup1D1Struct {
   long          N;
   float         X0;
   float         Step;
   float         InvStep;
   float*        Data;
};


void  abc2xy(struct abc* in, struct xy* out);
void  abc2xyz(struct abc* in, struct xyz* out);
void  xy2abc(struct xy* in, struct abc* out);
void  xy2dq(struct xy* in, struct dq* out, struct phase* theta);
void  dq2xy(struct dq* in, struct xy* out, struct phase* theta);
void  xyz2dqo(struct xyz* in, struct dqo* out, struct phase* Phase);
void  svm(struct abc* in, struct abc* out);

void  LPFilt1stCoef(struct Dfilt1*, float, float);
void  HPFilt1stCoef(struct Dfilt1*, float, float);
void  ZPFilt1stCoef(struct Dfilt1*, struct ZP1Struct*, float);
void  HPFilt2ndCoef(struct Dfilt2*, struct Filt2Struct*, float);
void  NFilt2ndCoef(struct Dfilt2*, struct Filt2Struct*, float);
void  LPFilt2ndCoef(struct Dfilt2*, struct Filt2Struct*, float);
void  BGFilt2ndCoef(struct Dfilt2*, struct BGF2Struct*, float);
void  BPFilt2ndCoef(struct Dfilt2*, struct Filt2Struct*, float);
void  ZPZPFilt2ndCoef(struct Dfilt2*, struct ZP2Struct*, float);
float DigFilt1(float, struct Dfilt1*);
float DigFilt2(float, struct Dfilt2*);
float Lookup1D1(float input, struct Lookup1D1Struct*);
float VLPI(struct VLPI_Data*);

#endif /* FUNC_H_ */
