

/**
 * main.c
 */

#include <C2_Proto.h>
#include <math.h>
#include <string.h>
#include <F2837xD_device.h>
#include <F28x_Project.h>
#include <F2837xD_EPwm.h>


extern unsigned int RamFuncsRunStart;
extern unsigned int RamFuncsLoadStart;
extern unsigned int RamFuncsLoadSize;
extern unsigned int RamConstRunStart;
extern unsigned int RamConstLoadStart;
extern unsigned int RamConstLoadSize;

int main(void)
{
   // Disable CPU interrupts
   DINT;
   // Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

#ifdef RELEASE
   memcpy(&RamFuncsRunStart, &RamFuncsLoadStart, (size_t)&RamFuncsLoadSize);
   memcpy(&RamConstRunStart, &RamConstLoadStart, (size_t)&RamConstLoadSize);
#endif

   InitSysCtrl();
   // Initialize the PIE (Peripheral Interrupt Expansion) control registers to their default state.
   // The default state is all PIE interrupts disabled and flags are cleared.
   // This function is found in the F2837xD_PieCtrl.c file.
   InitPieCtrl();
   // Initialize the PIE vector table with pointers to the default TI shell Interrupt Service Routines (ISR).
   // The shell ISR routines are found in F2837xD_DefaultIsr.c.
   // This function is found in F2837xD_PieVect.c.
   InitPieVectTable();

   InitDataRam();
//   InitVars();
//   InitPie();

//   // Enable global Interrupts and higher priority real-time debug events:
//   EINT;
//   ERTM;

   while(1) {
      asm ("      ESTOP0"); // Halt core since it is not used.
   }
}

// RAMD1 memory block contains uninitialized variables and heap space
// RAMD1 : origin = 0x00B800, length = 0x000800    // .ebss .esysmem
// Initialize it to 0 since TI compiler does not do it by default
void InitDataRam()
{
   unsigned int p;

   for (p = 0xB800; p < 0xC000; p++) {
     *(unsigned int*)p = 0;
   }
}

void InitVars()
{
    return;
}
