MEMORY
{
PAGE 0 :  /* Program Memory */
   RAMM0           : origin = 0x000122, length = 0x0002DE   // .cinit .pinit .switch
/*   RAMLS0        : origin = 0x008000, length = 0x000800
 *   RAMLS1        : origin = 0x008800, length = 0x000800
 *   RAMLS2        : origin = 0x009000, length = 0x000800
 *   RAMLS3        : origin = 0x009800, length = 0x000800
 *   RAMLS4        : origin = 0x00A000, length = 0x000800
 */
   RAMLS012345     : origin = 0x008000, length = 0x003000   // .text
   RESET           : origin = 0x3FFFC0, length = 0x000002

#ifdef __TI_COMPILER_VERSION__
   #if __TI_COMPILER_VERSION__ >= 20012000
GROUP {      /* GROUP memory ranges for crc/checksum of entire flash */
   #endif
#endif
   /* BEGIN is used for the "boot to Flash" bootloader mode   */
   BEGIN             : origin = 0x080000, length = 0x000002

   /* Flash sectors */
   FLASHA            : origin = 0x080002, length = 0x001FFE	/* on-chip Flash */
//   FLASHB            : origin = 0x082000, length = 0x002000	/* on-chip Flash */
//   FLASHC            : origin = 0x084000, length = 0x002000	/* on-chip Flash */
//   FLASHD            : origin = 0x086000, length = 0x002000	/* on-chip Flash */
//   FLASHE            : origin = 0x088000, length = 0x008000	/* on-chip Flash */
   FLASHBCDE         : origin = 0x082000, length = 0x00E000 /* on-chip Flash */
   FLASHF            : origin = 0x090000, length = 0x008000	/* on-chip Flash */
   FLASHG            : origin = 0x098000, length = 0x008000	/* on-chip Flash */
   FLASHH            : origin = 0x0A0000, length = 0x008000	/* on-chip Flash */
   FLASHI            : origin = 0x0A8000, length = 0x008000	/* on-chip Flash */
   FLASHJ            : origin = 0x0B0000, length = 0x008000	/* on-chip Flash */
   FLASHK            : origin = 0x0B8000, length = 0x002000	/* on-chip Flash */
   FLASHL            : origin = 0x0BA000, length = 0x002000	/* on-chip Flash */
   FLASHM            : origin = 0x0BC000, length = 0x002000	/* on-chip Flash */
   FLASHN            : origin = 0x0BE000, length = 0x001FF0	/* on-chip Flash */
   FLASHN_DO_NOT_USE : origin = 0x0BFFF0, length = 0x000010    /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */
   
#ifdef __TI_COMPILER_VERSION__
  #if __TI_COMPILER_VERSION__ >= 20012000
}  crc(_ccs_flash_checksum, algorithm=C28_CHECKSUM_16)
  #endif
#endif

PAGE 1 : /* Data Memory */
   BOOT_RSVD       : origin = 0x000002, length = 0x000120
   RAMM1           : origin = 0x000400, length = 0x000400    // .stack
   RAMD0           : origin = 0x00B000, length = 0x000800    // .econst
   RAMD1           : origin = 0x00B800, length = 0x000800    // .ebss .esysmem

   RAMGS0          : origin = 0x00C000, length = 0x001000
   RAMGS1          : origin = 0x00D000, length = 0x001000
   RAMGS2          : origin = 0x00E000, length = 0x001000
   RAMGS3          : origin = 0x00F000, length = 0x001000
   RAMGS4          : origin = 0x010000, length = 0x001000
   RAMGS5          : origin = 0x011000, length = 0x001000
   RAMGS6          : origin = 0x012000, length = 0x001000
   RAMGS7          : origin = 0x013000, length = 0x001000
//   RAMGS8          : origin = 0x014000, length = 0x001000  // Assigned to Core 2
//   RAMGS9          : origin = 0x015000, length = 0x001000
//   RAMGS10         : origin = 0x016000, length = 0x001000
//   RAMGS11         : origin = 0x017000, length = 0x001000
//   RAMGS12         : origin = 0x018000, length = 0x001000
//   RAMGS13         : origin = 0x019000, length = 0x001000
//   RAMGS14         : origin = 0x01A000, length = 0x001000
   RAMGS15         : origin = 0x01B000, length = 0x001000

   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400

}

SECTIONS
{
   /* Allocate program areas: */
   .reset         : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */
   codestart      : > BEGIN,     PAGE = 0, ALIGN(4)
   .cinit         : > FLASHA,    PAGE = 0, ALIGN(4)  /* Initilized global and static variables */
   .pinit         : > FLASHA,    PAGE = 0, ALIGN(4)  /* Tables of constructor, C++ only, otherwise empty */
   .switch        : > FLASHA,    PAGE = 0, ALIGN(4)  /* Tables for switch statements */
   .text          : > FLASHBCDE, PAGE = 0, ALIGN(4)  /* Executable code and constants */
    /* Initalized sections go in Flash */
   .econst        : > FLASHG,    PAGE = 0, ALIGN(4)  /* Constant variables */
                      RUN = RAMD0,
                      LOAD_START(_RamConstLoadStart),
                      LOAD_SIZE(_RamConstLoadSize),
                      LOAD_END(_RamConstLoadEnd),
                      RUN_START(_RamConstRunStart),
                      RUN_SIZE(_RamConstRunSize),
                      RUN_END(_RamConstRunEnd)

#ifdef __TI_COMPILER_VERSION__
   #if __TI_COMPILER_VERSION__ >= 15009000
    .TI.ramfunc : {}  LOAD = FLASHF,                  /* Executable code that runs from RAM */
                      RUN = RAMLS012345,
                      LOAD_START(_RamFuncsLoadStart),
                      LOAD_SIZE(_RamFuncsLoadSize),
                      LOAD_END(_RamFuncsLoadEnd),
                      RUN_START(_RamFuncsRunStart),
                      RUN_SIZE(_RamFuncsRunSize),
                      RUN_END(_RamFuncsRunEnd),
                      PAGE = 0, ALIGN(4)
   #else
   ramfuncs :         LOAD = FLASHF,
                      RUN = RAMLS01234,
                      LOAD_START(_RamFuncsLoadStart),
                      LOAD_SIZE(_RamFuncsLoadSize),
                      LOAD_END(_RamFuncsLoadEnd),
                      RUN_START(_RamFuncsRunStart),
                      RUN_SIZE(_RamFuncsRunSize),
                      RUN_END(_RamFuncsRunEnd),
                      PAGE = 0, ALIGN(4)
   #endif
#endif

   /* Allocate uninitalized data sections: */
   .stack         : > RAMM1      PAGE = 1  /* Obviusly stack space, size set in project C2000Linker-> Basic Options */
   .ebss          : > RAMD1      PAGE = 1  /* Uninitilized global and static variables, WARNING: not initilized to zero */
   .esysmem       : > RAMD1      PAGE = 1  /* Heap space, Memory for malloc type functions */
//   Filter_RegsFile     : > RAMGS0,      PAGE = 1
   ramgs15        : > RAMGS15,   PAGE = 1

   SHARERAMGS0    : > RAMGS0,    PAGE = 1
   SHARERAMGS1    : > RAMGS1,    PAGE = 1

   /* The following section definitions are required when using the IPC API Drivers */ 
   GROUP : > CPU1TOCPU2RAM, PAGE = 1
   {
      PUTBUFFER
      PUTWRITEIDX
      GETREADIDX
   }

   GROUP : > CPU2TOCPU1RAM, PAGE = 1
   {
      GETBUFFER :    TYPE = DSECT
      GETWRITEIDX :  TYPE = DSECT
      PUTREADIDX :   TYPE = DSECT
   }

   /* crc/checksum section configured as COPY section to avoid including in executable */
   .TI.memcrc          : type = COPY
}
//===========================================================================
// End of file.
//===========================================================================

