/*
 * Vars.h
 *
 *  Created on: Jan 21, 2019
 *      Author: 212315224
 */

#ifdef LOCATE_VARS
   #define LOCATION
#else
   #define LOCATION extern
#endif

#define TWO_PI           6.2831853

LOCATION float           Tsmp;
LOCATION float           Tsmpb;
LOCATION float           Tadc;
LOCATION float           SwitchingFrequency;
LOCATION float           PeriodCounterFloat;
LOCATION unsigned int    PeriodCounter;
LOCATION unsigned int    AdcCounter;
LOCATION unsigned int    DeadTimeCounts;
LOCATION int             PeriodCounterMax;
LOCATION int             PeriodCounterMin;
LOCATION unsigned int    BackgroundCounter;
LOCATION unsigned int    BackgroundCounts;
LOCATION unsigned int    AdcIntCounter;
LOCATION volatile int*   pAdcBuffer;

LOCATION volatile unsigned int BackgroundRunFlag;

LOCATION union FaultCodeUnion  FaultCode;
LOCATION union DiscreteIOUnion DiscreteIO;

LOCATION unsigned int      SoftwareVersion;

LOCATION StateTypedef      State;
LOCATION StateTypedef      StatePrev;
LOCATION SubStatesTypedef  SubState;
LOCATION ModeTypedef       Mode;
LOCATION ModeTypedef       ModeCmd;
LOCATION SubStatesTypedef  SubMode;

LOCATION struct abc        IindAbc;
LOCATION struct abc        VoutAbc;
LOCATION struct xy         VcmdXy;
LOCATION float             Iext;
LOCATION float             Vdc;
LOCATION float             VdcOut;
LOCATION float             BodeExc;
LOCATION float             TemprCaseRaw;
LOCATION float             TemprARaw;
LOCATION float             TemprBRaw;
LOCATION float             TemprCRaw;

LOCATION float             InvVdc;
LOCATION struct xyz        IindXyz;
LOCATION struct dqo        IindDqo;
LOCATION float             Imag;

LOCATION struct AdcGainStruct  Gain;

LOCATION struct VLPI_Data  CurrZReg;

LOCATION struct abc      VcmdAbc;
LOCATION float           VmagCmd;
LOCATION float           Frequency;
LOCATION struct phase    Theta;
LOCATION float           VoutZCmd;
LOCATION struct abc      DutyAbc;
LOCATION unsigned int    Duty1CMPACounts;
LOCATION unsigned int    Duty2CMPACounts;
LOCATION unsigned int    Duty3CMPACounts;
LOCATION unsigned int    BodeSwitch;
LOCATION float           BodeX;
LOCATION float           BodeY;
LOCATION float           BodeDistMag;

LOCATION unsigned int    RunConverter;
LOCATION unsigned int    nStopStartPrev;
LOCATION unsigned int    MasterReset;

LOCATION int    IndOvercurrentCounter;
LOCATION int    IndOvercurrentCounts;
LOCATION int    VdcOvervoltageCounter;
LOCATION int    VdcOvervoltageCounts;
LOCATION int    VdcOutUndervoltageCounter;
LOCATION int    VdcOutUndervoltageCounts;

LOCATION unsigned int    GuiCmdCounter;
LOCATION unsigned int    GuiCmdTimeoutCount;

LOCATION unsigned int    LedCounter;
LOCATION unsigned int    LedCounts;
LOCATION unsigned int    RunTimeCounter;

LOCATION unsigned int    DacValue[3];

LOCATION struct Lookup1D1Struct TempPhA_LookupTbl;
LOCATION struct Lookup1D1Struct TempPhB_LookupTbl;
LOCATION struct Lookup1D1Struct TempPhC_LookupTbl;
LOCATION struct Dfilt1 TempPhA_LPF;
LOCATION struct Dfilt1 TempPhB_LPF;
LOCATION struct Dfilt1 TempPhC_LPF;
LOCATION int           ECap1Result;
LOCATION int           ECap2Result;
LOCATION int           ECap3Result;
LOCATION float         ECap1Frequency;
LOCATION float         ECap2Frequency;
LOCATION float         ECap3Frequency;
LOCATION float         TempPhA;
LOCATION float         TempPhB;
LOCATION float         TempPhC;

LOCATION float           GuiGainBitPerUnit[5][4];

LOCATION unsigned long RunTime;

#if defined(LOCATE_VARS)

struct Cal_struct Cal =
{
      200.0e6,         // float CoreClockFreq; 0
      100.5e6,         // float TimerClockFreq; 2
       20.0e3,         // float SwitchingFreq; 4
      100.0,           // float BackgroundFreq 6
      500.0e-9,        // float DeadTime 8
      214.2857142,     // float InductorCurrentRange 10
      500.0,           // float VoltageOutputRange 12    TODO use correct range values
      840.3361345,     // float LoadCurrentRange 14
      512,             // float VdcRange 16
        4.0,           // float OversamplingRate 18
        1.0,           // float LedPeriod; 20
        5.0,           // float CanTimeout; 22

      200.0,           // float IndOvercurrent; 24
       30.0e-6,        // float IndOvercurrentTimeout; 3 cycles of 10us 26
      420.0,           // float DcOvervoltage; 28
       50.0e-6,        // float DcOvervoltageTimeout; 5 cycles of 10us 30
      180.0,           // float DcOutUndervoltage; 32
       50.0e-6,        // float DcOutUndervoltageTimeout; 5 cycles of 10us 34

       2.0,            // float TempFreqLPF_def;

     {  3.5,           // struct PI_Def CurrZRegDef: Kp 36
       35.0},          //                            Ki 38

     {                 // struct RtdTempLookup1D1StructDef;
       21,             // unsigned long  N;
        5.0e3,         // float          X0;
        1.25e3,        // float          Step;
         {             // float          Data[21];
           1.8,
           7.2,
          12.7,
          18.2,
          23.7,
          28.5,
          33.1,
          37.7,
          42.3,
          46.9,
          51.8,
          57.2,
          62.7,
          68.2,
          73.7,
          81.6,
          90.3,
          99.0,
         114.5,
         134.4,
         170.8
        },
     },

   //    0        1        2        3
   //  15:0     31:16    47:32    63:48
    {{1000.0,  1000.0,  1000.0,  1000.0},    // GuiGain [0][0..3]
     {1000.0,  1000.0,  1000.0,  1000.0},    // GuiGain [1][0..3]
     {1000.0,  1000.0,  1000.0,  1000.0},    // GuiGain [2][0..3]
     {1000.0,  1000.0,  1000.0,  1000.0},    // GuiGain [3][0..3]
     {32767.0, 1000.0,  1000.0,  1000.0}}    // GuiGain [4][0..3]
};

#pragma DATA_SECTION(AdcBuffer,"ramgs15");
volatile int  AdcBuffer[4 * 12]; // allocated for 4x oversampling of 8 variables

#else

extern const struct Cal_struct      Cal;
extern volatile int  AdcBuffer[];

#endif /* LOCATE_VARS */

