MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode */
   BEGIN           : origin = 0x000000, length = 0x000002
   RAMM0           : origin = 0x000122, length = 0x0002DE    // .cinit .pinit .switch
//   RAMLS0          : origin = 0x008000, length = 0x000800
//   RAMLS1          : origin = 0x008800, length = 0x000800
//   RAMLS2          : origin = 0x009000, length = 0x000800
//   RAMLS3          : origin = 0x009800, length = 0x000800
//   RAMLS4          : origin = 0x00A000, length = 0x000800
//   RAMLS5          : origin = 0x00A800, length = 0x000800
   RAMLS012345     : origin = 0x008000, length = 0x003000    // .text

   RESET           : origin = 0x3FFFC0, length = 0x000002

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x000120
   RAMM1           : origin = 0x000400, length = 0x000400    // .stack
   RAMD0           : origin = 0x00B000, length = 0x000800    // .const
   RAMD1           : origin = 0x00B800, length = 0x000800    // .ebss .esysmem
   
   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
   
}


SECTIONS
{
   codestart        : > BEGIN,       PAGE = 0

#ifdef __TI_COMPILER_VERSION__
   #if __TI_COMPILER_VERSION__ >= 15009000
    .TI.ramfunc : {} > RAMM0,        PAGE = 0
   #else
   ramfuncs         : > RAMM0,       PAGE = 0
   #endif
#endif   

   .text            : > RAMLS012345, PAGE = 0  /* Executable code and constants */
   .cinit           : > RAMD0,       PAGE = 1  /* Initilized global and static variables */
   .pinit           : > RAMM0,       PAGE = 0  /* Tables of constructor, C++ only, otherwise empty */
   .switch          : > RAMM0,       PAGE = 0  /* Tables for switch statements */
   .reset           : > RESET,       PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM1,       PAGE = 1  /* Obviusly stack space, size set in project C2000Linker-> Basic Options */
   .ebss            : > RAMD1,       PAGE = 1  /* Uninitilized global and static variables, WARNING: not initilized to zero */
   .esysmem         : > RAMD1,       PAGE = 1  /* Heap space, Memory for malloc type functions */
   .econst          : > RAMD0,       PAGE = 1  /* Constant variables */
   
   /* The following section definitions are required when using the IPC API Drivers */ 
    GROUP : > CPU2TOCPU1RAM, PAGE = 1 
    {
        PUTBUFFER 
        PUTWRITEIDX 
        GETREADIDX 
    }
    
    GROUP : > CPU1TOCPU2RAM, PAGE = 1
    {
        GETBUFFER :    TYPE = DSECT
        GETWRITEIDX :  TYPE = DSECT
        PUTREADIDX :   TYPE = DSECT
    }  
    
}
/*
//===========================================================================
// End of file.
//===========================================================================
*/
