/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//! \file   ~sw/modules/dcbus/src/32b/dcbus.c
//! \brief  Portable C fixed point code.  These functions define the 
//!         DC bus (DCBUS) estimation module
//!
//! (C) Copyright 2012, Texas Instruments, Inc.


// **************************************************************************
// the includes

#include "sv/dcbus.h"

// **************************************************************************
// the defines


// **************************************************************************
// the globals


// **************************************************************************
// the functions

DCBUS_Handle DCBUS_init(void *pMemory,const size_t numBytes)
{
  DCBUS_Handle handle;
  DCBUS_Obj   *obj;

  if(numBytes < sizeof(DCBUS_Obj))
    return((DCBUS_Handle)NULL);

  // assign the handle
  handle = (DCBUS_Handle)pMemory;

  // assign a pointer
  obj = (DCBUS_Obj *)handle;

  // initialize the low pass filter object
  obj->lpfHandle = FILTER_FO_init(&obj->lpf,sizeof(FILTER_FO_Obj));

  return(handle);
} // end of DCBUS_init() function


void DCBUS_setParams(DCBUS_Handle handle,
                     const _iq dcBusVoltage_pu,
                     const _iq dcBusVoltage_min_pu,
                     const _iq dcBusVoltage_max_pu)
{

  DCBUS_setDcBusVoltage_pu(handle,dcBusVoltage_pu);
  DCBUS_setDcBusVoltage_min_pu(handle,dcBusVoltage_min_pu);
  DCBUS_setDcBusVoltage_max_pu(handle,dcBusVoltage_max_pu);

  return;
} // end of DCBUS_setParams() function


void DCBUS_setLpfParams(DCBUS_Handle handle,
                        const _iq b0,const _iq b1,const _iq a1,
                        const _iq x1,const _iq y1)
{
  DCBUS_Obj *obj = (DCBUS_Obj *)handle;

  // set the low pass filter parameters
  FILTER_FO_setDenCoeffs(obj->lpfHandle,a1);
  FILTER_FO_setNumCoeffs(obj->lpfHandle,b0,b1);
  FILTER_FO_setInitialConditions(obj->lpfHandle,x1,y1);

  return;
} // end of DCBUS_setLpfParams() function


// end of file
