

/**
 * main.c
 */

#include <stdio.h>
#include <stdint.h>

#define LV_MATH_UDIV255(x) ((uint32_t)(((uint64_t) (x) * 0x8081) >> 0x17))

int main(void)
{
    printf("\nTesting udiv255\n");

    const uint32_t two = 2;
    const uint32_t iterationMax = 1000000000;

    uint32_t base;
    for (base = 1; base < iterationMax; base*=two) {
        printf("%lu,%lu\n", base, LV_MATH_UDIV255 (base));
    }

    return 0;
}
