#include <stdio.h>
#include <stdint.h>

#include "F2837xD_device.h"
#include "F2837xD_GlobalPrototypes.h"

#define RFFT_STAGES     11
#define RFFT_SIZE       (1 << RFFT_STAGES)

float buffer [RFFT_SIZE];
uint16_t table_size;
volatile int DummyIndex = 0;


#ifdef Version2
#pragma CODE_SECTION(RFFT_f32_sincostable_TMU0, ".TI.ramfunc")
void RFFT_f32_sincostable_TMU0(float *CosSinBuf, uint16_t FFTStages)
{
    float delta_phi = 0.007813;
    uint16_t k = 1;

    float *dst = CosSinBuf;

        float phi = delta_phi;

    for (k=0; k<384; k++)
    {
            *dst++ = phi;
            *dst++ = __cospuf32(phi);
            *dst++ = __sinpuf32(phi);

            phi += delta_phi;
    }
    table_size = dst - CosSinBuf;
}
#elif

#pragma CODE_SECTION(RFFT_f32_sincostable_TMU0, ".TI.ramfunc")
void RFFT_f32_sincostable_TMU0(float *CosSinBuf, uint16_t FFTStages)
{
    float delta_phi = 0.125;   // pi/4 = 1/8 * two_pi
    uint16_t k = 1;

    float *dst = CosSinBuf;

    for (uint16_t i = 3; i <= FFTStages; i++)
    {
        float phi = delta_phi;

        for (uint16_t j=1; j <= k; j ++)
        {
            *dst++ = phi;
            *dst++ = __cospuf32(phi);
//            DummyIndex++;
            *dst++ = __sinpuf32(phi);

            phi += delta_phi;
        }

//        *dst++ = 0.0;
//        *dst++ = 1.0;

        k = (k * 2) + 1;

        delta_phi = delta_phi * 0.5;
    }

    table_size = dst - CosSinBuf;
}
#endif

int main(void)
{
    InitSysCtrl();

    RFFT_f32_sincostable_TMU0(buffer, RFFT_STAGES);

    for (int i=0; i < table_size; i++)
        printf("%d,%12.11f\n", i, buffer[i]);
    printf("%d\n", DummyIndex);

	return 0;
}
