/**
 -------------------------------------------------------------------------------------------------------------------------------
This file provides boilerplate templates for interfacing with the GUI Composer framework.
For further information, see the available options under the Help main menu in the Designer.
-------------------------------------------------------------------------------------------------------------------------------
**/

import { GcUtils } from './components/@ti/gc-core-assets/lib/GcUtils';
import { GcConsole } from './components/@ti/gc-core-assets/lib/GcConsole';
import { bindingRegistry } from './components/@ti/gc-core-databind/lib/CoreDatabind';
import { GcWidget } from './components/@ti/gc-widget-base/lib/GcWidget';
import { ActionRegistry } from './components/@ti/gc-widget-menu/lib/ActionRegistry';

const console = new GcConsole('myapp'); // creates a console instance with name 'myapp'
GcConsole.setLevel('myapp', 4);         // enable console output for myapp console instance
console.info('index.js is loaded...');

/**
 -------------------------------------------------------------------------------------------------------------------------------
Boilerplate code for databinding

Add custom computed value databindings here, using the following method:

syntax: bindingRegistry.bind(targetBinding, sourceBinding, [getter], [setter]);
    param targetBinding - single binding string or expression, or array of binding strings for multi-way binding.
    param sourceBinding - single binding string or expression, or array of binding strings for multi-way binding.
    param getter - (optional) - custom getter function for computing the targetBinding value(s) based on sourceBinding value(s).
    param setter - (optional) - custom setter function for computing the sourceBinding value(s) based on targetBinding value(s).

  (async () => {
      await bindingRegistry.waitForModelReady('widget');        // widget model, a built-in model
      await bindingRegistry.waitForModelReady('targetModelId'); // target model, gc-model-program, gc-model-streaming, etc...
      bindingRegistry.bind('widget.inputWidgetId.value', 'model.targetModelId.targetVariable');
      bindingRegistry.bind('widget.labelWidgetId.label', 'widget.inputWidgetId.value');
   })();
-------------------------------------------------------------------------------------------------------------------------------
**/

// Example code:
//
// (async () => {
//     /* Wait for widget and target models to be ready */
//     await bindingRegistry.waitForModelReady('widget');
//     await bindingRegistry.waitForModelReady('targetModelId');
//
//     /* A simple computed values based on simple expression */
//     bindingRegistry.bind('widget.id.propertyName', "targetModelId.targetVariable == 1 ? 'binding is one' : 'binding is not one'");
//
//     /* A custom two-way binding with custom getter and setter functions */
//     /* (setter is optional and getter only indicates one-way binding)   */
//     bindingRegistry.bind('widget.id.propertyName', 'targetModelId.targetVariable',
//         value => { return value*5/9 + 32; }, /* getter */
//         value => { return (value-32)*9/5; }  /* setter */
//     );
//
//     /* 1 to n bindings */
//     bindingRegistry.bind('widget.date.value', {
//         /* Dependant bindings needed in order to compute the date, in name/value pairs */
//             weekday: 'widget.dayOfWeek.selectedLabel',
//             day: 'widget.dayOfMonth.value',
//             month: 'widget.month.selectedLabel',
//             year: 'widget.year.value'
//         },
//         /* Getter for date computation */
//         function(values) {
//             /* compute and return the string value to bind to the widget with id 'date' */
//             return values.weekday + ', ' + values.month + ' ' + values.day + ', ' + values.year;
//         }
//     );
// })();


/**
 -------------------------------------------------------------------------------------------------------------------------------
Boilerplate code for working with webcomponents in the application
-------------------------------------------------------------------------------------------------------------------------------
**/

const init = () => {
    // Add menubar product-name-clicked event listener
    GcWidget.querySelector('gc-widget-menubar').then(menubar => {
        menubar.addEventListener('product-name-clicked', () => window.open('https://dev.ti.com/gc', 'gc'));
    });
};
document.readyState === 'complete' ? init() : document.addEventListener('DOMContentLoaded', init);


/**
 -------------------------------------------------------------------------------------------------------------------------------
Boilerplate code for registering menu and toolbar action callback
-------------------------------------------------------------------------------------------------------------------------------
**/

ActionRegistry.registerAction('cmd_exit', {
    run() { GcUtils.isNW ? require('nw.gui').Window.get().close() : window.close(); }
});