#include "c2000BoardSupport.h"
#include "F2837xD_device.h"
#include "F2837xD_Examples.h"
#include "F2837xD_GlobalPrototypes.h"
#include "rtwtypes.h"
#include "TwoPhaseForStuck.h"
#include "TwoPhaseForStuck_private.h"

void config_ADCB_SOC1()
{
  EALLOW;
  AdcbRegs.ADCSOC1CTL.bit.CHSEL = 3;   /* Set SOC1 channel select to ADCIN3*/
  AdcbRegs.ADCSOC1CTL.bit.TRIGSEL = 5;
  AdcbRegs.ADCSOC1CTL.bit.ACQPS = 19;  /* Set SOC1 S/H Window to 20 ADC Clock Cycles*/
  AdcbRegs.ADCINTSEL1N2.bit.INT1E = 1; /* Enabled/Disable ADCINT1 interrupt*/
  AdcbRegs.ADCINTSEL1N2.bit.INT1SEL = 1;/* Setup EOC1 to trigger ADCINT1*/
  AdcbRegs.ADCINTSEL1N2.bit.INT1CONT = 0;/* Enable/Disable ADCINT1 Continuous mode*/
  AdcbRegs.ADCINTSOCSEL1.bit.SOC1 = 0; /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC0()
{
  EALLOW;
  AdcaRegs.ADCSOC0CTL.bit.CHSEL = 2;   /* Set SOC0 channel select to ADCIN2*/
  AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 5;
  AdcaRegs.ADCSOC0CTL.bit.ACQPS = 19;  /* Set SOC0 S/H Window to 20 ADC Clock Cycles*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1; /* Enabled/Disable ADCINT1 interrupt*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;/* Setup EOC0 to trigger ADCINT1*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;/* Enable/Disable ADCINT1 Continuous mode*/
  AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 0; /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCB_SOC0()
{
  EALLOW;
  AdcbRegs.ADCSOC0CTL.bit.CHSEL = 2;   /* Set SOC0 channel select to ADCIN2*/
  AdcbRegs.ADCSOC0CTL.bit.TRIGSEL = 7;
  AdcbRegs.ADCSOC0CTL.bit.ACQPS = 19;  /* Set SOC0 S/H Window to 20 ADC Clock Cycles*/
  AdcbRegs.ADCINTSEL1N2.bit.INT2E = 1; /* Enabled/Disable ADCINT2 interrupt*/
  AdcbRegs.ADCINTSEL1N2.bit.INT2SEL = 0;/* Setup EOC0 to trigger ADCINT2*/
  AdcbRegs.ADCINTSEL1N2.bit.INT2CONT = 0;/* Enable/Disable ADCINT2 Continuous mode*/
  AdcbRegs.ADCINTSOCSEL1.bit.SOC0 = 0; /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void InitAdcA()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_A = 1;
  AdcaRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCA, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcB()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_B = 1;
  AdcbRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCB, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcbRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}
