/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>

#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

void scia_echoback_init(void);
void scia_fifo_init(void);
void scia_xmit(int a);
void scia_msg(char *msg);

/*
 *  ======== taskFxn ========
 */
Void taskFxn(UArg a0, UArg a1)
{
    Uint16 ReceivedChar = 'T';
    //System_printf("enter taskFxn()\n");

    while(1){
        Task_sleep(100);

        scia_xmit(ReceivedChar);

        // Wait for inc character
        //
//        while(SciaRegs.SCIFFRX.bit.RXFFST !=1)
//        {
//         //
//         // wait for XRDY =1 for empty state
//         //
//        }

//        //
//        // Get character
//        //
//        ReceivedChar = SciaRegs.SCIRXBUF.all;

        if(SciaRegs.SCIFFRX.bit.RXFFST ==1)
        {
            ReceivedChar = SciaRegs.SCIRXBUF.all;
        }

        //System_printf("taskFxn(). Running\r\n");
        //System_flush(); /* force SysMin output to console */

    }
}

/*
 *  ======== main ========
 */
Int main()
{ 
    Task_Handle task;
    Error_Block eb;
    char *msg;

    InitSysCtrl();
//

//
    InitSciaGpio();
//
//
    DINT;
    InitPieCtrl();
    IER = 0x0000;
    IFR = 0x0000;

    InitPieVectTable();
//
    scia_fifo_init();      // Initialize the SCI FIFO
    scia_echoback_init();  // Initalize SCI for echoback
//
//    msg = "\r\n\n\nHello World!\0";
//    scia_msg(msg);


    //System_printf("enter main()\n");

    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);
    if (task == NULL) {
        //System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    BIOS_start();    /* does not return */
    return(0);
}


//
// scia_echoback_init - Test 1,SCIA  DLB, 8-bit word, baud rate 0x0103,
// default, 1 STOP bit, no parity
//
void scia_echoback_init()
{
    //
    // Note: Clocks were turned on to the SCIA peripheral
    // in the InitSysCtrl() function
    //

    //
    // 1 stop bit,  No loopback, No parity,8 char bits, async mode,
    // idle-line protocol
    //
    SciaRegs.SCICCR.all =0x0007;

    //
    // enable TX, RX, internal SCICLK, Disable RX ERR, SLEEP, TXWAKE
    //
    SciaRegs.SCICTL1.all =0x0003;

    SciaRegs.SCICTL2.bit.TXINTENA = 0;
    SciaRegs.SCICTL2.bit.RXBKINTENA = 0;

    //
    // 9600 baud @LSPCLK = 22.5MHz (90 MHz SYSCLK)
    //
    SciaRegs.SCIHBAUD    =0x0001;
    SciaRegs.SCILBAUD    =0x0024;

    SciaRegs.SCICTL1.all =0x0023;  // Relinquish SCI from Reset
    SciaRegs.SCIFFRX.bit.RXFIFORESET=1;
}

//
// scia_xmit - Transmit a character from the SCI
//
void scia_xmit(int a)
{
    while (SciaRegs.SCIFFTX.bit.TXFFST != 0)
    {

    }
    SciaRegs.SCITXBUF=a;
}

//
// scia_msg -
//
void scia_msg(char * msg)
{
    int i;
    i = 0;
    while(msg[i] != '\0')
    {
        scia_xmit(msg[i]);
        i++;
    }
}

//
// scia_fifo_init - Initalize the SCI FIFO
//
void scia_fifo_init()
{
    SciaRegs.SCIFFTX.all=0xE040;
    SciaRegs.SCIFFRX.all=0x2044;
    SciaRegs.SCIFFCT.all=0x0;
}





