#include "m3_core.h"
#include "mw_force_no_optimization.h"
#include "arm_cortex_m_multitasking.h"
/* Re-entrant function for multi-tasking: arm_cortex_m_call_thread_with_context_switch*/

__asm  ("    .sect \".text:arm_cortex_m_call_thread_with_context_switch\"\n"
        "    .clink\n"
        "    .thumbfunc arm_cortex_m_call_thread_with_context_switch\n"
        "    .thumb\n"
        "    .align 4\n"
        "    .global arm_cortex_m_call_thread_with_context_switch\n"
        "arm_cortex_m_call_thread_with_context_switch:");
#if (defined(__FPU_PRESENT) && (__FPU_PRESENT == 1)) && (defined(__FPU_USED) && (__FPU_USED == 1))
__asm ("     TST  LR, #0x10");
__asm ("     IT EQ");
__asm ("     VMOVEQ S0, S0");
#endif
__asm ("     PUSH {R0, R1}");
__asm ("     SUB SP, SP, #0x20");
__asm ("     ADR R0,Call_isr_routine_in_thread_mode");
__asm ("     STR R0,[SP, #24]");
__asm ("     MOV R0,#0x01000000");
__asm ("     STR R0,[SP, #28]");
__asm ("     MVNS R0,#0x6");
__asm ("     MOV LR, R0");
__asm ("     BX LR");
__asm ("Call_isr_routine_in_thread_mode:");
__asm ("     POP {R0, R1}");
__asm ("     BLX R0");
__asm ("     ISB");
__asm ("     SVC #0");
__asm ("Unknown_Execution:");
__asm ("     B Unknown_Execution");

/* SVC Interrupt service routine to restore the context: SVC_Handler*/

__asm  ("    .sect \".text:SVC_Handler\"\n"
        "    .clink\n"
        "    .thumbfunc SVC_Handler\n"
        "    .thumb\n"
        "    .align 4\n"
        "    .global SVC_Handler\n"
        "SVC_Handler:");
#if (defined(__FPU_PRESENT) && (__FPU_PRESENT == 1)) && (defined(__FPU_USED) && (__FPU_USED == 1))
__asm ("     TST  LR, #0x10");
__asm ("     IT EQ");
__asm ("     VMOVEQ S0, S0");
#endif
__asm ("     TST LR, #0x4");
__asm ("     ITE EQ");
__asm ("     MRSEQ R0, MSP");
__asm ("     MRSNE R0, PSP");
__asm ("     LDR R1, [R0, #24]");
__asm ("     LDRB.W R0, [R1, #-2]");
__asm ("     CBZ R0, svc_service_0");
__asm ("     B Unknown_SVC_Request");
__asm ("svc_service_0:");
#if (defined(__FPU_PRESENT) && (__FPU_PRESENT == 1)) && (defined(__FPU_USED) && (__FPU_USED == 1))
__asm ("     TST LR, #0x10");
__asm ("     ITE EQ");
__asm ("     ADDEQ SP, SP, #104");
__asm ("     ADDNE SP, SP, #32");
#else
__asm ("     ADD SP, SP, #32");
#endif
__asm ("     POP {R0, R1}");
__asm ("     MSR APSR_nzcvq, R0");
__asm ("     BX R1");
__asm ("Unknown_SVC_Request:");
__asm ("     B Unknown_SVC_Request");

