/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: ert_main.c
 *
 * Code generated for Simulink model 'm3_core'.
 *
 * Model version                  : 1.91
 * Simulink Coder version         : 8.11 (R2016b) 25-Aug-2016
 * C/C++ source code generated on : Thu Sep 27 00:27:58 2018
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: ARM Compatible->ARM Cortex
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "m3_core.h"
#include "rtwtypes.h"
#include <ext_work.h>
#include <ext_svr.h>
#include <ext_share.h>
#include <updown.h>

volatile int IsrOverrun = 0;
boolean_T isRateRunning[3] = { 0, 0, 0 };

boolean_T need2runFlags[3] = { 0, 0, 0 };

void rt_OneStep(void)
{
  boolean_T eventFlags[3];
  int_T i;

  /* Check base rate for overrun */
  if (isRateRunning[0]++) {
    IsrOverrun = 1;
    isRateRunning[0]--;                /* allow future iterations to succeed*/
    return;
  }

  /*
   * For a bare-board target (i.e., no operating system), the rates
   * that execute this base step are buffered locally to allow for
   * overlapping preemption.  The generated code includes function
   * writeCodeInfoFcn() which sets the rates
   * that need to run this time step.  The return values are 1 and 0
   * for true and false, respectively.
   */
  m3_core_SetEventsForThisBaseStep(eventFlags);
  IntMasterEnable();
  m3_core_step0();

  /* Get model outputs here */
  IntMasterDisable();
  isRateRunning[0]--;
  for (i = 1; i < 3; i++) {
    if (eventFlags[i]) {
      if (need2runFlags[i]++) {
        IsrOverrun = 1;
        need2runFlags[i]--;            /* allow future iterations to succeed*/
        break;
      }
    }
  }

  for (i = 1; i < 3; i++) {
    if (isRateRunning[i]) {
      /* Yield to higher priority*/
      return;
    }

    if (need2runFlags[i]) {
      isRateRunning[i]++;
      IntMasterEnable();

      /* Step the model for subrate "i" */
      switch (i)
      {
       case 1 :
        m3_core_step1();

        /* Get model outputs here */
        break;

       case 2 :
        m3_core_step2();

        /* Get model outputs here */
        break;

       default :
        break;
      }

      IntMasterDisable();
      need2runFlags[i]--;
      isRateRunning[i]--;
    }
  }

  rtExtModeCheckEndTrigger();
}

int main(void)
{
  volatile boolean_T runModel = 1;
  float modelBaseRate = 0.05;
  float systemClock = 75;
  IntMasterDisable();
  concerto_init_board();
  rtmSetErrorStatus(m3_core_M, 0);

  /* initialize external mode */
  rtParseArgsForExtMode(0, NULL);
  m3_core_initialize();
  IntMasterEnable();

  /* External mode */
  rtSetTFinalForExtMode(&rtmGetTFinal(m3_core_M));
  rtExtModeCheckInit(3);

  {
    boolean_T rtmStopReq = false;
    rtExtModeWaitForStartPkt(m3_core_M->extModeInfo, 3, &rtmStopReq);
    if (rtmStopReq) {
      rtmSetStopRequested(m3_core_M, true);
    }
  }

  rtERTExtModeStartMsg();
  SysCtlDelay(1000000);
  IntMasterDisable();
  configureSysTick(modelBaseRate, systemClock);
  runModel =
    (rtmGetErrorStatus(m3_core_M) == (NULL)) && !rtmGetStopRequested(m3_core_M);
  IntMasterEnable();
  IntMasterEnable();
  while (runModel) {
    /* External mode */
    {
      boolean_T rtmStopReq = false;
      rtExtModeOneStep(m3_core_M->extModeInfo, 3, &rtmStopReq);
      if (rtmStopReq) {
        rtmSetStopRequested(m3_core_M, true);
      }
    }

    runModel =
      (rtmGetErrorStatus(m3_core_M) == (NULL)) && !rtmGetStopRequested(m3_core_M);
  }

  rtExtModeShutdown(3);

  /* Disable rt_OneStep() here */

  /* Terminate model */
  m3_core_terminate();
  SysCtlDelay(1000000);
  IntMasterDisable();
  return 0;
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
