/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: m3_core.c
 *
 * Code generated for Simulink model 'm3_core'.
 *
 * Model version                  : 1.91
 * Simulink Coder version         : 8.11 (R2016b) 25-Aug-2016
 * C/C++ source code generated on : Thu Sep 27 00:27:58 2018
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: ARM Compatible->ARM Cortex
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "m3_core.h"
#include "m3_core_private.h"
#include "m3_core_dt.h"
#define m3_core_BlockingMode           (false)
#define m3_core_LocalIPPort_           (25555.0)
#define m3_core_LocalIPPort__p         (-1.0)
#define m3_core_RemoteIPPort_          (25000.0)

/* Block signals (auto storage) */
B_m3_core_T m3_core_B;

/* Block states (auto storage) */
DW_m3_core_T m3_core_DW;

/* Real-time model */
RT_MODEL_m3_core_T m3_core_M_;
RT_MODEL_m3_core_T *const m3_core_M = &m3_core_M_;
static void rate_monotonic_scheduler(void);

/*
 * Set which subrates need to run this base step (base rate always runs).
 * This function must be called prior to calling the model step function
 * in order to "remember" which rates need to run this base step.  The
 * buffering of events allows for overlapping preemption.
 */
void m3_core_SetEventsForThisBaseStep(boolean_T *eventFlags)
{
  /* Task runs when its counter is zero, computed via rtmStepTask macro */
  eventFlags[1] = ((boolean_T)rtmStepTask(m3_core_M, 1));
  eventFlags[2] = ((boolean_T)rtmStepTask(m3_core_M, 2));
}

/*
 *   This function updates active task flag for each subrate
 * and rate transition flags for tasks that exchange data.
 * The function assumes rate-monotonic multitasking scheduler.
 * The function must be called at model base rate so that
 * the generated code self-manages all its subrates and rate
 * transition flags.
 */
static void rate_monotonic_scheduler(void)
{
  /* Compute which subrates run during the next base time step.  Subrates
   * are an integer multiple of the base rate counter.  Therefore, the subtask
   * counter is reset when it reaches its limit (zero means run).
   */
  (m3_core_M->Timing.TaskCounters.TID[1])++;
  if ((m3_core_M->Timing.TaskCounters.TID[1]) > 1) {/* Sample time: [0.1s, 0.0s] */
    m3_core_M->Timing.TaskCounters.TID[1] = 0;
  }

  (m3_core_M->Timing.TaskCounters.TID[2])++;
  if ((m3_core_M->Timing.TaskCounters.TID[2]) > 4) {/* Sample time: [0.25s, 0.0s] */
    m3_core_M->Timing.TaskCounters.TID[2] = 0;
  }
}

/* Model step function for TID0 */
void m3_core_step0(void)               /* Sample time: [0.05s, 0.0s] */
{
  {                                    /* Sample time: [0.05s, 0.0s] */
    rate_monotonic_scheduler();
  }

  /* External mode */
  rtExtModeUploadCheckTrigger(3);
  rtExtModeUpload(0, m3_core_M->Timing.taskTime0);

  /* signal main to stop simulation */
  {                                    /* Sample time: [0.05s, 0.0s] */
    if ((rtmGetTFinal(m3_core_M)!=-1) &&
        !((rtmGetTFinal(m3_core_M)-m3_core_M->Timing.taskTime0) >
          m3_core_M->Timing.taskTime0 * (DBL_EPSILON))) {
      rtmSetErrorStatus(m3_core_M, "Simulation finished");
    }

    if (rtmGetStopRequested(m3_core_M)) {
      rtmSetErrorStatus(m3_core_M, "Simulation finished");
    }
  }

  /* Update absolute time */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   */
  m3_core_M->Timing.taskTime0 =
    (++m3_core_M->Timing.clockTick0) * m3_core_M->Timing.stepSize0;
}

/* Model step function for TID1 */
void m3_core_step1(void)               /* Sample time: [0.1s, 0.0s] */
{
  uint16_T varargout_1[8];
  int32_T i;

  /* Start for MATLABSystem: '<Root>/UDP Send1' incorporates:
   *  Constant: '<Root>/Constant'
   *  MATLABSystem: '<Root>/UDP Send1'
   */
  ARM_TransmitUdpPacket((uint32_T)m3_core_BlockingMode, (uint32_T)
                        m3_core_RemoteIPPort_, m3_core_P.Constant_Value, 16U);

  /* MATLABSystem: '<Root>/UDP Receive' incorporates:
   *  Start for MATLABSystem: '<Root>/UDP Receive'
   */
  m3_core_B.UDPReceive_o2 = ARM_ReceiveUdpPacket((uint32_T)m3_core_BlockingMode,
    (uint32_T)m3_core_LocalIPPort_, varargout_1, 16U);
  for (i = 0; i < 8; i++) {
    m3_core_B.UDPReceive_o1[i] = varargout_1[i];
  }

  /* End of MATLABSystem: '<Root>/UDP Receive' */
  rtExtModeUpload(1, ((m3_core_M->Timing.clockTick1) * 0.1));

  /* Update absolute time */
  /* The "clockTick1" counts the number of times the code of this task has
   * been executed. The resolution of this integer timer is 0.1, which is the step size
   * of the task. Size of "clockTick1" ensures timer will not overflow during the
   * application lifespan selected.
   */
  m3_core_M->Timing.clockTick1++;
}

/* Model step function for TID2 */
void m3_core_step2(void)               /* Sample time: [0.25s, 0.0s] */
{
  real_T rtb_PulseGenerator;

  /* DiscretePulseGenerator: '<S1>/Pulse Generator' */
  rtb_PulseGenerator = (m3_core_DW.clockTickCounter <
                        m3_core_P.PulseGenerator_Duty) &&
    (m3_core_DW.clockTickCounter >= 0) ? m3_core_P.PulseGenerator_Amp : 0.0;
  if (m3_core_DW.clockTickCounter >= m3_core_P.PulseGenerator_Period - 1.0) {
    m3_core_DW.clockTickCounter = 0;
  } else {
    m3_core_DW.clockTickCounter++;
  }

  /* End of DiscretePulseGenerator: '<S1>/Pulse Generator' */

  /* S-Function (concerto_do_write): '<S1>/Digital Output2' incorporates:
   *  DataTypeConversion: '<S1>/Data Type Conversion2'
   */
  MW_GPIOPinWrite(2U, 128U, (uint8_T)(rtb_PulseGenerator != 0.0), 7U);
  rtExtModeUpload(2, ((m3_core_M->Timing.clockTick2) * 0.25));

  /* Update absolute time */
  /* The "clockTick2" counts the number of times the code of this task has
   * been executed. The resolution of this integer timer is 0.25, which is the step size
   * of the task. Size of "clockTick2" ensures timer will not overflow during the
   * application lifespan selected.
   */
  m3_core_M->Timing.clockTick2++;
}

/* Model initialize function */
void m3_core_initialize(void)
{
  /* Registration code */

  /* initialize real-time model */
  (void) memset((void *)m3_core_M, 0,
                sizeof(RT_MODEL_m3_core_T));
  rtmSetTFinal(m3_core_M, -1);
  m3_core_M->Timing.stepSize0 = 0.05;

  /* External mode info */
  m3_core_M->Sizes.checksums[0] = (1468656801U);
  m3_core_M->Sizes.checksums[1] = (3008255270U);
  m3_core_M->Sizes.checksums[2] = (1200553158U);
  m3_core_M->Sizes.checksums[3] = (704796611U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[3];
    m3_core_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(m3_core_M->extModeInfo,
      &m3_core_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(m3_core_M->extModeInfo, m3_core_M->Sizes.checksums);
    rteiSetTPtr(m3_core_M->extModeInfo, rtmGetTPtr(m3_core_M));
  }

  /* block I/O */
  (void) memset(((void *) &m3_core_B), 0,
                sizeof(B_m3_core_T));

  /* states (dwork) */
  (void) memset((void *)&m3_core_DW, 0,
                sizeof(DW_m3_core_T));

  /* data type transition information */
  {
    static DataTypeTransInfo dtInfo;
    (void) memset((char_T *) &dtInfo, 0,
                  sizeof(dtInfo));
    m3_core_M->SpecialInfo.mappingInfo = (&dtInfo);
    dtInfo.numDataTypes = 16;
    dtInfo.dataTypeSizes = &rtDataTypeSizes[0];
    dtInfo.dataTypeNames = &rtDataTypeNames[0];

    /* Block I/O transition table */
    dtInfo.BTransTable = &rtBTransTable;

    /* Parameters transition table */
    dtInfo.PTransTable = &rtPTransTable;
  }

  {
    static const char_T tmp[8] = { '0', '.', '0', '.', '0', '.', '0', '\x00' };

    static const char_T tmp_0[16] = { '2', '5', '5', '.', '2', '5', '5', '.',
      '2', '5', '5', '.', '2', '5', '5', '\x00' };

    char_T tmp_1[8];
    char_T tmp_2[16];
    int32_T i;

    /* Start for MATLABSystem: '<Root>/UDP Send1' */
    m3_core_DW.obj_c.isInitialized = 0;
    m3_core_DW.obj_c.isInitialized = 1;
    for (i = 0; i < 16; i++) {
      tmp_2[i] = tmp_0[i];
    }

    ARM_UDP_Initialize((int32_T)m3_core_LocalIPPort__p, tmp_2, (uint32_T)
                       m3_core_RemoteIPPort_);

    /* End of Start for MATLABSystem: '<Root>/UDP Send1' */

    /* Start for MATLABSystem: '<Root>/UDP Receive' */
    m3_core_DW.obj.isInitialized = 0;
    m3_core_DW.obj.isInitialized = 1;
    for (i = 0; i < 8; i++) {
      tmp_1[i] = tmp[i];
    }

    ARM_UDP_Initialize((int32_T)m3_core_LocalIPPort_, tmp_1, 0);

    /* End of Start for MATLABSystem: '<Root>/UDP Receive' */

    /* Start for DiscretePulseGenerator: '<S1>/Pulse Generator' */
    m3_core_DW.clockTickCounter = 0;

    /* Start for S-Function (concerto_do_write): '<S1>/Digital Output2' */
    MW_GPIOPinConfigureCoreSelect(2U, 128U, 0U);
    MW_GPIO_Init(2U, 128U, 1U);
    MW_GPIOPinWrite(2U, 128U, 1U, 7U);
  }
}

/* Model terminate function */
void m3_core_terminate(void)
{
  /* Start for MATLABSystem: '<Root>/UDP Send1' incorporates:
   *  Terminate for MATLABSystem: '<Root>/UDP Send1'
   */
  if (m3_core_DW.obj_c.isInitialized == 1) {
    m3_core_DW.obj_c.isInitialized = 2;
  }

  /* End of Start for MATLABSystem: '<Root>/UDP Send1' */

  /* Start for MATLABSystem: '<Root>/UDP Receive' incorporates:
   *  Terminate for MATLABSystem: '<Root>/UDP Receive'
   */
  if (m3_core_DW.obj.isInitialized == 1) {
    m3_core_DW.obj.isInitialized = 2;
  }

  /* End of Start for MATLABSystem: '<Root>/UDP Receive' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
