/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: m3_core.h
 *
 * Code generated for Simulink model 'm3_core'.
 *
 * Model version                  : 1.91
 * Simulink Coder version         : 8.11 (R2016b) 25-Aug-2016
 * C/C++ source code generated on : Thu Sep 27 00:27:58 2018
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: ARM Compatible->ARM Cortex
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#ifndef RTW_HEADER_m3_core_h_
#define RTW_HEADER_m3_core_h_
#include <float.h>
#include <string.h>
#include <stddef.h>
#ifndef m3_core_COMMON_INCLUDES_
# define m3_core_COMMON_INCLUDES_
#include "rtwtypes.h"
#include "rtw_extmode.h"
#include "sysran_types.h"
#include "dt_info.h"
#include "ext_work.h"
#include "concerto_ethernet_wrapper.h"
#include "hw_types.h"
#include "concerto_gpio_wrapper.h"
#endif                                 /* m3_core_COMMON_INCLUDES_ */

#include "m3_core_types.h"

/* Shared type includes */
#include "multiword_types.h"
#include "MW_target_hardware_resources.h"

/* Macros for accessing real-time model data structure */
#ifndef rtmGetFinalTime
# define rtmGetFinalTime(rtm)          ((rtm)->Timing.tFinal)
#endif

#ifndef rtmGetRTWExtModeInfo
# define rtmGetRTWExtModeInfo(rtm)     ((rtm)->extModeInfo)
#endif

#ifndef rtmGetErrorStatus
# define rtmGetErrorStatus(rtm)        ((rtm)->errorStatus)
#endif

#ifndef rtmSetErrorStatus
# define rtmSetErrorStatus(rtm, val)   ((rtm)->errorStatus = (val))
#endif

#ifndef rtmStepTask
# define rtmStepTask(rtm, idx)         ((rtm)->Timing.TaskCounters.TID[(idx)] == 0)
#endif

#ifndef rtmGetStopRequested
# define rtmGetStopRequested(rtm)      ((rtm)->Timing.stopRequestedFlag)
#endif

#ifndef rtmSetStopRequested
# define rtmSetStopRequested(rtm, val) ((rtm)->Timing.stopRequestedFlag = (val))
#endif

#ifndef rtmGetStopRequestedPtr
# define rtmGetStopRequestedPtr(rtm)   (&((rtm)->Timing.stopRequestedFlag))
#endif

#ifndef rtmGetT
# define rtmGetT(rtm)                  ((rtm)->Timing.taskTime0)
#endif

#ifndef rtmGetTFinal
# define rtmGetTFinal(rtm)             ((rtm)->Timing.tFinal)
#endif

#ifndef rtmTaskCounter
# define rtmTaskCounter(rtm, idx)      ((rtm)->Timing.TaskCounters.TID[(idx)])
#endif

/* Block signals (auto storage) */
typedef struct {
  uint16_T UDPReceive_o1[8];           /* '<Root>/UDP Receive' */
  uint8_T UDPReceive_o2;               /* '<Root>/UDP Receive' */
} B_m3_core_T;

/* Block states (auto storage) for system '<Root>' */
typedef struct {
  void *UDPSend1_PWORK;                /* '<Root>/UDP Send1' */
  void *UDPReceive_PWORK;              /* '<Root>/UDP Receive' */
  int32_T clockTickCounter;            /* '<S1>/Pulse Generator' */
  concerto_UdpReceive_m3_core_T obj;   /* '<Root>/UDP Receive' */
  concerto_UdpSend_m3_core_T obj_c;    /* '<Root>/UDP Send1' */
} DW_m3_core_T;

/* Parameters (auto storage) */
struct P_m3_core_T_ {
  real_T PulseGenerator_Amp;           /* Expression: 1
                                        * Referenced by: '<S1>/Pulse Generator'
                                        */
  real_T PulseGenerator_Period;        /* Computed Parameter: PulseGenerator_Period
                                        * Referenced by: '<S1>/Pulse Generator'
                                        */
  real_T PulseGenerator_Duty;          /* Computed Parameter: PulseGenerator_Duty
                                        * Referenced by: '<S1>/Pulse Generator'
                                        */
  real_T PulseGenerator_PhaseDelay;    /* Expression: 0
                                        * Referenced by: '<S1>/Pulse Generator'
                                        */
  uint16_T Constant_Value[8];          /* Computed Parameter: Constant_Value
                                        * Referenced by: '<Root>/Constant'
                                        */
};

/* Real-time Model Data Structure */
struct tag_RTM_m3_core_T {
  const char_T *errorStatus;
  RTWExtModeInfo *extModeInfo;

  /*
   * Sizes:
   * The following substructure contains sizes information
   * for many of the model attributes such as inputs, outputs,
   * dwork, sample times, etc.
   */
  struct {
    uint32_T checksums[4];
  } Sizes;

  /*
   * SpecialInfo:
   * The following substructure contains special information
   * related to other components that are dependent on RTW.
   */
  struct {
    const void *mappingInfo;
  } SpecialInfo;

  /*
   * Timing:
   * The following substructure contains information regarding
   * the timing information for the model.
   */
  struct {
    time_T taskTime0;
    uint32_T clockTick0;
    time_T stepSize0;
    uint32_T clockTick1;
    uint32_T clockTick2;
    struct {
      uint8_T TID[3];
    } TaskCounters;

    time_T tFinal;
    boolean_T stopRequestedFlag;
  } Timing;
};

/* Block parameters (auto storage) */
extern P_m3_core_T m3_core_P;

/* Block signals (auto storage) */
extern B_m3_core_T m3_core_B;

/* Block states (auto storage) */
extern DW_m3_core_T m3_core_DW;

/* External function called from main */
extern void m3_core_SetEventsForThisBaseStep(boolean_T *eventFlags);

/* Model entry point functions */
extern void m3_core_SetEventsForThisBaseStep(boolean_T *eventFlags);
extern void m3_core_initialize(void);
extern void m3_core_step0(void);
extern void m3_core_step1(void);
extern void m3_core_step2(void);
extern void m3_core_terminate(void);

/* Real-time Model object */
extern RT_MODEL_m3_core_T *const m3_core_M;

/*-
 * The generated code includes comments that allow you to trace directly
 * back to the appropriate location in the model.  The basic format
 * is <system>/block_name, where system is the system number (uniquely
 * assigned by Simulink) and block_name is the name of the block.
 *
 * Use the MATLAB hilite_system command to trace the generated code back
 * to the model.  For example,
 *
 * hilite_system('<S3>')    - opens system 3
 * hilite_system('<S3>/Kp') - opens and selects block Kp which resides in S3
 *
 * Here is the system hierarchy for this model
 *
 * '<Root>' : 'm3_core'
 * '<S1>'   : 'm3_core/LED BLink '
 */
#endif                                 /* RTW_HEADER_m3_core_h_ */

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
